/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.connector.annotation.handlers;

import com.sun.enterprise.deployment.CommonResourceBundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.Stateless;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;
import org.glassfish.webservices.connector.LogUtils;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=WebServiceProvider.class)
public class WebServiceProviderHandler
extends AbstractHandler {
    private static final Logger conLogger = LogUtils.getLogger();
    private static final LocalStringManagerImpl wsLocalStrings = new LocalStringManagerImpl(WebServiceProviderHandler.class);

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        WebService newWS;
        WebServicesDescriptor wsDesc;
        WebServiceEndpoint endpoint;
        String portName;
        String targetNameSpace;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        boolean ejbInWar = this.ignoreWebserviceAnnotations(annElem, annCtx);
        if (ejbInWar) {
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        if (!(annElem instanceof Class)) {
            AnnotationProcessorException ape = new AnnotationProcessorException("@WebServiceProvider can only be specified on TYPE", annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        if (this.isJaxwsRIDeployment(annInfo)) {
            conLogger.log(Level.INFO, "AS-WSCONNECTOR-00057", new Object[]{annInfo.getProcessingContext().getArchive().getName(), "WEB-INF/sun-jaxws.xml"});
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        if (!Provider.class.isAssignableFrom((Class)annElem)) {
            AnnotationProcessorException ape = new AnnotationProcessorException(annElem.toString() + "does not implement the javax.xml.ws.Provider interface", annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        WebServiceProvider ann = (WebServiceProvider)annInfo.getAnnotation();
        CommonResourceBundleDescriptor bundleDesc = null;
        try {
            if (this.ejbProvider != null && this.ejbProvider.getType("javax.ejb.Stateless") != null) {
                if (annCtx instanceof EjbContext) {
                    EjbContext ctx = (EjbContext)annCtx;
                    bundleDesc = ctx.getDescriptor().getEjbBundleDescriptor();
                    bundleDesc.setSpecVersion("3.0");
                } else if (annCtx instanceof EjbsContext) {
                    String name = this.getEjbName(annElem);
                    for (EjbContext ejbCtx : ((EjbsContext)annCtx).getEjbContexts()) {
                        EjbDescriptor descriptor = ejbCtx.getDescriptor();
                        if (!name.equals(descriptor.getName())) continue;
                        bundleDesc = descriptor.getEjbBundleDescriptor();
                        bundleDesc.setSpecVersion("3.0");
                        break;
                    }
                }
            }
            if (bundleDesc == null) {
                if (annCtx instanceof WebComponentContext) {
                    bundleDesc = ((WebComponentContext)annCtx).getDescriptor().getWebBundleDescriptor();
                } else if (!(annCtx instanceof WebBundleContext)) {
                    return this.getInvalidAnnotatedElementHandlerResult(annInfo.getProcessingContext().getHandler(), annInfo);
                }
                bundleDesc = ((WebBundleContext)annCtx).getDescriptor();
                bundleDesc.setSpecVersion("2.5");
            }
        }
        catch (Exception e) {
            throw new AnnotationProcessorException(wsLocalStrings.getLocalString("webservice.annotation.exception", "WS00023: Exception in processing @Webservice : {0}", new Object[]{e.getMessage()}));
        }
        String portComponentName = ((Class)annElem).getName();
        String svcName = ann.serviceName();
        if (svcName == null) {
            svcName = "";
        }
        String userSpecifiedBinding = null;
        BindingType bindingAnn = ((Class)annElem).getAnnotation(BindingType.class);
        if (bindingAnn != null) {
            userSpecifiedBinding = bindingAnn.value();
        }
        if ((targetNameSpace = ann.targetNamespace()) == null) {
            targetNameSpace = "";
        }
        if ((portName = ann.portName()) == null) {
            portName = "";
        }
        if ((endpoint = (wsDesc = bundleDesc.getWebServices()).getEndpointByName(portComponentName)) == null) {
            newWS = svcName.length() != 0 ? wsDesc.getWebServiceByName(svcName) : wsDesc.getWebServiceByName(((Class)annElem).getSimpleName());
            if (newWS == null) {
                newWS = new WebService();
                if (svcName.length() != 0) {
                    newWS.setName(svcName);
                } else {
                    newWS.setName(((Class)annElem).getSimpleName());
                }
                wsDesc.addWebService(newWS);
            }
            endpoint = new WebServiceEndpoint();
            endpoint.setEndpointName(portComponentName);
            newWS.addEndpoint(endpoint);
            wsDesc.setSpecVersion("1.3");
        } else {
            newWS = endpoint.getWebService();
        }
        if (endpoint.getWsdlService() != null) {
            if (targetNameSpace.length() > 0 && !endpoint.getWsdlService().getNamespaceURI().equals(targetNameSpace)) {
                throw new AnnotationProcessorException("Target Namespace inwsdl-service element does not match @WebService.targetNamespace", annInfo);
            }
            targetNameSpace = endpoint.getWsdlService().getNamespaceURI();
        }
        if (!endpoint.hasUserSpecifiedProtocolBinding() && userSpecifiedBinding != null && userSpecifiedBinding.length() != 0) {
            endpoint.setProtocolBinding(userSpecifiedBinding);
        }
        if (newWS.getWsdlFileUri() == null && ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
            newWS.setWsdlFileUri(ann.wsdlLocation());
        }
        annElem = annInfo.getAnnotatedElement();
        Class clz = (Class)annElem;
        Class<?> serviceEndpointIntf = null;
        for (Class<?> intf : clz.getInterfaces()) {
            if (!Provider.class.isAssignableFrom(intf)) continue;
            serviceEndpointIntf = intf;
            break;
        }
        if (serviceEndpointIntf == null) {
            endpoint.setServiceEndpointInterface("javax.xml.ws.Provider");
        } else {
            endpoint.setServiceEndpointInterface(serviceEndpointIntf.getName());
        }
        if (DOLUtils.warType().equals((Object)bundleDesc.getModuleType())) {
            if (endpoint.getServletImplClass() == null) {
                endpoint.setServletImplClass(((Class)annElem).getName());
            }
            WebBundleDescriptor webBundle = (WebBundleDescriptor)bundleDesc;
            if (endpoint.getWebComponentLink() == null) {
                endpoint.setWebComponentLink(portComponentName);
            }
            if (endpoint.getWebComponentImpl() == null) {
                WebComponentDescriptor[] wcs;
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(endpoint.getWebComponentLink());
                if (webComponent == null && (wcs = webBundle.getWebComponentByImplName(((Class)annElem).getCanonicalName())).length > 0) {
                    webComponent = wcs[0];
                }
                if (webComponent == null) {
                    webComponent = new WebComponentDescriptorImpl();
                    webComponent.setServlet(true);
                    webComponent.setWebComponentImplementation(((Class)annElem).getCanonicalName());
                    webComponent.setName(endpoint.getEndpointName());
                    webComponent.addUrlPattern("/" + newWS.getName());
                    webBundle.addWebComponentDescriptor(webComponent);
                }
                endpoint.setWebComponentImpl(webComponent);
            }
        } else {
            String name = this.getEjbName(annElem);
            EjbDescriptor ejb = ((EjbBundleDescriptor)bundleDesc).getEjbByName(name);
            endpoint.setEjbComponentImpl(ejb);
            ejb.setWebServiceEndpointInterfaceName(endpoint.getServiceEndpointInterface());
            if (endpoint.getEjbLink() == null) {
                endpoint.setEjbLink(ejb.getName());
            }
        }
        if (endpoint.getWsdlPort() == null) {
            endpoint.setWsdlPort(new QName(targetNameSpace, portName, "ns1"));
        }
        if (endpoint.getWsdlService() == null) {
            endpoint.setWsdlService(new QName(targetNameSpace, svcName, "ns1"));
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    private boolean isJaxwsRIDeployment(AnnotationInfo annInfo) {
        boolean riDeployment = false;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        try {
            ReadableArchive moduleArchive = annInfo.getProcessingContext().getArchive();
            if (moduleArchive != null && moduleArchive.exists("WEB-INF/sun-jaxws.xml") && !((Class)annInfo.getAnnotatedElement()).isInterface() && (annCtx instanceof WebBundleContext || annCtx instanceof WebComponentContext)) {
                riDeployment = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return riDeployment;
    }

    private boolean ignoreWebserviceAnnotations(AnnotatedElement annElem, AnnotatedElementHandler annCtx) {
        Stateless stateless = annElem.getAnnotation(Stateless.class);
        WebServiceProvider webservice = annElem.getAnnotation(WebServiceProvider.class);
        return stateless != null && webservice != null && (annCtx instanceof WebBundleContext || annCtx instanceof WebComponentContext);
    }

    private String getEjbName(AnnotatedElement annElem) {
        Singleton singleton;
        Stateless stateless;
        block5: {
            block4: {
                stateless = null;
                try {
                    stateless = annElem.getAnnotation(Stateless.class);
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.FINE)) break block4;
                    conLogger.log(Level.FINE, "AS-WSCONNECTOR-00050", e);
                }
            }
            singleton = null;
            try {
                singleton = annElem.getAnnotation(Singleton.class);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.FINE)) break block5;
                conLogger.log(Level.FINE, "AS-WSCONNECTOR-00050", e);
            }
        }
        String name = stateless != null && (stateless.name() == null || stateless.name().length() > 0) ? stateless.name() : (singleton != null && (singleton.name() == null || singleton.name().length() > 0) ? singleton.name() : ((Class)annElem).getSimpleName());
        return name;
    }
}

