/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.dtd;

import com.sun.tools.xjc.reader.dtd.Block;
import com.sun.tools.xjc.reader.dtd.Term;
import java.util.ArrayList;
import java.util.List;

final class ModelGroup
extends Term {
    Kind kind;
    private final List<Term> terms = new ArrayList<Term>();

    ModelGroup() {
    }

    @Override
    void normalize(List<Block> r, boolean optional) {
        switch (this.kind) {
            case SEQUENCE: {
                for (Term t : this.terms) {
                    t.normalize(r, optional);
                }
                return;
            }
            case CHOICE: {
                Block b = new Block(this.isOptional() || optional, this.isRepeated());
                this.addAllElements(b);
                r.add(b);
                return;
            }
        }
    }

    @Override
    void addAllElements(Block b) {
        for (Term t : this.terms) {
            t.addAllElements(b);
        }
    }

    @Override
    boolean isOptional() {
        switch (this.kind) {
            case SEQUENCE: {
                for (Term t : this.terms) {
                    if (t.isOptional()) continue;
                    return false;
                }
                return true;
            }
            case CHOICE: {
                for (Term t : this.terms) {
                    if (!t.isOptional()) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    boolean isRepeated() {
        switch (this.kind) {
            case SEQUENCE: {
                return true;
            }
            case CHOICE: {
                for (Term t : this.terms) {
                    if (!t.isRepeated()) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    void setKind(short connectorType) {
        Kind k;
        switch (connectorType) {
            case 1: {
                k = Kind.SEQUENCE;
                break;
            }
            case 0: {
                k = Kind.CHOICE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        assert (this.kind == null || k == this.kind);
        this.kind = k;
    }

    void addTerm(Term t) {
        if (t instanceof ModelGroup) {
            ModelGroup mg = (ModelGroup)t;
            if (mg.kind == this.kind) {
                this.terms.addAll(mg.terms);
                return;
            }
        }
        this.terms.add(t);
    }

    Term wrapUp() {
        switch (this.terms.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                assert (this.kind == null);
                return this.terms.get(0);
            }
        }
        assert (this.kind != null);
        return this;
    }

    static enum Kind {
        CHOICE,
        SEQUENCE;

    }
}

