/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.disk.ObjectInputStreamCallback;
import com.sun.messaging.jmq.io.txnlog.CheckPointListener;
import com.sun.messaging.jmq.io.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.io.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.io.txnlog.file.FileTransactionLogWriter;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.DiskFileStore;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.persist.api.util.MQObjectInputStream;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.ConfigChangeRecord;
import com.sun.messaging.jmq.jmsserver.persist.file.DestinationListStore;
import com.sun.messaging.jmq.jmsserver.persist.file.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.PropertiesFile;
import com.sun.messaging.jmq.jmsserver.persist.file.TidList;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.persist.file.TxnConversionUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.persist.file.FileStore")
@Singleton
public class FileStore
extends Store
implements PartitionedStore,
TxnLoggingStore,
DiskFileStore,
CheckPointListener,
ObjectInputStreamCallback {
    public static final int OLD_STORE_VERSION_200 = 200;
    public static final int OLD_STORE_VERSION = 350;
    public static final int STORE_VERSION = 370;
    static final String FILE_PROP_PREFIX = "imq.persist.file.";
    static final String SYNC_ENABLED_PROP = "imq.persist.file.sync.enabled";
    static final String SYNC_ALL_PROP = "imq.persist.file.sync.all";
    static final boolean DEFAULT_SYNC_ENABLED = false;
    static final boolean DEFAULT_SYNC_ALL = false;
    static final String TXNLOG_FILE_SIZE_PROP = "imq.persist.file.txnLog.file.size";
    static final long DEFAULT_TXNLOG_FILE_SIZE = 10240L;
    static final String FILESTORE_BASENAME = "fs";
    static final String FILESTORE_TOP = "fs370";
    static final String FILESTORE350_TOP = "fs350";
    static final String FILESTORE200_TOP = "filestore";
    static final String VERSIONFILE = "version";
    static final boolean syncEnabled = config.getBooleanProperty("imq.persist.file.sync.enabled", false);
    static final boolean syncAll = config.getBooleanProperty("imq.persist.file.sync.all", false);
    static final String NO_SYNC_FOR_DELIVERY_STATE_UPDATE = "imq.persist.file.noSyncForDeliveryStateUpdate";
    static final boolean noSyncForDeliveryStateUpdate = config.getBooleanProperty("imq.persist.file.noSyncForDeliveryStateUpdate", false);
    private File rootDir = null;
    private MsgStore msgStore = null;
    private InterestStore intStore = null;
    private DestinationListStore dstList = null;
    private TidList tidList = null;
    private ConfigChangeRecord configStore = null;
    private PropertiesFile propFile = null;
    private TransactionLogManager txnLogManager = null;
    static final String MSG_LOG_FILENAME = "txnlogmsg";
    static final String ACK_LOG_FILENAME = "txnlogack";
    boolean txnLoggerInited = false;
    private TransactionLogWriter msgLogWriter = null;
    private TransactionLogWriter ackLogWriter = null;
    private UID partitionid = PartitionedStore.DEFAULT_UID;
    private static final ConsumerUID[] emptyiid = new ConsumerUID[0];
    private static final int[] emptystate = new int[0];
    private static FilenameFilter storeFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory() && name.startsWith(FileStore.FILESTORE_BASENAME);
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileStore() throws BrokerException {
        String fstop = Globals.getJMQ_INSTANCES_HOME() + File.separator + Globals.getConfigName() + File.separator;
        logger.logToAll(8, br.getString("B1141", fstop));
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.enabled=" + syncEnabled);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.all=" + syncAll);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.noSyncForDeliveryStateUpdate=" + noSyncForDeliveryStateUpdate);
        }
        String instancename = Globals.getJMQ_INSTANCES_HOME() + File.separator + Globals.getConfigName() + File.separator;
        File instanceDir = new File(instancename);
        int upgrade = this.checkFileStore(instanceDir);
        this.rootDir = new File(instanceDir, FILESTORE_TOP);
        if (this.removeStore) {
            try {
                FileUtil.removeFiles(this.rootDir, true);
                return;
            }
            catch (IOException e) {
                logger.log(32, "B3120", (Object)this.rootDir, (Throwable)e);
                throw new BrokerException(br.getString("B3120", this.rootDir), e);
            }
        }
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            logger.log(32, "B3017", this.rootDir);
            throw new BrokerException(br.getString("B3017", this.rootDir));
        }
        if (upgrade > 0) {
            File oldRoot = null;
            if (Globals.isNewTxnLogEnabled()) {
                Object[] eargs = new String[]{String.valueOf(upgrade), "imq.persist.file.newTxnLog.enabled=true", "imq.persist.file.newTxnLog.enabled=false", "imq.persist.file.newTxnLog.enabled=true"};
                String emsg = Globals.getBrokerResources().getKString("B3281", eargs);
                logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            try {
                Object[] args = new Object[]{370, FILESTORE_TOP};
                logger.logToAll(8, "B1105", args);
                if (this.resetMessage) {
                    logger.logToAll(8, "B1101");
                    logger.logToAll(8, "B1102");
                } else if (this.resetInterest) {
                    logger.logToAll(8, "B1103");
                    logger.logToAll(8, "B1102");
                }
                if (upgrade == 350) {
                    oldRoot = new File(instanceDir, FILESTORE350_TOP);
                    try {
                        FileUtil.copyDirectory(oldRoot, this.rootDir);
                        FileUtil.removeFiles(new File(this.rootDir, "txn"), false);
                        FileUtil.removeFiles(new File(this.rootDir, "txnack"), false);
                    }
                    catch (IOException e) {
                        String errorMsg = "Failed to copy old persistent data under " + oldRoot + " to " + this.rootDir;
                        logger.log(32, errorMsg, e);
                        throw new BrokerException(errorMsg, e);
                    }
                } else {
                    oldRoot = new File(instanceDir, FILESTORE200_TOP);
                    throw new BrokerException("Upgrade from old store version 200 is not supported:" + oldRoot);
                }
                this.dstList = new DestinationListStore(this, this.rootDir, false);
                this.msgStore = new MsgStore(this, this.rootDir, this.resetMessage);
                this.intStore = new InterestStore(this, this.rootDir, this.resetInterest);
                this.tidList = new TidList(this, this.rootDir, oldRoot);
                this.configStore = new ConfigChangeRecord(this.rootDir, false);
                this.propFile = new PropertiesFile(this, this.rootDir, false);
                if (Store.getDEBUG()) {
                    logger.log(4, "FileStore upgraded successfully.");
                }
                if (this.upgradeNoBackup) {
                    try {
                        FileUtil.removeFiles(oldRoot, true);
                    }
                    catch (IOException e2) {
                        logger.log(32, "B3120", (Object)oldRoot, (Throwable)e2);
                    }
                }
                logger.logToAll(8, "B1106");
                if (this.upgradeNoBackup) return;
                logger.logToAll(8, "B1099", oldRoot);
                return;
            }
            catch (BrokerException e) {
                logger.log(8, "B1110", this.rootDir);
                try {
                    FileUtil.removeFiles(this.rootDir, true);
                    throw e;
                }
                catch (IOException e2) {
                    logger.log(32, "B3120", (Object)this.rootDir, (Throwable)e);
                }
                throw e;
            }
        }
        this.dstList = new DestinationListStore(this, this.rootDir, this.resetStore);
        this.msgStore = new MsgStore(this, this.rootDir, this.resetStore || this.resetMessage);
        this.intStore = new InterestStore(this, this.rootDir, this.resetStore || this.resetInterest);
        if (this.resetStore) {
            TxnConversionUtil.resetAllTransactionState(this.rootDir);
        }
        boolean isNewTxnLogEnabled = Globals.isNewTxnLogEnabled();
        TxnConversionUtil.checkForIncompleteTxnConversion(this.rootDir, isNewTxnLogEnabled);
        if (!isNewTxnLogEnabled || TxnConversionUtil.isTxnConversionRequired()) {
            this.tidList = new TidList(this, this.rootDir, this.resetStore);
        }
        if (isNewTxnLogEnabled || TxnConversionUtil.isTxnConversionRequired()) {
            this.txnLogManager = new TransactionLogManager(this, this.msgStore, this.rootDir, this.resetStore);
        }
        this.configStore = new ConfigChangeRecord(this.rootDir, this.resetStore);
        this.propFile = new PropertiesFile(this, this.rootDir, this.resetStore);
        if (!Store.getDEBUG()) return;
        logger.log(4, "FileStore instantiated successfully.");
    }

    @Override
    public ObjectInputStream getObjectInputStream(ByteArrayInputStream bis) throws IOException {
        return new MQObjectInputStream(bis);
    }

    void closeTidList() {
        if (this.tidList != null) {
            this.tidList.close(true);
        }
    }

    void closeTxnLogManager() {
        this.txnLogManager.close();
    }

    @Override
    public void convertTxnFormats(TransactionList transactionList) throws BrokerException, IOException {
        TxnConversionUtil.convertTxnFormats(this, this.rootDir, transactionList);
    }

    @Override
    public void init() throws BrokerException {
        if (this.txnLogManager != null) {
            this.txnLogManager.startup();
        }
    }

    public FileStore(String dir, boolean clean) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.enabled=" + syncEnabled);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.all=" + syncAll);
        }
        logger.log(8, br.getString("B1141", dir));
        this.rootDir = new File(dir, FILESTORE_TOP);
        if (clean) {
            try {
                FileUtil.removeFiles(this.rootDir, false);
                return;
            }
            catch (IOException e) {
                logger.log(32, "B3120", (Object)this.rootDir, (Throwable)e);
                throw new BrokerException(br.getString("B3120", this.rootDir), e);
            }
        }
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            logger.log(32, "B3017", this.rootDir.toString());
            throw new BrokerException(br.getString("B3017", this.rootDir.toString()));
        }
        this.dstList = new DestinationListStore(this, this.rootDir, false);
        this.msgStore = new MsgStore(this, this.rootDir, false);
        this.intStore = new InterestStore(this, this.rootDir, false);
        this.tidList = new TidList(this, this.rootDir, false);
        this.configStore = new ConfigChangeRecord(this.rootDir, false);
        this.propFile = new PropertiesFile(this, this.rootDir, false);
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore instantiated successfully.");
        }
    }

    @Override
    public LoadException getLoadDestinationException() {
        return this.dstList.getLoadException();
    }

    @Override
    public LoadException getLoadConsumerException() {
        return this.intStore.getLoadException();
    }

    @Override
    public LoadException getLoadPropertyException() {
        return this.propFile.getLoadException();
    }

    @Override
    public LoadException getLoadTransactionException() {
        return this.tidList.getLoadException();
    }

    @Override
    public LoadException getLoadTransactionAckException() {
        return this.tidList.getLoadTransactionAckException();
    }

    @Override
    public void close(boolean cleanup) {
        super.setClosedAndWait();
        this.dstList.close(cleanup);
        if (this.tidList != null) {
            this.tidList.close(cleanup);
        }
        this.configStore.close(cleanup);
        this.propFile.close(cleanup);
        this.intStore.close(cleanup);
        this.msgStore.close(cleanup);
        try {
            if (this.msgLogWriter != null) {
                this.msgLogWriter.close();
            }
            if (this.ackLogWriter != null) {
                this.ackLogWriter.close();
            }
        }
        catch (IOException ex) {
            logger.logStack(32, "B3100", "Got IOException while closing transaction log file", (Throwable)ex);
        }
        if (config.getBooleanProperty("imq.persist.file.transaction.memorymappedfile.enabled", true)) {
            for (int i = 0; i < 3; ++i) {
                System.gc();
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.txnLogManager != null) {
            this.txnLogManager.close();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.close(" + cleanup + ") done.");
        }
    }

    @Override
    public void clearAll(boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.clearAll() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.clearAll(sync);
            this.intStore.clearAll(sync);
            this.dstList.clearAll(sync, false);
            if (this.tidList != null) {
                this.tidList.clearAll(sync);
            }
            this.configStore.clearAll(sync);
            this.propFile.clearAll(sync);
            try {
                if (this.msgLogWriter != null) {
                    this.msgLogWriter.reset();
                }
                if (this.ackLogWriter != null) {
                    this.ackLogWriter.reset();
                }
            }
            catch (IOException ex) {
                logger.logStack(32, "B3100", "Got IOException while resetting transaction log file", (Throwable)ex);
            }
            if (Store.getDEBUG()) {
                logger.log(4, "File store cleared");
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public List<BaseTransaction> getIncompleteTransactions(int type) {
        BaseTransactionManager tm = this.txnLogManager.getTransactionManager(type);
        return tm.getAllIncompleteTransactions();
    }

    @Override
    public void rollbackAllTransactions() {
        this.txnLogManager.rollbackAllTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID dst, Packet message, ConsumerUID[] iids, int[] states, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeMessage() with interests called for " + message.getSysMessageID() + " sync= " + sync);
        }
        super.checkClosedAndSetInProgress();
        try {
            if (dst == null || message == null || iids == null || states == null) {
                throw new NullPointerException();
            }
            if (iids.length == 0 || iids.length != states.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeMessage(dst, message, iids, states, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public final int getStoreVersion() {
        return 370;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID dst, Packet message, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeMessage() called for " + message.getSysMessageID() + " sync=" + sync);
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.storeMessage(dst, message, emptyiid, emptystate, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void removeMessage(DestinationUID dID, SysMessageID mID, boolean sync) throws IOException, BrokerException {
        this.removeMessage(dID, mID, sync, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessage(DestinationUID dst, SysMessageID id, boolean sync, boolean onRollback) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.removeMessage() called for " + dst + ";" + id + " sync=" + sync + " onRollback=" + onRollback);
        }
        if (Globals.isNewTxnLogEnabled() && onRollback) {
            return;
        }
        if (id == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled()) {
                this.txnLogManager.getLoggedMessageHelper().preMessageRemoved(dst, id);
            }
            this.msgStore.removeMessage(dst, id, sync);
        }
        finally {
            try {
                if (Globals.isNewTxnLogEnabled()) {
                    this.txnLogManager.getLoggedMessageHelper().postMessageRemoved(dst, id);
                }
            }
            finally {
                super.setInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveMessage(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] ints, int[] states, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.moveMessage() called for: " + message.getSysMessageID() + " from " + from + " to " + to);
        }
        if (message == null || from == null || to == null) {
            throw new NullPointerException();
        }
        if (ints == null) {
            ints = emptyiid;
            states = emptystate;
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.moveMessage(message, from, to, ints, states, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void removeAllMessages(Destination destination, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.removeAllMessages(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeAllMessages(destination.getDestinationUID(), sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Enumeration messageEnumeration(Destination dst) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.messageEnumeration(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgStore.messageEnumeration(dst.getDestinationUID());
            return enumeration;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Packet getMessage(DestinationUID dst, String id) throws BrokerException {
        return this.getMessage(dst, SysMessageID.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet getMessage(DestinationUID dst, SysMessageID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getMessage() called");
        }
        if (id == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            Packet packet = this.msgStore.getMessage(dst, id);
            return packet;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void storeInterestStates(DestinationUID dID, SysMessageID mID, ConsumerUID[] iIDs, int[] states, boolean sync) throws BrokerException {
        this.storeInterestStates(dID, mID, iIDs, states, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterestStates(DestinationUID dst, SysMessageID mid, ConsumerUID[] iids, int[] states, boolean sync, Packet msg) throws BrokerException {
        if (Store.getDEBUG()) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < states.length; ++i) {
                b.append(states[i]).append(",");
            }
            logger.log(8, "FileStore.storeInterestStates(" + b + ", " + sync + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (mid == null || iids == null || states == null) {
                throw new NullPointerException();
            }
            if (iids.length == 0 || iids.length != states.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeInterestStates(dst, mid, iids, states, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Deprecated
    public void updateInterestState(DestinationUID dID, SysMessageID mID, ConsumerUID iID, int state, boolean sync) throws BrokerException {
        this.updateInterestState(dID, mID, iID, state, sync, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID cid, int state, boolean sync, TransactionUID txid, boolean isLastAck) throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = "FileStore.updateInterestState() called. mid=" + mid + " state= " + state + " sync=" + sync + " txid=" + txid + " isLastAck= " + isLastAck;
            logger.log(8, msg);
        }
        super.checkClosedAndSetInProgress();
        try {
            if (mid == null || cid == null) {
                throw new NullPointerException();
            }
            if (Globals.isNewTxnLogEnabled() && state == 2) {
                boolean ackLogged = false;
                if (txid != null) {
                    ackLogged = true;
                } else if (TransactionLogManager.logNonTransactedMsgAck) {
                    TransactionWorkMessageAck twma = new TransactionWorkMessageAck(dst, mid, cid);
                    this.txnLogManager.logNonTxnMessageAck(twma);
                    ackLogged = true;
                    sync = false;
                }
                if (ackLogged && isLastAck) {
                    this.txnLogManager.loggedMessageHelper.lastAckLogged(dst, mid);
                } else {
                    this.msgStore.updateInterestState(dst, mid, cid, state, false);
                }
            } else {
                boolean actualSync = sync;
                if (state == 1 && noSyncForDeliveryStateUpdate) {
                    actualSync = false;
                }
                this.msgStore.updateInterestState(dst, mid, cid, state, actualSync);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getInterestState() called");
        }
        if (mid == null || id == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            int n = this.msgStore.getInterestState(dst, mid, id);
            return n;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getInterestStates(DestinationUID did, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getInterestStates() called");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getInterestStates(did, mid);
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID dst, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getConsumerUIDs() called");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            ConsumerUID[] consumerUIDArray = this.msgStore.getConsumerUIDs(dst, mid);
            return consumerUIDArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMessageBeenAcked(DestinationUID dst, SysMessageID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.hasMessageBeenAcked() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            boolean bl = this.msgStore.hasMessageBeenAcked(dst, id);
            return bl;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void storeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeInterest(" + interest + ", " + sync + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.storeInterest(interest, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void removeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.removeInterest(" + interest + ", " + sync + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.removeInterest(interest, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getAllInterests() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Consumer[] consumerArray = this.intStore.getAllInterests();
            return consumerArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void storeDestination(Destination destination, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeDestination(" + destination + ", " + sync + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.storeDestination(destination, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void updateDestination(Destination destination, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.updateDestination(" + destination + ", " + sync + ")");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.updateDestination(destination, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void removeDestination(Destination destination, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.removeDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.removeDestination(destination, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Destination getDestination(DestinationUID id) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            Destination destination = this.dstList.getDestination(id);
            return destination;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getAllDestinations() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.dstList.getAllDestinations();
            return destinationArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransaction(TransactionUID id, TransactionState ts, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeTransaction() called");
        }
        if (Globals.isNewTxnLogEnabled()) {
            if (Store.getDEBUG()) {
                logger.log(8, "FileStore.storeTransaction() isFastLogTransactions true so returning");
            }
            return;
        }
        super.checkClosedAndSetInProgress();
        try {
            if (id == null || ts == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransaction(id, ts, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void removeTransaction(TransactionUID id, boolean sync) throws IOException, BrokerException {
        this.removeTransaction(id, false, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransaction(TransactionUID id, boolean removeAcks, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.removeTransaction() called");
        }
        if (Globals.isNewTxnLogEnabled()) {
            return;
        }
        super.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            if (removeAcks) {
                this.tidList.removeTransactionAck(id, sync);
            }
            this.tidList.removeTransaction(id, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransactionState(TransactionUID id, TransactionState ts, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.updateTransactionState( id=" + id + ", ts=" + ts.getState() + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            if (Globals.isNewTxnLogEnabled()) {
            } else {
                this.tidList.updateTransactionState(id, ts, sync);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void updateTransactionStateWithWork(TransactionUID id, TransactionState ts, TransactionWork txnwork, boolean sync) throws IOException, BrokerException {
        throw new UnsupportedOperationException("updateTransactionStateWithWork() not supported by " + this.getStoreType() + " store");
    }

    @Override
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getAllTransactionStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled() && !TxnConversionUtil.convertingToTxnLog) {
                HashMap hashMap = this.txnLogManager.getAllTransactionStates();
                return hashMap;
            }
            HashMap hashMap = this.tidList.getAllTransactionStates();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransactionAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeTransactionAck() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (tid == null || ack == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransactionAck(tid, ack, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void removeTransactionAck(TransactionUID id, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.removeTransactionAck() called");
        }
        if (Globals.isNewTxnLogEnabled()) {
            return;
        }
        super.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            this.tidList.removeTransactionAck(id, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID tid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getTransactionAcks() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (tid == null) {
                throw new NullPointerException();
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.tidList.getTransactionAcks(tid);
            return transactionAcknowledgementArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getAllTransactionAcks() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled() && !TxnConversionUtil.convertingToTxnLog) {
                HashMap hashMap = new HashMap();
                return hashMap;
            }
            HashMap hashMap = this.tidList.getAllTransactionAcks();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransaction(TransactionUID id, TransactionInfo txnInfo, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.storeTransaction(id, txnInfo, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeClusterTransaction(TransactionUID id, TransactionState ts, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeClusterTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled()) {
            } else {
                this.tidList.storeClusterTransaction(id, ts, txnBrokers, sync);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransaction(TransactionUID id, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.updateClusterTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.updateClusterTransaction(id, txnBrokers, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.updateClusterTransactionBrokerState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionBroker[] transactionBrokerArray = this.tidList.getClusterTransactionBrokers(id);
            return transactionBrokerArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransactionBrokerState(TransactionUID id, int expectedTxnState, TransactionBroker txnBroker, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.updateClusterTransactionBrokerState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled()) {
                this.txnLogManager.getClusterTransactionManager().updateTransactionBrokerState(id, expectedTxnState, txnBroker, sync);
            } else {
                this.tidList.updateTransactionBrokerState(id, expectedTxnState, txnBroker, sync);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeRemoteTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled()) {
                throw new UnsupportedOperationException("storeRemoteTransaction not supported for isFastLogTransactions");
            }
            this.tidList.storeRemoteTransaction(id, ts, txnAcks, txnHomeBroker, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getRemoteTransactionHomeBroker() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            BrokerAddress brokerAddress = this.tidList.getRemoteTransactionHomeBroker(id);
            return brokerAddress;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllRemoteTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getAllRemoteTransactionStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.tidList.getAllRemoteTransactionStates();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public TransactionState getTransactionState(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getTransactionState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionState transactionState = this.tidList.getTransactionState(id);
            return transactionState;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public TransactionInfo getTransactionInfo(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getTransactionInfo() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionInfo transactionInfo = this.tidList.getTransactionInfo(id);
            return transactionInfo;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public Collection getTransactions(String brokerID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getTransactions() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Collection collection = this.tidList.getAllTransactions();
            return collection;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperty(String name, Object value, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.updateProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (name == null) {
                throw new NullPointerException();
            }
            this.propFile.updateProperty(name, value, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Object getProperty(String name) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (name == null) {
                throw new NullPointerException();
            }
            Object object = this.propFile.getProperty(name);
            return object;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getPropertyNames() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            String[] stringArray = this.propFile.getPropertyNames();
            return stringArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getAllProperties() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Properties properties = this.propFile.getProperties();
            return properties;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeConfigChangeRecord(long timestamp, byte[] recordData, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.storeConfigChangeRecord() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (timestamp <= 0L) {
                logger.log(32, "B3074", timestamp);
                throw new BrokerException(br.getString("B3074", timestamp));
            }
            if (recordData == null) {
                throw new NullPointerException();
            }
            this.configStore.storeConfigChangeRecord(timestamp, recordData, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long timestamp) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getConfigChangeRecordsSince() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList<ChangeRecordInfo> arrayList = this.configStore.getConfigChangeRecordsSince(timestamp);
            return arrayList;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getAllConfigRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            List<ChangeRecordInfo> list = this.configStore.getAllConfigRecords();
            return list;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void clearAllConfigChangeRecords(boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.clearAllConfigChangeRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.configStore.clearAll(sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getMessageStorageInfo(Destination dst) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getMessageStorageInfo(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            DestinationUID dstID = dst.getDestinationUID();
            HashMap<String, Number> data = new HashMap<String, Number>(2);
            data.put("numMsgs", this.msgStore.getMessageCount(dstID));
            data.put("totalMsgBytes", this.msgStore.getByteCount(dstID));
            HashMap<String, Number> hashMap = data;
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public String getStoreType() {
        return "file";
    }

    @Override
    public boolean isJDBCStore() {
        return false;
    }

    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.getStorageInfo(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getStorageInfo(destination);
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("File-based store", this.rootDir.getPath());
        t.put("Store version", String.valueOf(370));
        t.putAll(this.dstList.getDebugState());
        t.putAll(this.msgStore.getDebugState());
        t.putAll(this.intStore.getDebugState());
        if (this.tidList != null) {
            t.putAll(this.tidList.getDebugState());
        }
        t.putAll(this.propFile.getDebugState());
        t.putAll(this.configStore.getDebugState());
        return t;
    }

    @Override
    public void compactDestination(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.compactDestination(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.compactDestination(destination);
        }
        finally {
            super.setInProgress(false);
        }
    }

    protected void syncDestination(Destination dst) throws BrokerException {
        if (dst == null) {
            try {
                Destination[] dlist = this.dstList.getAllDestinations();
                int len = dlist.length;
                for (int i = 0; i < len; ++i) {
                    this.msgStore.sync(dlist[i].getDestinationUID());
                }
            }
            catch (IOException ex) {
                logger.logStack(32, "B3100", "Failed to synchronize message stores", (Throwable)ex);
                throw new BrokerException("B4031", ex);
            }
        } else {
            this.msgStore.sync(dst.getDestinationUID());
        }
    }

    private void syncTransaction(TransactionUID tid) throws BrokerException {
        if (!Globals.isNewTxnLogEnabled()) {
            this.tidList.sync(tid);
            this.tidList.syncTransactionAck(tid);
        }
    }

    @Override
    public void logTxn(int type, byte[] data) throws IOException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.logTxn(type=" + type + ") called");
        }
        if (!this.txnLoggerInited) {
            return;
        }
        if (type == 1) {
            TransactionLogRecord record = this.msgLogWriter.newTransactionLogRecord();
            record.setType(type);
            record.setBody(data);
            this.msgLogWriter.write(record);
        } else {
            TransactionLogRecord record = this.ackLogWriter.newTransactionLogRecord();
            record.setType(type);
            record.setBody(data);
            this.ackLogWriter.write(record);
        }
    }

    public void logNonTxnMessage(TransactionWorkMessage twm) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "FileStore.logNonTxnMessage(" + twm + ") called");
        }
        this.txnLogManager.logNonTxnMessage(twm);
    }

    @Override
    public void logTxn(BaseTransaction baseTxn) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "logTxn(" + baseTxn + ") called");
        }
        this.txnLogManager.logTxn(baseTxn);
    }

    @Override
    public void logTxnCompletion(TransactionUID tid, int state, int type) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "logTxnCompletion(" + tid + ", " + state + ", " + type + ") called");
        }
        this.txnLogManager.logTxnCompletion(tid, state, type);
    }

    @Override
    public void loggedCommitWrittenToMessageStore(TransactionUID tid, int type) {
        if (Store.getDEBUG()) {
            logger.log(8, "loggedCommitWrittenToMessageStore " + tid);
        }
        this.txnLogManager.loggedCommitWrittenToMessageStore(tid, type);
    }

    protected MsgStore getMsgStore() {
        return this.msgStore;
    }

    protected DestinationListStore getDstStore() {
        return this.dstList;
    }

    private int checkFileStore(File topDir) throws BrokerException {
        String[] names;
        int upgrade = 0;
        if (Store.getDEBUG()) {
            logger.log(4, "topDir=" + topDir);
        }
        if ((names = topDir.list(storeFilter)) != null) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i].equals(FILESTORE_TOP) || names[i].equals(FILESTORE350_TOP)) continue;
                File badfs = new File(topDir, names[i]);
                logger.log(32, "B3129", badfs);
                throw new BrokerException(br.getString("B3129", badfs));
            }
        }
        File newRootDir = new File(topDir, FILESTORE_TOP);
        File oldRootDir350 = new File(topDir, FILESTORE350_TOP);
        File oldRootDir200 = new File(topDir, FILESTORE200_TOP);
        boolean storeExist200 = oldRootDir200.exists();
        boolean storeExist350 = oldRootDir350.exists();
        int oldStoreVersion = 200;
        File oldRootDir = oldRootDir200;
        if (storeExist350) {
            oldStoreVersion = 350;
            oldRootDir = oldRootDir350;
        } else if (storeExist200) {
            this.checkOldVersion(new File(oldRootDir, VERSIONFILE), oldStoreVersion);
        }
        if (newRootDir.exists()) {
            if (!this.removeStore) {
                if (storeExist350) {
                    logger.logToAll(8, "B1107", oldRootDir);
                } else if (storeExist200) {
                    logger.logToAll(8, "B1107", oldRootDir);
                }
            }
        } else if (storeExist200 || storeExist350) {
            if (this.removeStore) {
                logger.logToAll(8, "B1104", oldRootDir);
            } else if (this.resetStore) {
                logger.logToAll(8, "B1100", oldRootDir);
                logger.logToAll(8, "B1114");
                try {
                    FileUtil.removeFiles(oldRootDir, true);
                }
                catch (IOException e) {
                    logger.log(32, "B3117", (Object)oldRootDir, (Throwable)e);
                    throw new BrokerException(br.getString("B3117", oldRootDir), e);
                }
            } else {
                logger.logToAll(8, "B1109", oldStoreVersion);
                if (this.upgradeNoBackup && !Broker.getBroker().force) {
                    this.getConfirmation();
                }
                upgrade = oldStoreVersion;
            }
        }
        return upgrade;
    }

    private void checkOldVersion(File versionfile, int version) throws BrokerException {
        if (!versionfile.exists()) {
            logger.log(32, "B3126", versionfile);
            throw new BrokerException(br.getString("B3126", versionfile));
        }
        RandomAccessFile raf = null;
        int integer = 0;
        try {
            raf = new RandomAccessFile(versionfile, "r");
            String str = raf.readLine();
            raf.close();
            try {
                integer = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                logger.log(32, "B3125", str, Integer.toString(version), e);
                throw new BrokerException(br.getString("B3125", str, Integer.toString(version)), e);
            }
            if (integer != version) {
                logger.log(32, "B3125", (Object)str, Integer.toString(version));
                throw new BrokerException(br.getString("B3125", str, Integer.toString(version)));
            }
        }
        catch (IOException e) {
            logger.log(32, "B4114", e);
            throw new BrokerException(br.getString("B4114"), e);
        }
    }

    @Override
    public boolean initTxnLogger() throws BrokerException {
        boolean storeNeedsRestart = false;
        if (this.removeStore || !Globals.txnLogEnabled()) {
            return storeNeedsRestart;
        }
        logger.log(8, "B1269");
        String filename = null;
        try {
            SizeString filesize = config.getSizeProperty(TXNLOG_FILE_SIZE_PROP, 10240L);
            filename = MSG_LOG_FILENAME;
            this.msgLogWriter = new FileTransactionLogWriter(this.rootDir, filename, filesize.getBytes());
            this.msgLogWriter.setCheckPointListener(this);
            filename = ACK_LOG_FILENAME;
            this.ackLogWriter = new FileTransactionLogWriter(this.rootDir, filename, filesize.getBytes());
            this.ackLogWriter.setCheckPointListener(this);
            if (this.resetMessage || this.resetStore) {
                this.msgLogWriter.reset();
                this.ackLogWriter.reset();
                this.txnLoggerInited = true;
                return storeNeedsRestart;
            }
        }
        catch (IOException ex) {
            logger.logStack(32, "B3225", filename, (Throwable)ex);
            throw new BrokerException(br.getString("B3225", filename), ex);
        }
        try {
            TransactionUID tuid;
            TransactionState state;
            String tidStr;
            long tid;
            DataInputStream dis;
            ByteArrayInputStream bis;
            byte[] data;
            int recType;
            TransactionLogRecord rec;
            Iterator itr;
            int count;
            HashSet dstLoadedSet = new HashSet();
            if (this.msgLogWriter.playBackRequired()) {
                storeNeedsRestart = true;
                logger.log(64, "B1270");
                Globals.getCoreLifecycle().initDestinations();
                Globals.getCoreLifecycle().initSubscriptions();
                count = 0;
                itr = this.msgLogWriter.iterator();
                while (itr.hasNext()) {
                    ++count;
                    rec = (TransactionLogRecord)itr.next();
                    recType = rec.getType();
                    if (recType != 1) {
                        logger.log(32, "B3226", (Object)String.valueOf(rec.getSequence()), "record type " + recType + " is invalid");
                        continue;
                    }
                    data = rec.getBody();
                    bis = new ByteArrayInputStream(data);
                    dis = new DataInputStream(bis);
                    tid = dis.readLong();
                    tidStr = String.valueOf(tid);
                    logger.log(64, "B1272", (Object)tidStr, String.valueOf(recType));
                    this.processTxnRecMsgPart(dis, dstLoadedSet);
                    if (tid > 0L && (state = this.tidList.getTransactionState(tuid = new TransactionUID(tid))).getState() != -1 && state.getState() != 6) {
                        logger.log(64, "B1273", tidStr);
                        this.tidList.updateTransactionState(tuid, state, false);
                    }
                    dis.close();
                    bis.close();
                }
                logger.log(64, "B1274", String.valueOf(count));
                logger.flush();
            }
            if (this.ackLogWriter.playBackRequired()) {
                storeNeedsRestart = true;
                logger.log(64, "B1271");
                Globals.getCoreLifecycle().initDestinations();
                Globals.getCoreLifecycle().initSubscriptions();
                count = 0;
                itr = this.ackLogWriter.iterator();
                while (itr.hasNext()) {
                    ++count;
                    rec = (TransactionLogRecord)itr.next();
                    recType = rec.getType();
                    if (recType != 2 && recType != 4) {
                        logger.log(32, "B3226", (Object)String.valueOf(rec.getSequence()), "record type " + recType + " is invalid");
                        continue;
                    }
                    data = rec.getBody();
                    bis = new ByteArrayInputStream(data);
                    dis = new DataInputStream(bis);
                    tid = dis.readLong();
                    tidStr = String.valueOf(tid);
                    logger.log(64, "B1272", (Object)tidStr, String.valueOf(recType));
                    if (recType == 4) {
                        this.processTxnRecMsgPart(dis, dstLoadedSet);
                    }
                    this.processTxnRecAckPart(dis, dstLoadedSet);
                    tuid = new TransactionUID(tid);
                    state = this.tidList.getTransactionState(tuid);
                    if (state.getState() != -1 && state.getState() != 6) {
                        logger.log(64, "B1273", tidStr);
                        this.tidList.updateTransactionState(tuid, state, false);
                    }
                    dis.close();
                    bis.close();
                }
                logger.log(64, "B1275", String.valueOf(count));
                logger.flush();
            }
            if (storeNeedsRestart) {
                for (Destination d : dstLoadedSet) {
                    this.syncDestination(d);
                    d.unload(true);
                }
                dstLoadedSet = null;
                this.tidList.sync(null);
                this.tidList.syncTransactionAck(null);
                this.msgLogWriter.reset();
                this.ackLogWriter.reset();
                logger.log(64, "B1280");
                logger.flush();
            }
        }
        catch (Throwable t) {
            logger.logStack(32, "B3228", t);
            throw new BrokerException(br.getString("B3228"), t);
        }
        this.txnLoggerInited = true;
        return storeNeedsRestart;
    }

    @Override
    public int doCheckpoint(boolean sync) {
        if (Store.getDEBUG()) {
            logger.log(8, "doCheckpoint(" + sync + ") called");
        }
        int status = 0;
        if (Globals.isNewTxnLogEnabled()) {
            if (sync) {
                this.txnLogManager.doCheckpoint();
            } else {
                this.txnLogManager.checkpoint();
            }
        } else if (sync) {
            StoreSyncTask sst = new StoreSyncTask();
            sst.run();
        } else {
            this.checkpoint();
        }
        return status;
    }

    @Override
    public final void checkpoint() {
        if (Store.getDEBUG()) {
            logger.log(8, "checkpoint() called");
        }
        MQTimer timer = Globals.getTimer();
        timer.schedule((TimerTask)new StoreSyncTask(), 1000L);
    }

    private void processTxnRecMsgPart(DataInputStream dis, Set dstLoadedSet) throws IOException, BrokerException {
        int msgCount = dis.readInt();
        for (int i = 0; i < msgCount; ++i) {
            MsgStore msgStore;
            Packet pkt = new Packet(false);
            pkt.generateTimestamp(false);
            pkt.generateSequenceNumber(false);
            pkt.readPacket(dis);
            SysMessageID mid = pkt.getSysMessageID();
            Globals.getDestinationList();
            Destination[] ds = DestinationList.getDestination((PartitionedStore)this, pkt.getDestination(), pkt.getIsQueue() ? 1 : 2, true, true);
            Destination dst = ds[0];
            DestinationUID did = dst.getDestinationUID();
            if (!dstLoadedSet.contains(dst)) {
                dst.load();
                dstLoadedSet.add(dst);
            }
            if ((msgStore = this.getMsgStore()).containsMessage(did, mid)) {
                logger.log(64, "B1276", (Object)mid, did);
                msgStore.removeMessage(did, mid, false);
            } else {
                logger.log(64, "B1277", (Object)mid, dst + "[load]");
            }
            PacketReference pr = PacketReference.createReferenceWithDestination(this, pkt, dst, null);
            try {
                dst.routeNewMessage(pr);
                continue;
            }
            catch (SelectorFormatException e) {
                throw new BrokerException(br.getString("B3227", mid), e);
            }
        }
    }

    private void processTxnRecAckPart(DataInputStream dis, Set dstLoadedSet) throws IOException, BrokerException {
        int ackCount = dis.readInt();
        for (int i = 0; i < ackCount; ++i) {
            String name = dis.readUTF();
            DestinationUID did = new DestinationUID(name);
            SysMessageID mid = new SysMessageID();
            mid.readID(dis);
            ConsumerUID iid = new ConsumerUID(dis.readLong());
            Globals.getDestinationList();
            Destination[] ds = DestinationList.getDestination((PartitionedStore)this, did.getName(), did.isQueue() ? 1 : 2, true, true);
            Destination dst = ds[0];
            if (!dstLoadedSet.contains(dst)) {
                dst.load();
                dstLoadedSet.add(dst);
            }
            if (this.msgStore.containsMessage(did, mid)) {
                logger.log(64, "B1278", (Object)iid, mid);
                if (dst.isQueue() && iid.longValue() != 0L) {
                    this.msgStore.updateInterestState(did, mid, PacketReference.getQueueUID(), 2, false);
                    continue;
                }
                this.msgStore.updateInterestState(did, mid, iid, 2, false);
                continue;
            }
            logger.log(64, "B1279", (Object)iid, mid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncStore(TransactionLogWriter[] logWriters) throws IOException, BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            Object object2 = this.inprogressLock;
            synchronized (object2) {
                while (this.inprogressCount > 0) {
                    try {
                        this.inprogressLock.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            this.syncDestination(null);
            this.syncTransaction(null);
            int len = logWriters.length;
            for (int i = 0; i < len; ++i) {
                logWriters[i].checkpoint();
            }
        }
    }

    protected void syncStoreOnCheckpoint() throws IOException, BrokerException {
        try {
            this.txnLogExclusiveLock.lock();
            this.syncDestination(null);
            this.syncTransaction(null);
        }
        finally {
            this.txnLogExclusiveLock.unlock();
        }
    }

    public TransactionLogManager getTxnLogManager() {
        return this.txnLogManager;
    }

    @Override
    public boolean isTxnConversionRequired() {
        return TxnConversionUtil.isTxnConversionRequired();
    }

    @Override
    public int[] getTransactionUsageInfo(TransactionUID txnID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public long getTransactionAccessedTime(TransactionUID txnID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateTransactionAccessedTime(TransactionUID txnID, long timestamp) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void updateRemoteTransaction(TransactionUID txnUID, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void closeEnumeration(Enumeration en) {
    }

    public String toString() {
        return "[" + this.getStoreType() + "]";
    }

    public int hashCode() {
        return this.partitionid.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof PartitionedStore)) {
            return false;
        }
        return this.getPartitionID().equals(((PartitionedStore)anObject).getPartitionID());
    }

    @Override
    public void init(Store store, UID id, boolean isPrimary) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public UID getPartitionID() {
        return this.partitionid;
    }

    @Override
    public boolean isPrimaryPartition() {
        return true;
    }

    @Override
    public List<PartitionedStore> getAllStorePartitions() throws BrokerException {
        ArrayList<PartitionedStore> list = new ArrayList<PartitionedStore>();
        list.add(this);
        return list;
    }

    @Override
    public PartitionedStore getPrimaryPartition() throws BrokerException {
        return this;
    }

    private class StoreSyncTask
    extends TimerTask {
        private StoreSyncTask() {
        }

        @Override
        public void run() {
            try {
                TransactionLogWriter[] lWriters = new TransactionLogWriter[]{FileStore.this.msgLogWriter, FileStore.this.ackLogWriter};
                FileStore.this.syncStore(lWriters);
            }
            catch (Throwable e) {
                Store.logger.logStack(32, "B3100", "Failed to synchronize persistence store for transaction log checkpoint", e);
            }
        }
    }
}

