/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.CreateDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetDestinationsHandler;
import com.sun.messaging.jmq.jmsserver.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DestinationUtil {
    private static String[] queueCreateAttrs = new String[]{"ConsumerFlowLimit", "LocalOnly", "LimitBehavior", "LocalDeliveryPreferred", "MaxBytesPerMsg", "MaxNumActiveConsumers", "MaxNumBackupConsumers", "MaxNumMsgs", "MaxNumProducers", "MaxTotalMsgBytes", "UseDMQ", "ValidateXMLSchemaEnabled", "XMLSchemaURIList", "NextMessageID"};
    private static String[] topicCreateAttrs = new String[]{"ConsumerFlowLimit", "LocalOnly", "LimitBehavior", "MaxBytesPerMsg", "MaxNumMsgs", "MaxNumProducers", "MaxTotalMsgBytes", "UseDMQ", "ValidateXMLSchemaEnabled", "XMLSchemaURIList"};

    public static int toExternalDestState(int internalDestState) {
        switch (internalDestState) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public static int toInternalDestState(int externalDestState) {
        switch (externalDestState) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public static List getVisibleDestinations() {
        boolean numDests = false;
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator itr = itrs[0];
        ArrayList<Destination> al = new ArrayList<Destination>();
        while (itr.hasNext()) {
            Destination oneDest = (Destination)itr.next();
            if (!DestinationUtil.isVisibleDestination(oneDest)) continue;
            al.add(oneDest);
        }
        return al;
    }

    public static List getVisibleTemporaryDestinations(long connectionID) {
        boolean numDests = false;
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator itr = itrs[0];
        ArrayList<Destination> al = new ArrayList<Destination>();
        while (itr.hasNext()) {
            ConnectionUID cxnId;
            Destination oneDest = (Destination)itr.next();
            if (!DestinationUtil.isVisibleDestination(oneDest) || !oneDest.isTemporary() || (cxnId = oneDest.getConnectionUID()) == null || cxnId.longValue() != connectionID) continue;
            al.add(oneDest);
        }
        return al;
    }

    public static boolean isVisibleDestination(Destination d) {
        return !d.isInternal() && !d.isAdmin() && !d.getDestinationName().equals("__JMQAdmin") && !d.getDestinationName().equals("__JMQBridgeAdmin");
    }

    public static DestinationInfo getDestinationInfo(Destination d) {
        DestinationInfo di = GetDestinationsHandler.getDestinationInfo(d);
        return di;
    }

    public static String toExternalDestLimitBehavior(int internalDestLimitBehavior) {
        switch (internalDestLimitBehavior) {
            case 0: {
                return "FLOW_CONTROL";
            }
            case 1: {
                return "REMOVE_OLDEST";
            }
            case 2: {
                return "REJECT_NEWEST";
            }
            case 3: {
                return "REMOVE_LOW_PRIORITY";
            }
        }
        return "UNKNOWN";
    }

    public static int toInternalDestLimitBehavior(String externalDestLimitBehavior) {
        if (externalDestLimitBehavior.equals("FLOW_CONTROL")) {
            return 0;
        }
        if (externalDestLimitBehavior.equals("REMOVE_OLDEST")) {
            return 1;
        }
        if (externalDestLimitBehavior.equals("REJECT_NEWEST")) {
            return 2;
        }
        if (externalDestLimitBehavior.equals("REMOVE_LOW_PRIORITY")) {
            return 3;
        }
        return -1;
    }

    public static int toInternalPauseType(String externalPauseType) {
        if (externalPauseType.equals("PRODUCERS")) {
            return 2;
        }
        if (externalPauseType.equals("CONSUMERS")) {
            return 1;
        }
        if (externalPauseType.equals("ALL")) {
            return 3;
        }
        return -1;
    }

    public static String toExternalPauseType(int internalPauseType) {
        switch (internalPauseType) {
            case 2: {
                return "PRODUCERS";
            }
            case 1: {
                return "CONSUMERS";
            }
            case 3: {
                return "ALL";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isValidPauseType(String pauseType) {
        if (pauseType.equals("PRODUCERS")) {
            return true;
        }
        if (pauseType.equals("CONSUMERS")) {
            return true;
        }
        return pauseType.equals("ALL");
    }

    public static void pauseAllDestinations(int internalPauseType) {
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator itr = itrs[0];
        while (itr.hasNext()) {
            Destination d = (Destination)itr.next();
            if (d.isInternal() || d.isAdmin() || d.isTemporary()) continue;
            d.pauseDestination(internalPauseType);
        }
    }

    public static void resumeAllDestinations() {
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator itr = itrs[0];
        while (itr.hasNext()) {
            Destination d = (Destination)itr.next();
            if (!d.isPaused()) continue;
            d.resumeDestination();
        }
    }

    public static void compactAllDestinations() throws BrokerException {
        Destination d;
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator itr = itrs[0];
        boolean docompact = true;
        String errMsg = null;
        BrokerResources rb = Globals.getBrokerResources();
        while (itr.hasNext()) {
            d = (Destination)itr.next();
            if (d.isInternal() || d.isAdmin() || d.isTemporary() || d.isPaused()) continue;
            docompact = false;
            String msg = rb.getString("B3135");
            errMsg = rb.getString("B4160", msg);
            throw new BrokerException(errMsg);
        }
        if (docompact) {
            Globals.getDestinationList();
            itrs = DestinationList.getAllDestinations(null);
            itr = itrs[0];
            while (itr.hasNext()) {
                d = (Destination)itr.next();
                if (d.isInternal() || d.isAdmin() || d.isTemporary()) continue;
                d.compact();
            }
        }
    }

    public static void checkDestType(String type) throws BrokerException {
        if (type == null) {
            throw new BrokerException("Null destination type specified");
        }
        if (type.equals("q") || type.equals("t")) {
            return;
        }
        BrokerResources rb = Globals.getBrokerResources();
        throw new BrokerException(rb.getString("B4262", type));
    }

    public static void checkCreateDestinationAttrs(String type, AttributeList attrs) throws BrokerException {
        String[] validAttrs = null;
        DestinationUtil.checkDestType(type);
        if (attrs == null) {
            return;
        }
        if (type.equals("q")) {
            validAttrs = queueCreateAttrs;
        } else if (type.equals("t")) {
            validAttrs = topicCreateAttrs;
        }
        for (Attribute attr : attrs) {
            String name = attr.getName();
            if (DestinationUtil.checkOneDestAttr(name, validAttrs)) continue;
            BrokerResources rb = Globals.getBrokerResources();
            String err = type.equals("q") ? rb.getString("B4263", name) : rb.getString("B4264", name);
            throw new BrokerException(err);
        }
    }

    private static boolean checkOneDestAttr(String attrName, String[] validAttrs) {
        if (attrName == null) {
            return false;
        }
        if (validAttrs == null) {
            return false;
        }
        for (int i = 0; i < validAttrs.length; ++i) {
            if (!attrName.equals(validAttrs[i])) continue;
            return true;
        }
        return false;
    }

    public static void createDestination(DestinationInfo info) throws BrokerException {
        SizeString maxMessageSize;
        SizeString maxMessageBytes;
        int maxMessages;
        int type;
        Logger logger;
        BrokerResources rb;
        int status;
        String errMsg;
        block32: {
            errMsg = null;
            status = 200;
            rb = Globals.getBrokerResources();
            logger = Globals.getLogger();
            type = 257;
            maxMessages = -1;
            maxMessageBytes = null;
            maxMessageSize = null;
            if (MemoryGlobals.getMEM_DISALLOW_CREATE_DEST()) {
                status = 500;
                errMsg = "B2077";
            } else if (info.isModified(1)) {
                if (info.isModified(2)) {
                    type = info.type;
                }
                if (info.isModified(4)) {
                    maxMessages = info.maxMessages;
                }
                if (info.isModified(8)) {
                    maxMessageBytes = new SizeString();
                    maxMessageBytes.setBytes(info.maxMessageBytes);
                }
                if (info.isModified(16)) {
                    maxMessageSize = new SizeString();
                    maxMessageSize.setBytes(info.maxMessageSize);
                }
            } else {
                status = 500;
                errMsg = "B4089";
            }
            if (status == 200) {
                if (DestType.destNameIsInternal(info.name)) {
                    status = 500;
                    errMsg = rb.getKString("B4175", info.name, "mq.");
                } else if (CreateDestinationHandler.isValidDestinationName(info.name)) {
                    try {
                        Globals.getDestinationList();
                        DestinationList.createDestination(null, info.name, type);
                    }
                    catch (Exception ex) {
                        status = 500;
                        errMsg = rb.getString("B4090", info.name, DestinationUtil.getMessageFromException(ex));
                        if (ex instanceof ConflictException) {
                            logger.log(8, errMsg, ex);
                            break block32;
                        }
                        logger.logStack(8, errMsg, ex);
                    }
                } else {
                    status = 500;
                    errMsg = rb.getKString("B4091", info.name);
                }
            }
        }
        if (status == 200) {
            try {
                int maxcons;
                Globals.getDestinationList();
                Destination[] ds = DestinationList.getDestination(null, info.name, DestType.isQueue(type));
                Destination d = ds[0];
                d.setCapacity(maxMessages);
                d.setByteCapacity(maxMessageBytes);
                d.setMaxByteSize(maxMessageSize);
                if (info.isModified(32)) {
                    int scope = info.destScope;
                    d.setScope(scope);
                }
                if (info.isModified(64)) {
                    int destlimit = info.destLimitBehavior;
                    d.setLimitBehavior(destlimit);
                }
                if (info.isModified(128)) {
                    int prefetch = info.maxPrefetch;
                    d.setMaxPrefetch(prefetch);
                }
                if (info.isModified(256)) {
                    int clusterdeliverypolicy = info.destCDP;
                    d.setClusterDeliveryPolicy(clusterdeliverypolicy);
                }
                if (info.isModified(512)) {
                    maxcons = info.maxActiveConsumers;
                    d.setMaxActiveConsumers(maxcons);
                }
                if (info.isModified(2048)) {
                    int maxp = info.maxProducers;
                    d.setMaxProducers(maxp);
                }
                if (info.isModified(1024)) {
                    maxcons = info.maxFailoverConsumers;
                    d.setMaxFailoverConsumers(maxcons);
                }
                if (info.isModified(4096)) {
                    int maxsharedcons = info.maxNumSharedConsumers;
                    d.setMaxSharedConsumers(maxsharedcons);
                }
                if (info.isModified(8192)) {
                    int sflowlimit = info.sharedConsumerFlowLimit;
                    d.setSharedFlowLimit(sflowlimit);
                }
                if (info.isModified(16384)) {
                    boolean dmq = info.useDMQ;
                    d.setUseDMQ(dmq);
                }
                d.update();
            }
            catch (Exception ex) {
                try {
                    DestinationUID duid = DestinationUID.getUID(info.name, DestType.isQueue(type));
                    Globals.getDestinationList();
                    DestinationList.removeDestination(null, duid, false, ex.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                status = 500;
                errMsg = rb.getString("B4092", info.name, DestinationUtil.getMessageFromException(ex));
                logger.log(16, errMsg, ex);
            }
        }
        if (status != 200) {
            throw new BrokerException(errMsg);
        }
    }

    public static String getMessageFromException(Exception e) {
        String m = e.getMessage();
        if (e instanceof BrokerException) {
            Throwable root_ex = ((BrokerException)e).getCause();
            if (root_ex == null) {
                return m;
            }
            String lm = root_ex.getMessage();
            if (lm != null) {
                m = m + "\n" + lm;
            }
        }
        return m;
    }

    public static DestinationInfo getDestinationInfoFromAttrs(String type, String destName, AttributeList attrs) {
        DestinationInfo info = new DestinationInfo();
        info.setName(destName);
        if (type.equals("q")) {
            info.setType(1);
        } else if (type.equals("t")) {
            info.setType(2);
        }
        if (attrs == null) {
            return info;
        }
        for (Attribute attr : attrs) {
            String name = attr.getName();
            Object value = attr.getValue();
            if (name.equals("ConsumerFlowLimit")) {
                info.setPrefetch(((Long)value).intValue());
            }
            if (name.equals("LocalOnly")) {
                info.setScope((Boolean)value);
            }
            if (name.equals("LimitBehavior")) {
                info.setLimitBehavior(DestinationUtil.toInternalDestLimitBehavior((String)value));
            }
            if (name.equals("LocalDeliveryPreferred")) {
                int cdp = (Boolean)value != false ? 1 : 2;
                info.setClusterDeliveryPolicy(cdp);
            }
            if (name.equals("MaxBytesPerMsg")) {
                info.setMaxMessageSize((Long)value);
            }
            if (name.equals("MaxNumActiveConsumers")) {
                info.setMaxActiveConsumers((Integer)value);
            }
            if (name.equals("MaxNumBackupConsumers")) {
                info.setMaxFailoverConsumers((Integer)value);
            }
            if (name.equals("MaxNumMsgs")) {
                info.setMaxMessages(((Long)value).intValue());
            }
            if (name.equals("MaxNumProducers")) {
                info.setMaxProducers((Integer)value);
            }
            if (name.equals("MaxTotalMsgBytes")) {
                info.setMaxMessageBytes((Long)value);
            }
            if (!name.equals("UseDMQ")) continue;
            info.setUseDMQ((Boolean)value);
        }
        return info;
    }

    public static ObjectName getConfigObjectName(Destination d) throws MalformedObjectNameException {
        ObjectName o = MQObjectName.createDestinationConfig(d.isQueue() ? "q" : "t", d.getDestinationName());
        return o;
    }

    public static ObjectName getMonitorObjectName(Destination d) throws MalformedObjectNameException {
        ObjectName o = MQObjectName.createDestinationMonitor(d.isQueue() ? "q" : "t", d.getDestinationName());
        return o;
    }

    public static Object convertAttrValueInternaltoExternal(int attr, Object value) {
        switch (attr) {
            case 64: {
                if (value != null && value instanceof Integer) {
                    Integer i = (Integer)value;
                    return DestinationUtil.toExternalDestLimitBehavior(i);
                }
                return "UNKNOWN";
            }
        }
        return value;
    }

    public static String getAttrNameFromDestinationInfoAttr(int attr) {
        Object attrName = null;
        switch (attr) {
            case 4: {
                return "MaxNumMsgs";
            }
            case 16: {
                return "MaxBytesPerMsg";
            }
            case 8: {
                return "MaxTotalMsgBytes";
            }
            case 64: {
                return "LimitBehavior";
            }
            case 256: {
                return "LocalDeliveryPreferred";
            }
            case 512: {
                return "MaxNumActiveConsumers";
            }
            case 1024: {
                return "MaxNumBackupConsumers";
            }
            case 2048: {
                return "MaxNumProducers";
            }
            case 128: {
                return "ConsumerFlowLimit";
            }
            case 16384: {
                return "UseDMQ";
            }
        }
        return null;
    }

    public static void checkPauseType(String pauseType) throws IllegalArgumentException {
        if (pauseType.equals("ALL") || pauseType.equals("PRODUCERS") || pauseType.equals("CONSUMERS")) {
            return;
        }
        BrokerResources rb = Globals.getBrokerResources();
        throw new IllegalArgumentException(rb.getString("B4265", pauseType));
    }
}

