/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.GlobalProperties;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.data.MasterBrokerWaiter;
import com.sun.messaging.jmq.jmsserver.plugin.spi.CoreLifecycleSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.DestinationSpi;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ServiceRestrictionException;
import com.sun.messaging.jmq.jmsserver.util.ServiceRestrictionWaitException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Hashtable;

public abstract class PacketHandler {
    private static boolean DEBUG = false;
    protected final Logger logger = Globals.getLogger();
    protected final BrokerResources br = Globals.getBrokerResources();
    protected CoreLifecycleSpi coreLifecycle = null;
    protected DestinationList DL = Globals.getDestinationList();

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public void setCoreLifecycle(CoreLifecycleSpi clc) {
        this.coreLifecycle = clc;
    }

    public CoreLifecycleSpi getCoreLifecycle() {
        return this.coreLifecycle;
    }

    public abstract boolean handle(IMQConnection var1, Packet var2) throws BrokerException;

    public void handleForbidden(IMQConnection con, Packet msg, int replyType) throws BrokerException {
        Packet reply = new Packet(con.useDirectBuffers());
        if (DEBUG) {
            this.logger.log(4, "handle forbidden: sending " + PacketType.getString(replyType));
        }
        reply.setPacketType(replyType);
        reply.setConsumerID(msg.getConsumerID());
        Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
        hash.put("JMQStatus", 403);
        reply.setProperties(hash);
        con.sendControlMessage(reply);
    }

    public void checkPermission(Packet msg, IMQConnection con) throws AccessControlException, IOException, ClassNotFoundException, BrokerException {
        int id = msg.getPacketType();
        String op = PacketType.mapOperation(id);
        if (op == null) {
            return;
        }
        Hashtable prop = msg.getProperties();
        String destination = (String)prop.get("JMQDestination");
        if (destination == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() no JMQDestination"));
        }
        Integer dtype = (Integer)prop.get("JMQDestType");
        if (dtype == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() no JMQDestType"));
        }
        int destTypeInt = dtype;
        this.checkPermission(id, op, destination, destTypeInt, con);
    }

    public void checkPermission(int id, String op, String destination, int destTypeInt, IMQConnection con) throws AccessControlException, BrokerException {
        int serviceType;
        String destTypeStr = DestType.queueOrTopic(destTypeInt);
        if (destTypeStr == null) {
            return;
        }
        Service service = con.getService();
        if (!PacketHandler.checkIsNonAdminDest(con, service, serviceType = service.getServiceType(), destination)) {
            return;
        }
        String acdestination = destination;
        if (id == 34) {
            if (!PacketHandler.checkForAutoCreate(destination, destTypeInt)) {
                return;
            }
            DestinationUID duid = DestinationUID.getUID(destination, DestType.isQueue(destTypeInt));
            DestinationSpi[] ds = this.coreLifecycle.getDestination(con.getPartitionedStore(), duid);
            DestinationSpi d = ds[0];
            if (d != null && !d.isAutoCreated()) {
                return;
            }
            acdestination = null;
        }
        PacketHandler.checkPermission(con, service, serviceType, op, acdestination, destTypeStr, destination);
        Globals.getAuditSession().destinationAuth(con.getUserName(), con.remoteHostString(), destTypeStr, acdestination, op, true);
    }

    private static boolean checkForAutoCreate(String destination, int destType) {
        return !(DestType.isQueue(destType) ? !GlobalProperties.getGlobalProperties().AUTOCREATE_QUEUE : DestType.isTopic(destType) && !GlobalProperties.getGlobalProperties().AUTOCREATE_TOPIC);
    }

    private static boolean checkIsNonAdminDest(IMQConnection con, Service service, int serviceType, String destination) throws AccessControlException, BrokerException {
        if (!destination.equals("__JMQAdmin")) {
            if (serviceType == 1 && con.getAccessController().isRestrictedAdmin()) {
                String emsg = Globals.getBrokerResources().getKString("B4102", destination, service.getName());
                Globals.getLogger().log(16, emsg);
                throw new AccessControlException(emsg);
            }
            if (!destination.equals("__JMQBridgeAdmin")) {
                return true;
            }
        }
        if (serviceType == 1) {
            return false;
        }
        String name = "";
        Principal pp = con.getAccessController().getAuthenticatedName();
        if (pp != null) {
            name = pp.getName();
        }
        Object[] args = new String[]{name, service.getName(), ServiceType.getServiceTypeString(serviceType)};
        String emsg = Globals.getBrokerResources().getKString("B4076", args);
        Globals.getLogger().log(16, emsg);
        throw new AccessControlException(emsg);
    }

    private static void checkPermission(IMQConnection con, Service service, int serviceType, String op, String destination, String destType, String dest) throws AccessControlException {
        try {
            con.getAccessController().checkDestinationPermission(service.getName(), ServiceType.getServiceTypeString(serviceType), op, destination, destType);
        }
        catch (AccessControlException e) {
            if (destination != null) {
                Object[] args = new String[]{op, destType, destination};
                String emsg = Globals.getBrokerResources().getKString("B2041", args);
                Globals.getLogger().log(16, emsg + " - " + e.getMessage(), e);
            } else {
                Object[] args = new String[]{op, destType, dest};
                String emsg = Globals.getBrokerResources().getKString("B2042", args);
                Globals.getLogger().log(16, emsg + " - " + e.getMessage(), e);
            }
            throw e;
        }
    }

    public void checkServiceRestriction(Packet msg, IMQConnection con, ErrHandler defhandler) throws BrokerException, IOException, ClassNotFoundException {
        Service service = con.getService();
        if (service.getServiceType() != 0) {
            return;
        }
        int id = msg.getPacketType();
        if (id != 34 && id != 14 && id != 18) {
            return;
        }
        ServiceRestriction[] srs = service.getServiceRestrictions();
        if (srs == null) {
            return;
        }
        ServiceRestriction sr = null;
        for (int i = 0; i < srs.length; ++i) {
            sr = srs[i];
            if (sr == ServiceRestriction.NO_SYNC_WITH_MASTERBROKER) {
                Hashtable prop = msg.getProperties();
                String dest = (String)prop.get("JMQDestination");
                int dtype = (Integer)prop.get("JMQDestType");
                if (id == 34) {
                    if (!PacketHandler.checkForAutoCreate(dest, dtype)) {
                        return;
                    }
                    DestinationUID duid = DestinationUID.getUID(dest, DestType.isQueue(dtype));
                    DestinationSpi[] ds = this.coreLifecycle.getDestination(con.getPartitionedStore(), duid);
                    DestinationSpi d = ds[0];
                    if (d != null) {
                        return;
                    }
                    if (DestType.isQueue(dtype) && DestType.isTemporary(dtype)) {
                        return;
                    }
                    Object[] args = new String[]{Thread.currentThread().getName(), dest, service.toString(), sr.toString(true)};
                    String emsg = Globals.getBrokerResources().getKString("B4286", args);
                    this.logger.log(16, emsg);
                    this.waitForMasterBrokerSync(con, msg, emsg, emsg, defhandler);
                    return;
                }
                if (!DestType.isTopic(dtype)) continue;
                if (id == 18) {
                    Object[] args = new String[]{Thread.currentThread().getName(), dest, service.toString(), sr.toString(true)};
                    String emsg = Globals.getBrokerResources().getKString("B4287", args);
                    this.logger.log(16, emsg);
                    this.waitForMasterBrokerSync(con, msg, emsg, emsg, defhandler);
                    return;
                }
                Object[] args = new String[]{Thread.currentThread().getName(), dest, service.toString(), sr.toString(true)};
                String emsg = Globals.getBrokerResources().getKString("B4288", args);
                this.logger.log(16, emsg);
                this.waitForMasterBrokerSync(con, msg, emsg, emsg, defhandler);
                return;
            }
            throw new BrokerException(Globals.getBrokerResources().getString("B3100", "Unknown service restriction " + sr + " on service " + service));
        }
    }

    private boolean waitForMasterBrokerSync(IMQConnection con, Packet pkt, String retrymsg, String errmsg, ErrHandler defhandler) throws BrokerException {
        if (con.getClientProtocolVersion() < 450) {
            throw new ServiceRestrictionException(errmsg, 503);
        }
        if (!MasterBrokerWaiter.addRequest(pkt, con, retrymsg, errmsg, defhandler)) {
            throw new ServiceRestrictionException(errmsg, 503);
        }
        throw new ServiceRestrictionWaitException(Globals.getBrokerResources().getKString("B1349", Thread.currentThread().getName(), "[" + MasterBrokerWaiter.maxwait / 1000L + "]"), 503);
    }
}

