/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;

public class MethodExpressionMethodBindingAdapter
extends MethodExpression
implements Serializable,
StateHolder {
    private static final long serialVersionUID = -1822420567946048452L;
    private MethodBinding binding = null;
    private transient MethodInfo info = null;
    private boolean tranzient = false;

    public MethodExpressionMethodBindingAdapter() {
    }

    public MethodExpressionMethodBindingAdapter(MethodBinding binding) {
        assert (null != binding);
        this.binding = binding;
    }

    public MethodInfo getMethodInfo(ELContext context) throws ELException {
        FacesContext facesContext;
        assert (null != this.binding);
        if (null == this.info && null != (facesContext = (FacesContext)context.getContext(FacesContext.class))) {
            try {
                this.info = new MethodInfo(null, this.binding.getType(facesContext), null);
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
        }
        return this.info;
    }

    public Object invoke(ELContext context, Object[] params) throws ELException {
        assert (null != this.binding);
        Object result = null;
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        if (null != facesContext) {
            try {
                result = this.binding.invoke(facesContext, params);
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
        }
        return result;
    }

    public String getExpressionString() {
        assert (null != this.binding);
        return this.binding.getExpressionString();
    }

    public boolean isLiteralText() {
        assert (this.binding != null);
        String expr = this.binding.getExpressionString();
        return !expr.startsWith("#{") || !expr.endsWith("}");
    }

    public boolean equals(Object other) {
        assert (null != this.binding);
        boolean result = false;
        if (MethodExpression.class.isAssignableFrom(other.getClass())) {
            MethodExpression otherVE = (MethodExpression)other;
            result = this.getExpressionString().equals(otherVE.getExpressionString());
        }
        return result;
    }

    public int hashCode() {
        assert (null != this.binding);
        return this.binding.hashCode();
    }

    public String getDelimiterSyntax() {
        return "";
    }

    public Object saveState(FacesContext context) {
        Object[] result = null;
        if (!this.tranzient) {
            if (this.binding instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)this.binding).saveState(context), this.binding.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.binding;
            }
        }
        return result;
    }

    public void restoreState(FacesContext context, Object state) {
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodBinding)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodBinding result = null;
            Class toRestoreClass = null;
            if (null != className) {
                try {
                    toRestoreClass = MethodExpressionMethodBindingAdapter.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodBinding)toRestoreClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (IllegalAccessException a) {
                        throw new IllegalStateException(a.getMessage());
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)result).restoreState(context, savedState);
                }
                this.binding = result;
            }
        } else {
            this.binding = (MethodBinding)state;
        }
    }

    public boolean isTransient() {
        return this.tranzient;
    }

    public void setTransient(boolean newTransientMethod) {
        this.tranzient = newTransientMethod;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader.loadClass(name);
    }

    public MethodBinding getWrapped() {
        return this.binding;
    }
}

