/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.server.connector.CarType;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="AppClient")
@Singleton
public class AppClientSniffer
extends GenericSniffer {
    private static final String[] stigmas = new String[]{"META-INF/application-client.xml", "META-INF/sun-application-client.xml", "META-INF/glassfish-application-client.xml"};
    private static final String[] containers = new String[]{"appclient"};
    @Inject
    CarType carType;
    private static final List<String> deploymentConfigurationPaths = AppClientSniffer.initDeploymentConfigurationPaths();

    public AppClientSniffer() {
        this(containers[0], stigmas[0], null);
    }

    public AppClientSniffer(String containerName, String appStigma, String urlPattern) {
        super(containerName, appStigma, urlPattern);
    }

    public String[] getContainersNames() {
        return containers;
    }

    @Override
    public boolean handles(ReadableArchive location) {
        for (String s : stigmas) {
            try {
                if (!location.exists(s)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Manifest manifest = location.getManifest();
            if (manifest != null && manifest.getMainAttributes().containsKey(Attributes.Name.MAIN_CLASS)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isUserVisible() {
        return true;
    }

    @Override
    public boolean isJavaEE() {
        return true;
    }

    @Override
    public String[] getIncompatibleSnifferTypes() {
        return new String[0];
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.equals((Object)this.carType);
    }

    private static List<String> initDeploymentConfigurationPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("META-INF/application-client.xml");
        result.add("META-INF/sun-application-client.xml");
        result.add("META-INF/glassfish-application-client.xml");
        result.add("META-INF/weblogic-application-client.xml");
        return result;
    }

    @Override
    protected List<String> getDeploymentConfigurationPaths() {
        return deploymentConfigurationPaths;
    }
}

