/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionFactory;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Named;
import javax.inject.Provider;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.literal.NamedLiteral;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.logging.ResolutionLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.reflection.Reflections;

public class ResolvableBuilder {
    private static final Class<?>[] FACADE_TYPES = new Class[]{Event.class, Instance.class, WeldInstance.class, Provider.class, InterceptionFactory.class};
    private static final Class<?>[] METADATA_TYPES = new Class[]{Interceptor.class, Decorator.class, Bean.class};
    private static final Set<QualifierInstance> ANY_SINGLETON = Collections.singleton(QualifierInstance.ANY);
    protected Class<?> rawType;
    protected final Set<Type> types;
    protected final Set<QualifierInstance> qualifierInstances;
    protected Bean<?> declaringBean;
    private final MetaAnnotationStore store;
    protected boolean delegate;

    public ResolvableBuilder(MetaAnnotationStore store) {
        this.store = store;
        this.types = new HashSet<Type>();
        this.qualifierInstances = new HashSet<QualifierInstance>();
    }

    public ResolvableBuilder(BeanManagerImpl manager) {
        this(manager.getServices().get(MetaAnnotationStore.class));
    }

    public ResolvableBuilder(Type type, BeanManagerImpl beanManager) {
        this(beanManager);
        if (type != null) {
            this.rawType = Reflections.getRawType(type);
            if (this.rawType == null || type instanceof TypeVariable) {
                throw ResolutionLogger.LOG.cannotExtractRawType(type);
            }
            this.types.add(type);
        }
    }

    public ResolvableBuilder(InjectionPoint injectionPoint, BeanManagerImpl manager) {
        this(injectionPoint.getType(), manager);
        this.addQualifiers(injectionPoint.getQualifiers(), injectionPoint);
        this.setDeclaringBean(injectionPoint.getBean());
        this.delegate = injectionPoint.isDelegate();
    }

    public ResolvableBuilder setDeclaringBean(Bean<?> declaringBean) {
        this.declaringBean = declaringBean;
        return this;
    }

    public ResolvableBuilder addType(Type type) {
        this.types.add(type);
        return this;
    }

    public ResolvableBuilder addTypes(Set<Type> types) {
        this.types.addAll(types);
        return this;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public Resolvable create() {
        if (this.qualifierInstances.isEmpty()) {
            this.qualifierInstances.add(QualifierInstance.DEFAULT);
        }
        for (Type type : this.types) {
            Class rawType = Reflections.getRawType(type);
            for (Class<?> facadeType : FACADE_TYPES) {
                if (!facadeType.equals(rawType)) continue;
                return this.createFacade(facadeType);
            }
            for (Class<?> metadataType : METADATA_TYPES) {
                if (!metadataType.equals(rawType)) continue;
                return this.createMetadataProvider(metadataType);
            }
        }
        return new ResolvableImpl(this.rawType, this.types, this.declaringBean, this.qualifierInstances, this.delegate);
    }

    private Resolvable createFacade(Class<?> rawType) {
        Set<Type> types = Collections.singleton(rawType);
        return new ResolvableImpl(rawType, types, this.declaringBean, ANY_SINGLETON, this.delegate);
    }

    private Resolvable createMetadataProvider(Class<?> rawType) {
        Set<Type> types = Collections.singleton(rawType);
        return new ResolvableImpl(rawType, types, this.declaringBean, this.qualifierInstances, this.delegate);
    }

    public ResolvableBuilder addQualifier(Annotation qualifier) {
        return this.addQualifier(qualifier, null);
    }

    private ResolvableBuilder addQualifier(Annotation qualifier, InjectionPoint injectionPoint) {
        Named named;
        QualifierInstance qualifierInstance = QualifierInstance.of(qualifier, this.store);
        Class<? extends Annotation> annotationType = qualifierInstance.getAnnotationClass();
        if (annotationType.equals(New.class)) {
            New newQualifier = (New)New.class.cast(qualifier);
            if (newQualifier.value().equals(New.class) && this.rawType == null) {
                throw new IllegalStateException("Cannot transform @New when there is no known raw type");
            }
            if (newQualifier.value().equals(New.class)) {
                qualifier = New.Literal.of(this.rawType);
                qualifierInstance = QualifierInstance.of(qualifier, this.store);
            }
        } else if (injectionPoint != null && annotationType.equals(Named.class) && (named = (Named)qualifier).value().equals("")) {
            Member member = injectionPoint.getMember();
            if (member instanceof Executable) {
                Executable executable = (Executable)member;
                AnnotatedParameter annotatedParameter = (AnnotatedParameter)injectionPoint.getAnnotated();
                Parameter parameter = executable.getParameters()[annotatedParameter.getPosition()];
                named = new NamedLiteral(parameter.getName());
            } else {
                named = new NamedLiteral(injectionPoint.getMember().getName());
            }
            qualifier = named;
            qualifierInstance = QualifierInstance.of(named, this.store);
        }
        this.checkQualifier(qualifier, qualifierInstance, annotationType);
        this.qualifierInstances.add(qualifierInstance);
        return this;
    }

    public ResolvableBuilder addQualifierUnchecked(QualifierInstance qualifier) {
        this.qualifierInstances.add(qualifier);
        return this;
    }

    public ResolvableBuilder addQualifiers(Annotation[] qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public ResolvableBuilder addQualifiers(Collection<Annotation> qualifiers) {
        return this.addQualifiers(qualifiers, null);
    }

    private ResolvableBuilder addQualifiers(Collection<Annotation> qualifiers, InjectionPoint injectionPoint) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier, injectionPoint);
        }
        return this;
    }

    protected void checkQualifier(Annotation qualifier, QualifierInstance qualifierInstance, Class<? extends Annotation> annotationType) {
        if (!this.store.getBindingTypeModel(annotationType).isValid()) {
            throw BeanManagerLogger.LOG.invalidQualifier(qualifierInstance);
        }
        if (!annotationType.isAnnotationPresent(Repeatable.class)) {
            for (QualifierInstance checkedQualifier : this.qualifierInstances) {
                if (!annotationType.equals(checkedQualifier.getAnnotationClass())) continue;
                throw BeanManagerLogger.LOG.duplicateQualifiers(this.qualifierInstances);
            }
        }
    }

    protected MetaAnnotationStore getMetaAnnotationStore() {
        return this.store;
    }

    protected static class ResolvableImpl
    implements Resolvable {
        private final Set<QualifierInstance> qualifierInstances;
        private final Set<Type> typeClosure;
        private final Class<?> rawType;
        private final Bean<?> declaringBean;
        private final boolean delegate;
        private final int hashCode;

        protected ResolvableImpl(Class<?> rawType, Set<Type> typeClosure, Bean<?> declaringBean, Set<QualifierInstance> qualifierInstances, boolean delegate) {
            this.typeClosure = typeClosure;
            this.rawType = rawType;
            this.declaringBean = declaringBean;
            this.qualifierInstances = qualifierInstances;
            this.delegate = delegate;
            this.hashCode = this.calculateHashCode();
        }

        private int calculateHashCode() {
            int hashCode = 17;
            hashCode = 31 * hashCode + this.getTypes().hashCode();
            return 31 * hashCode + this.qualifierInstances.hashCode();
        }

        @Override
        public Set<QualifierInstance> getQualifiers() {
            return this.qualifierInstances;
        }

        @Override
        public Set<Type> getTypes() {
            return this.typeClosure;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.rawType;
        }

        @Override
        public Bean<?> getDeclaringBean() {
            return this.declaringBean;
        }

        public String toString() {
            return "Types: " + this.getTypes() + "; Bindings: " + this.getQualifiers();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ResolvableImpl) {
                ResolvableImpl r = (ResolvableImpl)o;
                return this.getTypes().equals(r.getTypes()) && this.qualifierInstances.equals(r.qualifierInstances);
            }
            return false;
        }

        @Override
        public boolean isDelegate() {
            return this.delegate;
        }
    }
}

