/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public class DirectBytesPacket
extends DirectPacket
implements BytesMessage {
    private byte[] messageBody = null;
    private int validLength = 0;
    private boolean writePerformed = false;
    private JMQByteArrayOutputStream byteArrayOutputStream = null;
    private DataOutputStream dataOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private DataInputStream dataInputStream = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectBytesPacket";

    public DirectBytesPacket(DirectSession ds) throws JMSException {
        super(ds);
        if (_logFINE) {
            Object[] params = new Object[2];
            params[0] = ds;
            _loggerOC.entering(_className, "constructor()", params);
        }
        this.byteArrayOutputStream = new JMQByteArrayOutputStream(new byte[32]);
        this.dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    }

    public DirectBytesPacket(JMSPacket jmsPacket, long consumerId, DirectSession ds, JMSService jmsservice) throws JMSException {
        super(jmsPacket, consumerId, ds, jmsservice);
        this._getMessageBodyFromPacket();
    }

    public long getBodyLength() throws JMSException {
        String methodName = "getBodyLength()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        if (this.messageBody != null) {
            return this.validLength;
        }
        return 0L;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.messageBody = null;
        this._initializeOutputStreams();
    }

    public boolean readBoolean() throws JMSException {
        String methodName = "readBoolean()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        boolean value = false;
        try {
            value = this.dataInputStream.readBoolean();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public byte readByte() throws JMSException {
        String methodName = "readByte()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        byte value = 0;
        try {
            value = this.dataInputStream.readByte();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public int readBytes(byte[] value) throws JMSException {
        String methodName = "readBytes(byte[])";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + Arrays.toString(value));
        }
        this.checkForWriteOnlyMessageBody(methodName);
        int bytesRead = -1;
        try {
            bytesRead = this.dataInputStream.read(value);
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":value=" + Arrays.toString(value) + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":value=" + Arrays.toString(value) + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return bytesRead;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        String methodName = "readBytes(byte[], length)";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + Arrays.toString(value));
        }
        this.checkForWriteOnlyMessageBody(methodName);
        int bytesRead = -1;
        try {
            bytesRead = this.dataInputStream.read(value, 0, length);
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":value=" + Arrays.toString(value) + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw iobe;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":value=" + Arrays.toString(value) + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return bytesRead;
    }

    public char readChar() throws JMSException {
        String methodName = "readChar()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        char value = '\u0000';
        try {
            value = this.dataInputStream.readChar();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public double readDouble() throws JMSException {
        String methodName = "readDouble()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        double value = 0.0;
        try {
            value = this.dataInputStream.readDouble();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public float readFloat() throws JMSException {
        String methodName = "readFloat()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        float value = 0.0f;
        try {
            value = this.dataInputStream.readFloat();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public int readInt() throws JMSException {
        String methodName = "readInt()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        int value = 0;
        try {
            value = this.dataInputStream.readInt();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public long readLong() throws JMSException {
        String methodName = "readLong()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        long value = 0L;
        try {
            value = this.dataInputStream.readLong();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public short readShort() throws JMSException {
        String methodName = "readShort()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        short value = 0;
        try {
            value = this.dataInputStream.readShort();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public String readUTF() throws JMSException {
        String methodName = "readUTF()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        String value = null;
        try {
            value = this.dataInputStream.readUTF();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public int readUnsignedByte() throws JMSException {
        String methodName = "readUnsignedByte()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        int value = 0;
        try {
            value = this.dataInputStream.readUnsignedByte();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public int readUnsignedShort() throws JMSException {
        String methodName = "readUnsignedShort()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForWriteOnlyMessageBody(methodName);
        int value = 0;
        try {
            value = this.dataInputStream.readUnsignedShort();
        }
        catch (EOFException eofe) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + eofe.getMessage();
            _loggerJM.severe(errMsg);
            MessageEOFException jmse = new MessageEOFException(errMsg);
            jmse.initCause((Throwable)eofe);
            throw jmse;
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
        return value;
    }

    public void reset() throws JMSException {
        String methodName = "reset()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this._reset("reset()");
    }

    public void writeBoolean(boolean value) throws JMSException {
        String methodName = "writeBoolean()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeBoolean(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeByte(byte value) throws JMSException {
        String methodName = "writeByte()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeByte(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeShort(short value) throws JMSException {
        String methodName = "writeShort()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeShort(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeChar(char value) throws JMSException {
        String methodName = "writeChar()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeChar(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeInt(int value) throws JMSException {
        String methodName = "writeInt()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeInt(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeLong(long value) throws JMSException {
        String methodName = "writeLong()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeLong(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeFloat(float value) throws JMSException {
        String methodName = "writeFloat()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeFloat(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeDouble(double value) throws JMSException {
        String methodName = "writeDouble()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeDouble(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeBytes(byte[] value) throws JMSException {
        String methodName = "writeBytes(byte[])";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + Arrays.toString(value));
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.write(value);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + Arrays.toString(value) + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        String methodName = "writeBytes(byte[], offset, length)";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + Arrays.toString(value) + ":offset=" + offset + ":length=" + length);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.write(value, offset, length);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + Arrays.toString(value) + ":offset=" + offset + ":length=" + length + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    public void writeObject(Object value) throws JMSException {
        String methodName = "writeObject()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName + ":value=" + value);
        }
        if (value == null) {
            String exErrMsg = "MQJMSRA_DM4001: " + methodName + "value=NULL";
            throw new NullPointerException(exErrMsg);
        }
        if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":Illegal object type=" + value.getClass().getName();
            _loggerJM.severe(errMsg);
            MessageFormatException jmse = new MessageFormatException(errMsg);
            throw jmse;
        }
    }

    public void writeUTF(String value) throws JMSException {
        String methodName = "writeUTF()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.dataOutputStream.writeUTF(value);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + "value=" + value + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    @Override
    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(2);
    }

    @Override
    protected void _setBodyToPacket() throws JMSException {
        this._reset("_setBodyToPacket");
        if (this.messageBody != null) {
            try {
                super._setMessageBodyOfPacket(this.messageBody, 0, this.validLength);
            }
            catch (Exception ex) {
                String errMsg = "MQJMSRA_DM4001: :ERROR setting BytesMessage body:Exception=" + ex.getMessage();
                _loggerJM.severe(errMsg);
                JMSException jmse = new JMSException(errMsg);
                jmse.initCause((Throwable)ex);
                throw jmse;
            }
        }
    }

    @Override
    protected void _getMessageBodyFromPacket() throws JMSException {
        this.messageBody = super._getMessageBodyByteArray();
        this.validLength = this.pkt.getMessageBodySize();
        this._reset("_getMessageBodyFromPacket()");
    }

    private void _reset(String methodName) throws JMSException {
        super._setReadOnlyBody(true);
        try {
            if (this.writePerformed) {
                this.dataOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.getBuf();
                this.validLength = this.byteArrayOutputStream.getCount();
                this.dataOutputStream.close();
                this.byteArrayOutputStream.close();
                this.writePerformed = false;
            }
            if (this.messageBody == null) {
                this.messageBody = new byte[0];
                this.validLength = 0;
            }
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody, 0, this.validLength);
            this.dataInputStream = new DataInputStream(this.byteArrayInputStream);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:BytesMessage." + methodName + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    private void _initializeOutputStreams() {
        this.byteArrayOutputStream = new JMQByteArrayOutputStream(new byte[32]);
        this.dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    }
}

