/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.ssl;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.protocol.ssl.DefaultTrustManager;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLUtil {
    public static SSLSocket makeSSLSocket(String host, int port, boolean isHostTrusted, String keystore, String keystorepwd, Logger logger, ClientResources cr) throws Exception {
        SSLSocketFactory sslFactory;
        SSLContext ctx;
        if (keystorepwd != null) {
            ctx = SSLUtil.getDefaultSSLContext(keystore, keystorepwd, isHostTrusted, logger, cr);
            sslFactory = ctx.getSocketFactory();
        } else if (isHostTrusted) {
            ctx = SSLUtil.getTrustSSLContext();
            sslFactory = ctx.getSocketFactory();
            if (Debug.debug) {
                Debug.println("Broker is trusted ...");
            }
        } else {
            sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (Debug.debug) {
            Debug.println("Create connection using SSL protocol ...");
            Debug.println("Broker Host: " + host);
            Debug.println("Broker Port: " + port);
        }
        SSLSocket sslSocket = null;
        sslSocket = host == null ? (SSLSocket)sslFactory.createSocket() : (SSLSocket)sslFactory.createSocket(host, port);
        boolean tcpNoDelay = true;
        String prop = System.getProperty("imqTcpNoDelay", "true");
        if (prop.equals("false")) {
            tcpNoDelay = false;
        } else {
            sslSocket.setTcpNoDelay(tcpNoDelay);
        }
        return sslSocket;
    }

    private static SSLContext getTrustSSLContext() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
        ctx.init(null, tm, null);
        return ctx;
    }

    private static SSLContext getDefaultSSLContext(String keystoreloc, String keystorepwd, boolean isHostTrusted, Logger logger, ClientResources cr) throws Exception {
        File f;
        if (keystorepwd == null) {
            if (cr != null) {
                throw new IOException(cr.getKString("C4324"));
            }
            throw new IOException("No key store password provided");
        }
        String kpwd = keystorepwd;
        if (kpwd.equals("")) {
            kpwd = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (kpwd == null) {
            if (cr != null) {
                throw new IOException(cr.getKString("C4324"));
            }
            throw new IOException("No key store password provided");
        }
        String kloc = keystoreloc;
        if (kloc == null) {
            kloc = System.getProperty("javax.net.ssl.keyStore");
        }
        if (!(f = new File(kloc)).exists()) {
            if (cr != null) {
                throw new IOException(cr.getKString("C4323", kloc));
            }
            throw new IOException("File not found: " + kloc);
        }
        char[] kpwdc = kpwd.toCharArray();
        String ktype = System.getProperty("javax.net.ssl.keyStoreType");
        if (ktype == null) {
            ktype = "JKS";
        }
        KeyStore kstore = KeyStore.getInstance(ktype);
        kstore.load(new FileInputStream(kloc), kpwdc);
        String kalg = "SunX509";
        KeyManagerFactory kmf = null;
        try {
            kmf = KeyManagerFactory.getInstance(kalg);
        }
        catch (NoSuchAlgorithmException e) {
            kalg = KeyManagerFactory.getDefaultAlgorithm();
            kmf = KeyManagerFactory.getInstance(kalg);
        }
        kmf.init(kstore, kpwdc);
        String talg = "SunX509";
        TrustManager[] tm = null;
        if (!isHostTrusted) {
            TrustManagerFactory tmf = null;
            try {
                tmf = TrustManagerFactory.getInstance(talg);
            }
            catch (NoSuchAlgorithmException e) {
                talg = TrustManagerFactory.getDefaultAlgorithm();
                tmf = TrustManagerFactory.getInstance(talg);
            }
            tmf.init(kstore);
            tm = tmf.getTrustManagers();
        } else {
            tm = new TrustManager[]{new DefaultTrustManager()};
        }
        if (cr != null) {
            Object[] args = new String[]{ktype, kalg, talg, kloc};
            String logmsg = cr.getKString("I506", args);
            logger.info(logmsg);
        } else {
            System.out.println("Use " + ktype + " key store, " + kalg + " key manager factory and " + talg + " trust manager factory for " + kloc);
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        ctx.init(kmf.getKeyManagers(), tm, random);
        return ctx;
    }

    public static String[] getKnownSSLEnabledProtocols() {
        try {
            SSLContext sc = SSLUtil.getTrustSSLContext();
            SSLEngine se = sc.createSSLEngine();
            return se.getEnabledProtocols();
        }
        catch (Exception exception) {
            return new String[]{"TLSv1"};
        }
    }
}

