/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.executionframework.debugger.IMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class AnnotationMutableFieldExtractor
implements IMutableFieldExtractor {
    private final Map<EClass, Integer> counters = new HashMap<EClass, Integer>();
    private final DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();

    @Override
    public List<MutableField> extractMutableField(final EObject eObject) {
        String _xifexpression_1;
        ArrayList<MutableField> result = new ArrayList<MutableField>();
        EClass _eClass = eObject.eClass();
        EAttribute idProp = _eClass.getEIDAttribute();
        String _xifexpression = null;
        if (idProp != null) {
            String _xblockexpression = null;
            Object id = eObject.eGet((EStructuralFeature)idProp);
            _xifexpression_1 = null;
            if (id != null) {
                String _xblockexpression_1 = null;
                DecimalFormat formatter = new DecimalFormat("00");
                String _xifexpression_2 = null;
                _xifexpression_2 = id instanceof Integer ? formatter.format((Integer)id) : id.toString();
                String idString = _xifexpression_2;
                EClass _eClass_1 = eObject.eClass();
                String _name = _eClass_1.getName();
                String _plus = String.valueOf(_name) + "_";
                _xifexpression_1 = _xblockexpression_1 = String.valueOf(_plus) + idString;
            } else {
                boolean _not;
                String _xblockexpression_2 = null;
                EClass _eClass_1 = eObject.eClass();
                boolean _containsKey = this.counters.containsKey(_eClass_1);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    EClass _eClass_2 = eObject.eClass();
                    this.counters.put(_eClass_2, 0);
                }
                EClass _eClass_3 = eObject.eClass();
                Integer counter = this.counters.get(_eClass_3);
                EClass _eClass_4 = eObject.eClass();
                this.counters.put(_eClass_4, counter + 1);
                EClass _eClass_5 = eObject.eClass();
                String _name = _eClass_5.getName();
                String _plus = String.valueOf(_name) + "_";
                _xifexpression_1 = _xblockexpression_2 = String.valueOf(_plus) + counter;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            String _xblockexpression_1 = null;
            QualifiedName qname = this.nameprovider.getFullyQualifiedName(eObject);
            _xifexpression_1 = null;
            _xifexpression_1 = qname == null ? eObject.toString() : qname.toString();
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        final String objectName = _xifexpression;
        EClass _eClass_1 = eObject.eClass();
        EList _eAllStructuralFeatures = _eClass_1.getEAllStructuralFeatures();
        for (final EStructuralFeature prop : _eAllStructuralFeatures) {
            boolean _isDynamic = DynamicAnnotationHelper.isDynamic((EStructuralFeature)prop);
            if (!_isDynamic) continue;
            String _name = prop.getName();
            String _plus = String.valueOf(_name) + " (";
            String _plus_1 = String.valueOf(_plus) + objectName;
            String _plus_2 = String.valueOf(_plus_1) + " :";
            EClass _eClass_2 = eObject.eClass();
            String _name_1 = _eClass_2.getName();
            String _plus_3 = String.valueOf(_plus_2) + _name_1;
            String _plus_4 = String.valueOf(_plus_3) + ")";
            Supplier<Object> _function = new Supplier<Object>(){

                @Override
                public Object get() {
                    return eObject.eGet(prop);
                }
            };
            Consumer<Object> _function_1 = new Consumer<Object>(){

                @Override
                public void accept(final Object o) {
                    Resource _eResource = eObject.eResource();
                    TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((Resource)_eResource);
                    String _name = prop.getName();
                    String _plus = "Setting value " + o + " in " + objectName + "." + _name;
                    String _plus_1 = String.valueOf(_plus) + " from the debugger";
                    RecordingCommand command = new RecordingCommand(ed, _plus_1){

                        protected void doExecute() {
                            eObject.eSet(prop, o);
                        }
                    };
                    CommandExecution.execute((TransactionalEditingDomain)ed, (RecordingCommand)command);
                }
            };
            MutableField mut = new MutableField(_plus_4, eObject, prop, _function, _function_1);
            result.add(mut);
        }
        return result;
    }
}

