/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fmc.blockdiagram.editor.BlockDiagramMessages;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class ShapeAddFeature
extends AbstractAddShapeFeature {
    protected int minimumHeight = 30;
    protected int minimumWidth = 40;
    protected int angle = 0;
    protected int textMargin = 0;
    protected boolean linked = true;
    protected IPeService pe = Graphiti.getPeService();
    protected IGaService ga = Graphiti.getGaService();
    protected final ShapeStyle shapeType;
    protected final String defaultShapeText;
    protected final FMCNodeAlgorithmFactory factory = FMCNodeAlgorithmFactory.getInstance();

    public ShapeAddFeature(IFeatureProvider fp) {
        super(fp);
        this.shapeType = ShapeStyle.RECT;
        this.defaultShapeText = BlockDiagramMessages.FMCAddFeature_DefaultShapeTitle;
    }

    void setTextMargin(int textMargin) {
        this.textMargin = textMargin;
    }

    public ShapeAddFeature(IFeatureProvider fp, String defaultText, int angle) {
        super(fp);
        this.shapeType = ShapeStyle.RECT;
        this.defaultShapeText = defaultText;
        this.angle = angle;
    }

    public ShapeAddFeature(IFeatureProvider fp, ShapeStyle type) {
        super(fp);
        this.shapeType = type == null ? ShapeStyle.RECT : type;
        this.defaultShapeText = BlockDiagramMessages.FMCAddFeature_DefaultShapeTitle;
    }

    protected Style getStyle() {
        Style style = StyleUtil.getStyle(this.getDiagram(), "Shape");
        style.setAngle(Integer.valueOf(this.angle));
        return style;
    }

    protected MultiText addText(ContainerShape container, int x, int y, int width, int height, Orientation hor, Orientation ver, String text, Object linkedObj) {
        if (text != null) {
            Shape txtShape = this.pe.createShape(container, false);
            MultiText txt = this.ga.createMultiText((GraphicsAlgorithmContainer)txtShape, text);
            txt.setValue(text);
            txt.setHorizontalAlignment(hor);
            txt.setVerticalAlignment(ver);
            this.ga.setLocationAndSize((GraphicsAlgorithm)txt, x, y, width, height);
            txt.setForeground(this.manageColor(0, 0, 0));
            txt.setStyle(StyleUtil.getStyle(this.getDiagram(), "Shape"));
            if (this.linked) {
                this.linkTextWithModel(txtShape, linkedObj);
            }
            return txt;
        }
        return null;
    }

    protected MultiText addText(ContainerShape container, Orientation hor, Orientation ver, String text, Object linkedObj) {
        return this.addText(container, this.textMargin, this.textMargin, container.getGraphicsAlgorithm().getWidth() - 2 * this.textMargin, container.getGraphicsAlgorithm().getHeight() - 2 * this.textMargin, hor, ver, text, linkedObj);
    }

    protected MultiText addText(ContainerShape container, Orientation hor, Orientation ver, Object linkedObj) {
        String txt = this.getTextFromModel(linkedObj);
        return this.addText(container, hor, ver, txt, linkedObj);
    }

    protected MultiText addText(ContainerShape container, Object linkedObj) {
        return this.addText(container, Orientation.ALIGNMENT_CENTER, Orientation.ALIGNMENT_CENTER, linkedObj);
    }

    protected void addText(ContainerShape container, Orientation orientation, Object linkedObj) {
        this.addText(container, Orientation.ALIGNMENT_CENTER, orientation, linkedObj);
    }

    protected void addText(ContainerShape container, int x, int y, int width, int height, Object linkedObj) {
        String txt = this.getTextFromModel(linkedObj);
        this.addText(container, x, y, width, height, Orientation.ALIGNMENT_CENTER, Orientation.ALIGNMENT_CENTER, txt, linkedObj);
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    protected int getHeight(IAddContext context) {
        if (context.getHeight() < this.minimumHeight) {
            return this.minimumHeight;
        }
        return context.getHeight();
    }

    protected int getWidth(IAddContext context) {
        if (context.getWidth() < this.minimumWidth) {
            return this.minimumWidth;
        }
        return context.getWidth();
    }

    protected void linkTextWithModel(Shape shape, Object obj) {
        if (obj instanceof FMCType) {
            this.link((PictogramElement)shape, (Object)FMCType.Text);
        } else {
            this.link((PictogramElement)shape, obj);
            Graphiti.getLinkService().setLinkProperty((PictogramElement)shape, "name");
        }
    }

    protected String getTextFromModel(Object obj) {
        if (obj instanceof EObject) {
            String name = null;
            EObject eobj = (EObject)obj;
            for (EAttribute attr : eobj.eClass().getEAllAttributes()) {
                if (!"name".equals(attr.getName())) continue;
                name = (String)eobj.eGet((EStructuralFeature)attr);
                if (name != null) {
                    return name;
                }
                eobj.eSet((EStructuralFeature)attr, (Object)this.defaultShapeText);
                return this.defaultShapeText;
            }
        }
        return this.defaultShapeText;
    }
}

