/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fmc.blockdiagram.editor.BlockDiagramEditor;
import org.eclipse.fmc.blockdiagram.editor.clipboard.PasteFromClipboard;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.features.AbstractPasteFeature;

public class ShapePasteFeature
extends AbstractPasteFeature {
    public ShapePasteFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public void paste(IPasteContext context) {
        DiagramEditor activeEditor = FMCUtil.getActiveEditor();
        Point p = activeEditor.getDiagramBehavior().calculateRealMouseLocation(activeEditor.getDiagramBehavior().getMouseLocation());
        Object[] objects = this.getFromClipboard();
        if (objects != null && objects.length > 0) {
            this.pastePictogramElements(context, p, objects);
        } else {
            this.pasteImage(context);
        }
    }

    private void pasteImage(IPasteContext context) {
        String imageId = PasteFromClipboard.pasteImagesFromClipboard((BlockDiagramEditor)this.getDiagramBehavior().getDiagramContainer());
        if (imageId != null) {
            AddContext ac = new AddContext();
            ac.setLocation(((Integer)context.getProperty((Object)"mouseX")).intValue(), ((Integer)context.getProperty((Object)"mouseY")).intValue());
            ac.setTargetContainer((ContainerShape)this.getDiagram());
            ac.putProperty((Object)"imageid", (Object)imageId);
            ac.setNewObject(this.getImageModelObject());
            this.addGraphicalRepresentation((IAreaContext)ac, this.getImageModelObject());
        }
    }

    protected Object getImageModelObject() {
        return FMCType.Image;
    }

    private ILocation getMinimumLocation(Object[] shapes) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        Object[] objectArray = shapes;
        int n = shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Shape) {
                Shape shape = (Shape)obj;
                if (minX > shape.getGraphicsAlgorithm().getX()) {
                    minX = shape.getGraphicsAlgorithm().getX();
                }
                if (minY > shape.getGraphicsAlgorithm().getY()) {
                    minY = shape.getGraphicsAlgorithm().getY();
                }
            }
            ++n2;
        }
        return new LocationImpl(minX, minY);
    }

    private boolean containsTargetContainer(Object targetContainer, Object[] shapes) {
        Object[] objectArray = shapes;
        int n = shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (targetContainer.equals(obj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void pastePictogramElements(IPasteContext context, Point p, Object[] objects) {
        HashMap<ILocation, Shape> shapeLocations = new HashMap<ILocation, Shape>();
        ILocation minimumLocation = this.getMinimumLocation(objects);
        ContainerShape targetContainer = (ContainerShape)context.getPictogramElements()[0];
        ArrayList<Shape> originalShapes = new ArrayList<Shape>();
        ArrayList<Shape> copiedShapes = new ArrayList<Shape>();
        if (this.containsTargetContainer(targetContainer, objects)) {
            targetContainer = this.getDiagram();
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Shape) {
                Shape copiedShape = (Shape)EcoreUtil.copy((EObject)((EObject)object));
                if (copiedShape instanceof ContainerShape) {
                    originalShapes.add((Shape)object);
                    copiedShapes.add(copiedShape);
                    ContainerShape originalContainer = (ContainerShape)object;
                    ContainerShape copiedContainer = (ContainerShape)copiedShape;
                    ArrayList<Shape> nestedOriginalShapes = new ArrayList<Shape>();
                    ArrayList<Shape> nestedcopiedShapes = new ArrayList<Shape>();
                    this.getAllNestedShapes(nestedOriginalShapes, (Collection<Shape>)originalContainer.getChildren());
                    this.getAllNestedShapes(nestedcopiedShapes, (Collection<Shape>)copiedContainer.getChildren());
                    this.copyConnections(nestedOriginalShapes, nestedcopiedShapes);
                }
                targetContainer.getChildren().add((Object)copiedShape);
                ILocation relativePosition = FMCUtil.getRelativePosition((PictogramElement)targetContainer, p.x, p.y);
                shapeLocations.put(relativePosition, copiedShape);
                copiedShape.getGraphicsAlgorithm().setX(relativePosition.getX() - minimumLocation.getX() + copiedShape.getGraphicsAlgorithm().getX());
                copiedShape.getGraphicsAlgorithm().setY(relativePosition.getY() - minimumLocation.getY() + copiedShape.getGraphicsAlgorithm().getY());
                if (FMCUtil.getBO((PictogramElement)copiedShape) != null) {
                    EObject copy = EcoreUtil.copy((EObject)FMCUtil.getBO((PictogramElement)copiedShape));
                    this.addCopyToModel(copy);
                    copiedShape.getLink().getBusinessObjects().clear();
                    copiedShape.getLink().getBusinessObjects().add((Object)copy);
                }
                this.copyConnections(originalShapes, copiedShapes);
                this.getDiagram().getChildren().add((Object)copiedShape);
            }
            ++n2;
        }
    }

    protected void addCopyToModel(EObject copy) {
    }

    private void getAllNestedShapes(Collection<Shape> nested, Collection<Shape> shapes) {
        for (Shape shape : shapes) {
            nested.add(shape);
            if (!(shape instanceof ContainerShape)) continue;
            this.getAllNestedShapes(nested, (Collection<Shape>)((ContainerShape)shape).getChildren());
        }
    }

    private void copyConnections(List<Shape> originalShapes, List<Shape> copiedShapes) {
        HashSet<Connection> conToCopy = new HashSet<Connection>();
        for (Connection con : this.getDiagram().getConnections()) {
            boolean startFound = false;
            boolean endFound = false;
            for (Shape shape : originalShapes) {
                if (con.getStart() != null && shape.equals(con.getStart().getParent())) {
                    startFound = true;
                }
                if (con.getEnd() != null && shape.equals(con.getEnd().getParent())) {
                    endFound = true;
                }
                if (startFound && endFound) break;
            }
            if (!startFound || !endFound) continue;
            conToCopy.add(con);
        }
        for (Connection connection : conToCopy) {
            Connection copy = (Connection)EcoreUtil.copy((EObject)connection);
            Shape start = this.findCopy(originalShapes, copiedShapes, (Shape)connection.getStart().getParent());
            Shape end = this.findCopy(originalShapes, copiedShapes, (Shape)connection.getEnd().getParent());
            copy.setStart((Anchor)start.getAnchors().get(0));
            copy.setEnd((Anchor)end.getAnchors().get(0));
            this.getDiagram().getConnections().add((Object)copy);
        }
    }

    private Shape findCopy(List<Shape> originalShapes, List<Shape> copiedShapes, Shape original) {
        return copiedShapes.get(originalShapes.indexOf(original));
    }

    protected PictogramElement addGraphicalRepresentation(IAreaContext context, Object newObject) {
        if (context instanceof IAddContext) {
            return this.getFeatureProvider().addIfPossible((IAddContext)context);
        }
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext(context, newObject));
    }

    public boolean canPaste(IPasteContext context) {
        return true;
    }
}

