/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import java.util.Iterator;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.property.FMCPropertySection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DiagramPropertySection
extends FMCPropertySection {
    private FMCNodeAlgorithmFactory factory = FMCNodeAlgorithmFactory.getInstance();
    private Spinner gridUnit;
    private Button anchorsVisible;
    private Button anchorsEnabled;

    Button getAnchorsVisible() {
        return this.anchorsVisible;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory fac = this.getWidgetFactory();
        this.comp = fac.createComposite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(2, false));
        this.createDiagramControls(fac);
        this.refresh();
    }

    protected void createGridUnit(TabbedPropertySheetWidgetFactory fac) {
        fac.createLabel(this.comp, "GridUnit:");
        this.gridUnit = new Spinner(this.comp, 2048);
        this.gridUnit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Diagram diagram;
                int unit = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = DiagramPropertySection.this.getSingleInput();
                if (el != null && el instanceof Diagram && unit != (diagram = (Diagram)el).getGridUnit()) {
                    DiagramPropertySection.this.getActions().changeGridUnit(diagram, unit);
                }
            }
        });
    }

    protected void createAnchorsVisible(TabbedPropertySheetWidgetFactory fac) {
        fac.createLabel(this.comp, "Anchors visible:");
        this.anchorsVisible = new Button(this.comp, 32);
        this.anchorsVisible.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagramPropertySection.this.getActions().visualizeAnchors((ContainerShape)DiagramPropertySection.this.getDiagram(), DiagramPropertySection.this.anchorsVisible.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createAnchorsEnabled(TabbedPropertySheetWidgetFactory fac) {
        fac.createLabel(this.comp, "Anchors enabled:");
        this.anchorsEnabled = new Button(this.comp, 32);
        this.anchorsEnabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagramPropertySection.this.getActions().enableAnchors((ContainerShape)DiagramPropertySection.this.getDiagram(), DiagramPropertySection.this.anchorsEnabled.getSelection());
                if (DiagramPropertySection.this.anchorsEnabled.getSelection() && DiagramPropertySection.this.anchorsVisible.getSelection()) {
                    DiagramPropertySection.this.getActions().visualizeAnchors((ContainerShape)DiagramPropertySection.this.getDiagram(), DiagramPropertySection.this.anchorsVisible.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createDiagramControls(TabbedPropertySheetWidgetFactory fac) {
        this.createAnchorsVisible(fac);
        this.createAnchorsEnabled(fac);
    }

    public void refresh() {
        super.refresh();
        boolean visible = false;
        boolean enabled = false;
        if (this.getSingleInput() instanceof Diagram) {
            Diagram diag = (Diagram)this.getSingleInput();
            Iterator iterator = diag.getChildren().iterator();
            while (!visible && iterator.hasNext()) {
                Shape shape = (Shape)iterator.next();
                FMCNodeAlgorithm nodeAlgorithm = this.factory.getShape((PictogramElement)shape);
                if (nodeAlgorithm == null) continue;
                if (nodeAlgorithm.isBoxAnchorsVisible(shape)) {
                    visible = true;
                }
                if (!nodeAlgorithm.hasUnusedAnchors(shape)) continue;
                enabled = true;
            }
            this.anchorsVisible.setSelection(visible);
            this.anchorsEnabled.setSelection(enabled);
        }
    }
}

