/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features;

import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;

public class CompositeFeature
implements IFeature {
    private final IFeature[] features;

    protected IFeature getFeature(int i) {
        return this.features[i];
    }

    public CompositeFeature(IFeature ... features) {
        this.features = features;
    }

    public String getName() {
        return "Composite feature";
    }

    public String getDescription() {
        return "Executes mutiple features at the same time";
    }

    public IFeatureProvider getFeatureProvider() {
        return this.features[0].getFeatureProvider();
    }

    public boolean isAvailable(IContext context) {
        IFeature[] iFeatureArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (!feature.isAvailable(context)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean canExecute(IContext context) {
        IFeature[] iFeatureArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (!feature.canExecute(context)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void execute(IContext context) {
        IFeature[] iFeatureArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            feature.execute(context);
            ++n2;
        }
    }

    public boolean canUndo(IContext context) {
        IFeature[] iFeatureArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (!feature.canUndo(context)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasDoneChanges() {
        IFeature[] iFeatureArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (feature.hasDoneChanges()) {
                return true;
            }
            ++n2;
        }
        return true;
    }
}

