/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.HumanAgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.features.add.FMCNodeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class HumanAgentAddFeature
extends FMCNodeAddFeature {
    private static int MIN_WIDTH = 70;
    private static int MIN_HEIGHT = 70;

    public HumanAgentAddFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
        this.minimumHeight = MIN_HEIGHT;
        this.minimumWidth = MIN_WIDTH;
    }

    public HumanAgentAddFeature(IFeatureProvider featureProvider, String text, int minWidth, int minHeight, int angle) {
        super(featureProvider, text, angle);
        this.minimumHeight = minHeight;
        this.minimumWidth = minWidth;
    }

    public HumanAgentAddFeature(IFeatureProvider featureProvider, ShapeStyle style) {
        super(featureProvider, style);
        this.minimumWidth = MIN_WIDTH;
        this.minimumHeight = MIN_HEIGHT;
        this.setDefaultSize(style);
    }

    @Override
    public PictogramElement add(IAddContext context) {
        ContainerShape newShape = this.pe.createContainerShape(context.getTargetContainer(), true);
        GraphicsAlgorithm firstLevelGa = this.createGraphics((GraphicsAlgorithmContainer)newShape, context);
        firstLevelGa.setLineVisible(Boolean.valueOf(false));
        firstLevelGa.setFilled(Boolean.valueOf(false));
        this.ga.setLocationAndSize(firstLevelGa, context.getX(), context.getY(), this.getWidth(context), this.getHeight(context));
        GraphicsAlgorithm secondLevelGa = this.createGraphics((GraphicsAlgorithmContainer)firstLevelGa, context);
        secondLevelGa.setParentGraphicsAlgorithm(firstLevelGa);
        this.addText(newShape, Orientation.ALIGNMENT_BOTTOM, context.getNewObject());
        this.link((PictogramElement)newShape, context.getNewObject());
        return newShape;
    }

    private void setDefaultSize(ShapeStyle style) {
        block7: {
            block6: {
                if (style == null) break block6;
                switch (style) {
                    case RECT: {
                        this.minimumWidth = 70;
                        this.minimumHeight = 50;
                        break block7;
                    }
                    case L: {
                        this.minimumWidth = 60;
                        this.minimumHeight = 70;
                        break block7;
                    }
                    case U: {
                        this.minimumWidth = 90;
                        this.minimumHeight = 70;
                        break block7;
                    }
                    default: {
                        assert (false) : "No style literal matched in switch";
                        break block7;
                    }
                }
            }
            this.minimumWidth = MIN_WIDTH;
            this.minimumHeight = MIN_HEIGHT;
        }
    }

    @Override
    protected GraphicsAlgorithm createGraphics(GraphicsAlgorithmContainer gaContainer, IAddContext context) {
        HumanAgentAlgorithm algorithm = FMCNodeAlgorithmFactory.getInstance().getHumanAgent();
        return algorithm.createGraphics(this.getDiagram(), gaContainer, 0, 0, this.getWidth(context), this.getHeight(context));
    }
}

