/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public abstract class ConnectionAddFeature
extends AbstractAddFeature {
    protected ConnectionStyle style;

    public ConnectionAddFeature(IFeatureProvider featureProvider, ConnectionStyle type) {
        super(featureProvider);
        this.style = type;
    }

    protected Connection createConnection() {
        IPeService pe = Graphiti.getPeService();
        switch (this.style) {
            case NORMAL: {
                return pe.createFreeFormConnection(this.getDiagram());
            }
            case MANHATTAN: {
                return pe.createManhattanConnection(this.getDiagram());
            }
            case COMPOSITE: {
                return pe.createCompositeConnection(this.getDiagram());
            }
        }
        return pe.createManhattanConnection(this.getDiagram());
    }

    public static void createArrowDecorator(Diagram diagram, Connection con, boolean defaultDirection) {
        ConnectionDecorator deco = Graphiti.getPeService().createConnectionDecorator(con, false, defaultDirection ? 1.0 : 0.0, true);
        int[] nArray = new int[8];
        nArray[0] = -15;
        nArray[1] = 6;
        nArray[4] = -15;
        nArray[5] = -6;
        nArray[6] = -12;
        Polygon poly = Graphiti.getGaService().createPolygon((GraphicsAlgorithmContainer)deco, nArray);
        poly.setBackground(Graphiti.getGaService().manageColor(diagram, 0, 0, 0));
    }
}

