/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.features.add.FMCNodeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;

public class AgentAddFeature
extends FMCNodeAddFeature {
    public AgentAddFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
        this.minimumWidth = 70;
        this.minimumHeight = 50;
    }

    public AgentAddFeature(IFeatureProvider featureProvider, String title, int width, int height, int angle) {
        super(featureProvider, title, angle);
        this.minimumHeight = height;
        this.minimumWidth = width;
    }

    public AgentAddFeature(IFeatureProvider featureProvider, ShapeStyle style) {
        super(featureProvider, style);
        this.setDefaultSize(style);
    }

    private void setDefaultSize(ShapeStyle style) {
        block7: {
            block6: {
                if (style == null) break block6;
                switch (style) {
                    case RECT: {
                        this.minimumWidth = 70;
                        this.minimumHeight = 50;
                        break block7;
                    }
                    case L: {
                        this.minimumWidth = 60;
                        this.minimumHeight = 70;
                        break block7;
                    }
                    case U: {
                        this.minimumWidth = 90;
                        this.minimumHeight = 70;
                        break block7;
                    }
                    default: {
                        assert (false) : "No style literal matched in switch";
                        break block7;
                    }
                }
            }
            this.minimumWidth = 70;
            this.minimumHeight = 50;
        }
    }

    @Override
    protected GraphicsAlgorithm createGraphics(GraphicsAlgorithmContainer gaContainer, IAddContext context) {
        AgentAlgorithm algorithm = FMCNodeAlgorithmFactory.getInstance().getAgentByShapestyle(this.shapeType);
        return algorithm.createGraphics(this.getDiagram(), gaContainer, 0, 0, this.getWidth(context), this.getHeight(context));
    }
}

