/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.features.update;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.meta.profile.IStereotypeProvider;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.FMCElement;
import org.eclipse.fmc.mm.FMCNode;
import org.eclipse.fmc.mm.MultiplicityType;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class FMCNodeUpdateFeature
extends AbstractUpdateFeature {
    protected FMCNodeAlgorithmFactory factory = FMCNodeAlgorithmFactory.getInstance();
    private IStereotypeProvider stereotypeProvider;

    public FMCNodeUpdateFeature(IFeatureProvider fp, IStereotypeProvider stereotypeProvider) {
        super(fp);
        this.stereotypeProvider = stereotypeProvider;
    }

    public boolean canUpdate(IUpdateContext context) {
        return context.getPictogramElement() instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        EObject bo = FMCUtil.getBO((PictogramElement)context.getPictogramElement());
        if (bo instanceof FMCNode) {
            FMCNode node = (FMCNode)bo;
            ContainerShape container = (ContainerShape)context.getPictogramElement();
            return this.updateNeeded(container, node);
        }
        return Reason.createFalseReason();
    }

    protected boolean isContainerMainMultiPart(FMCNodeAlgorithm algorithm, ContainerShape container) {
        if (container.eContainer() == null || !(container.eContainer() instanceof ContainerShape)) {
            return false;
        }
        ContainerShape containerParent = (ContainerShape)container.eContainer();
        return container.getGraphicsAlgorithm().equals(algorithm.getMultiInstanceChild(containerParent, true));
    }

    protected boolean isContainerMultiPart(FMCNodeAlgorithm algorithm, ContainerShape container) {
        if (container.eContainer() == null || !(container.eContainer() instanceof ContainerShape)) {
            return false;
        }
        ContainerShape containerParent = (ContainerShape)container.eContainer();
        return container.getGraphicsAlgorithm().equals(algorithm.getMultiInstanceChild(containerParent, true)) || container.getGraphicsAlgorithm().equals(algorithm.getMultiInstanceChild(containerParent, false));
    }

    protected boolean isMultiPart(FMCNodeAlgorithm algorithm, ContainerShape container) {
        GraphicsAlgorithm invisibleGa = container.getGraphicsAlgorithm();
        return invisibleGa.getGraphicsAlgorithmChildren().size() == 2;
    }

    protected boolean shouldUpdateMainShape(FMCNodeAlgorithm algorithm, ContainerShape container) {
        boolean isThisContainerAMultiPart = this.isContainerMultiPart(algorithm, container);
        boolean isThisContainerMainMultiPart = this.isContainerMainMultiPart(algorithm, container);
        boolean isMultiInstance = algorithm.isMultipleInstances(container);
        return !isMultiInstance && !isThisContainerAMultiPart || isThisContainerMainMultiPart;
    }

    protected IReason updateNeeded(ContainerShape container, FMCNode node) {
        FMCNodeAlgorithm algorithm = this.factory.getShape((PictogramElement)container);
        if (algorithm != null) {
            boolean isThisContainerAMultiPart = this.isContainerMultiPart(algorithm, container);
            boolean isMultiInstance = algorithm.isMultipleInstances(container);
            AbstractText text = this.findText(container);
            if (this.shouldUpdateMainShape(algorithm, container) && !this.equalsText(text, node)) {
                return Reason.createTrueReason((String)"The text is not in synch with domain model");
            }
            boolean graphMulti = this.gaphicalMultiplicity(container, node);
            if (!isThisContainerAMultiPart && isMultiInstance != (node.getMultiplicity() == MultiplicityType.MANY) && !graphMulti || graphMulti && node.getMultiplicity() == MultiplicityType.MANY) {
                return Reason.createTrueReason((String)"The multiplicity is not in synch wiht domain model");
            }
        }
        return Reason.createFalseReason();
    }

    protected boolean gaphicalMultiplicity(ContainerShape container, FMCNode node) {
        return false;
    }

    protected AbstractText findText(ContainerShape container) {
        for (Shape shape : container.getChildren()) {
            if (!(shape.getGraphicsAlgorithm() instanceof AbstractText)) continue;
            return (AbstractText)shape.getGraphicsAlgorithm();
        }
        AbstractText text = null;
        for (Shape shape : container.getChildren()) {
            if (text != null || !(shape instanceof ContainerShape)) continue;
            text = this.findText((ContainerShape)shape);
        }
        return text;
    }

    public boolean update(IUpdateContext context) {
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        FMCNode node = (FMCNode)FMCUtil.getBO((PictogramElement)container);
        FMCNodeAlgorithm algorithm = this.factory.getShape((PictogramElement)container);
        if (algorithm == null) {
            return false;
        }
        boolean isMultiInstance = algorithm.isMultipleInstances(container);
        if (!isMultiInstance || this.isContainerMainMultiPart(algorithm, container)) {
            this.updateText(context, node);
        }
        boolean graphMulti = this.gaphicalMultiplicity(container, node);
        if (node.getMultiplicity() == MultiplicityType.MANY != isMultiInstance && !this.isContainerMultiPart(algorithm, container) && !graphMulti || graphMulti && node.getMultiplicity() == MultiplicityType.MANY && this.isMultiPart(algorithm, container)) {
            this.updateMultiplicity(context.getPictogramElement(), algorithm, node, graphMulti);
        }
        return true;
    }

    protected void updateText(IUpdateContext context, FMCNode node) {
        AbstractText text = this.findText((ContainerShape)context.getPictogramElement());
        if (text != null) {
            String nodeText;
            String stereotypeText = "";
            if (this.stereotypeProvider != null) {
                stereotypeText = this.stereotypeProvider.getStereotypeText((FMCElement)node);
            }
            text.setValue((nodeText = node.getName()) == null ? stereotypeText : String.valueOf(stereotypeText) + nodeText);
        }
    }

    protected void updateMultiplicity(PictogramElement picto, FMCNodeAlgorithm algorithm, FMCNode node, boolean graphMulti) {
        algorithm.setMultipleInstances((ContainerShape)picto, this.getFeatureProvider(), node.getMultiplicity() == MultiplicityType.MANY && !graphMulti);
    }

    protected boolean equalsText(AbstractText text, FMCNode node) {
        if (text == null || node.getName() == null) {
            return true;
        }
        String substringText = text.getValue();
        if (this.stereotypeProvider != null) {
            substringText = FMCUtil.substringStereotype((String)substringText);
        }
        return substringText.equals(node.getName());
    }
}

