/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.features.update;

import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.FMCConnectionUpdateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.profile.IStereotypeProvider;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.Channel;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.FMCConnection;
import org.eclipse.fmc.mm.FMCElement;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CommunicationChannelUpdateFeature
extends FMCConnectionUpdateFeature {
    public CommunicationChannelUpdateFeature(IFeatureProvider fp, IStereotypeProvider stereotypeProvider) {
        super(fp, stereotypeProvider);
    }

    protected AbstractText getText(Connection con) {
        for (ConnectionDecorator decorator : con.getConnectionDecorators()) {
            if (!(decorator.getGraphicsAlgorithm() instanceof AbstractText) || !decorator.isActive() || "R".equals(((AbstractText)decorator.getGraphicsAlgorithm()).getValue())) continue;
            return (AbstractText)decorator.getGraphicsAlgorithm();
        }
        return null;
    }

    @Override
    protected IReason updateNeeded(Connection conShape, FMCConnection connection) {
        Channel channel = (Channel)connection;
        FMCConnectionAlgorithm algorithm = this.factory.getAlgorithm((PictogramElement)conShape);
        AbstractText text = this.getText(conShape);
        if (!(text == null && channel.getName() == null || text != null && FMCUtil.substringStereotype((String)text.getValue()).equals(channel.getName()))) {
            return Reason.createTrueReason((String)"The text is not in synch with domain model");
        }
        if (channel.getDataflowDirection() != algorithm.getDirection(conShape)) {
            return Reason.createTrueReason((String)"The data flow direction is not in synch with domain model");
        }
        if (channel.getChannelType() != algorithm.getRequestDirection(conShape)) {
            return Reason.createTrueReason((String)"The request direction is not in synch with domain model");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        Connection con = (Connection)context.getPictogramElement();
        Channel channel = (Channel)FMCUtil.getBO((PictogramElement)con);
        FMCConnectionAlgorithm algorithm = this.factory.getAlgorithm((PictogramElement)con);
        this.updateText(context, channel);
        if (channel.getDataflowDirection() != algorithm.getDirection(con)) {
            this.updateDataflowDirection(context, channel);
        }
        if (channel.getChannelType() != algorithm.getRequestDirection(con)) {
            this.updateRequestDirection(context, channel);
        }
        return true;
    }

    private void updateDataflowDirection(IUpdateContext context, Channel channel) {
        Connection conShape = (Connection)context.getPictogramElement();
        this.factory.getAlgorithm((PictogramElement)conShape).setDirection(conShape, channel.getDataflowDirection(), this.getDiagram());
        if (channel.getDataflowDirection() != DataflowDirection.UNSPECIFIED && channel.getChannelType() != RequestDirection.UNSPECIFIED) {
            channel.setChannelType(RequestDirection.UNSPECIFIED);
        }
    }

    private void updateRequestDirection(IUpdateContext context, Channel channel) {
        Connection conShape = (Connection)context.getPictogramElement();
        this.factory.getAlgorithm((PictogramElement)conShape).setRequestDirection(conShape, channel.getChannelType(), this.getDiagram());
        if (channel.getDataflowDirection() != DataflowDirection.UNSPECIFIED && channel.getChannelType() != RequestDirection.UNSPECIFIED) {
            channel.setDataflowDirection(DataflowDirection.UNSPECIFIED);
        }
    }

    private void updateText(IUpdateContext context, Channel channel) {
        AbstractText text = this.getText((Connection)context.getPictogramElement());
        if (text != null) {
            String nodeText;
            String stereotypeText = "";
            if (this.stereotypeProvider != null) {
                stereotypeText = this.stereotypeProvider.getStereotypeText((FMCElement)channel);
            }
            text.setValue((nodeText = channel.getName()) == null ? stereotypeText : String.valueOf(stereotypeText) + nodeText);
        }
    }
}

