/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.etrice.core.common.ui.editor.ISaveOnFocusLostEditor;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class SaveOnFocusLostListener
implements IPartListener,
IStartup {
    public void earlyStartup() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IPartService partService;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IPartService iPartService = partService = window != null ? window.getPartService() : null;
            if (partService != null) {
                partService.addPartListener((IPartListener)this);
            } else {
                Status status = new Status(4, "org.eclipse.etrice.ui.common.base", "Failed to register " + this.getClass().getSimpleName());
                StatusManager.getManager().handle((IStatus)status);
            }
        });
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part instanceof ISaveOnFocusLostEditor) {
            ISaveOnFocusLostEditor editor = (ISaveOnFocusLostEditor)part;
            boolean isPrefSave = Platform.getPreferencesService().getBoolean("org.eclipse.etrice.ui.common.base", "SaveDiagOnFocusLost", false, null);
            if (isPrefSave && editor.shouldSaveOnFocusLost()) {
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

