/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EnumerationTypeGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;

    public void doGenerate(Root root) {
        Functions.Function1 function1 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Consumer<EnumerationType> consumer = et -> {
            String path = this._roomExtensions.getPath((RoomClass)et);
            String file = this._cExtensions.getCHeaderFileName((RoomClass)et);
            this.fileIO.generateFile("generating Enumeration header", path + file, this.generateHeaderFile(root, (EnumerationType)et));
            file = this._cExtensions.getCSourceFileName((RoomClass)et);
            this.fileIO.generateFile("generating Enumeration source", path + file, this.generateSourceFile(root, (EnumerationType)et));
        };
        IterableExtensions.filter((Iterable)root.getEnumClasses(), (Functions.Function1)function1).forEach(consumer);
    }

    private CharSequence generateHeaderFile(Root root, EnumerationType et) {
        Object object;
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Header File of Enumeration ");
        String string = et.getName();
        stringConcatenation.append(string, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("* ");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence = this._cExtensions.generateIncludeGuardBegin((RoomClass)et);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"etDatatypes.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        Object object2 = et.getPrimitiveType();
        boolean bl2 = bl = object2 != null;
        if (bl) {
            object = et.getLiterals();
            for (EnumLiteral lit : object) {
                stringConcatenation.append("#define ");
                String string2 = et.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append("_");
                String string3 = lit.getName();
                stringConcatenation.append(string3);
                stringConcatenation.append(" ");
                String string4 = this._cExtensions.getCastedValue(lit);
                stringConcatenation.append(string4);
                stringConcatenation.newLineIfNotEmpty();
            }
        } else {
            stringConcatenation.append("typedef enum ");
            object = et.getName();
            stringConcatenation.append((String)object);
            stringConcatenation.append(" {");
            stringConcatenation.newLineIfNotEmpty();
            Object object3 = et.getLiterals();
            boolean bl3 = false;
            for (EnumLiteral lit_1 : object3) {
                if (!bl3) {
                    bl3 = true;
                } else {
                    stringConcatenation.appendImmediate((Object)",", "\t");
                }
                stringConcatenation.append("\t");
                String string5 = et.getName();
                stringConcatenation.append(string5, "\t");
                stringConcatenation.append("_");
                String string6 = lit_1.getName();
                stringConcatenation.append(string6, "\t");
                stringConcatenation.append(" = ");
                long l = lit_1.getLiteralValue();
                stringConcatenation.append((Object)l, "\t");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            object3 = et.getName();
            stringConcatenation.append((String)object3);
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("const char* ");
        object2 = et.getName();
        stringConcatenation.append((String)object2);
        stringConcatenation.append("_getLiteralName(");
        String string7 = this._typeHelpers.typeName((DataType)et);
        stringConcatenation.append(string7);
        stringConcatenation.append(" literal);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        object = this._cExtensions.generateIncludeGuardEnd((RoomClass)et);
        stringConcatenation.append(object);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateSourceFile(Root root, EnumerationType et) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Source File of ProtocolClass ");
        String string = et.getName();
        stringConcatenation.append(string, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("* ");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string2 = this._cExtensions.getCHeaderFileName((RoomClass)et);
        stringConcatenation.append(string2);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("const char* ");
        String string3 = et.getName();
        stringConcatenation.append(string3);
        stringConcatenation.append("_getLiteralName(");
        String string4 = this._typeHelpers.typeName((DataType)et);
        stringConcatenation.append(string4);
        stringConcatenation.append(" literal) {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("switch(literal) {");
        stringConcatenation.newLine();
        EList eList = et.getLiterals();
        for (EnumLiteral lit : eList) {
            stringConcatenation.append("\t\t");
            stringConcatenation.append("case ");
            String string5 = et.getName();
            stringConcatenation.append(string5, "\t\t");
            stringConcatenation.append("_");
            String string6 = lit.getName();
            stringConcatenation.append(string6, "\t\t");
            stringConcatenation.append(": return \"");
            String string7 = lit.getName();
            stringConcatenation.append(string7, "\t\t");
            stringConcatenation.append("\";");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("return NULL;");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        return stringConcatenation;
    }
}

