/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.hover.highlight;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class XtextTokenScanner
extends RuleBasedScanner {
    protected String languageName;
    protected final IToken keywordToken = new CodeToken("keyword");
    protected final IToken stringToken = new CodeToken("string");
    protected final IToken commentToken = new CodeToken("comment");
    private char cachedToken = (char)65535;
    protected WordRule keywordRule = new WordRule(new IWordDetector(){

        public boolean isWordStart(char c) {
            return !Character.isWhitespace(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }, Token.UNDEFINED, false);

    protected boolean isId(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    public XtextTokenScanner(String languageName, String[] keywords) {
        this.languageName = languageName;
        this.setRules(this.computeRules(keywords).toArray(new IRule[0]));
    }

    public String getLanguageName() {
        return this.languageName;
    }

    protected List<IRule> computeRules(String[] keywords) {
        ArrayList rules = Lists.newArrayList();
        rules.add(new EndOfLineRule("//", this.commentToken));
        rules.add(new MultiLineRule("/*", "*/", this.commentToken));
        rules.add(new MultiLineRule("'''", "'''", this.stringToken));
        rules.add(new SingleLineRule("\"", "\"", this.stringToken, '\\'));
        rules.add(new SingleLineRule("'", "'", this.stringToken, '\\'));
        int i = 0;
        while (i < keywords.length) {
            this.keywordRule.addWord(keywords[i], this.keywordToken);
            ++i;
        }
        rules.add(this.keywordRule);
        return rules;
    }

    public IToken nextToken() {
        char last = this.cachedToken;
        IToken result = super.nextToken();
        this.unread();
        char end = (char)this.read();
        char next = this.cachedToken = (char)this.read();
        if (result == this.keywordToken && (this.isId(next) || this.isId(last))) {
            return this.fDefaultReturnToken;
        }
        this.unread();
        this.cachedToken = end;
        return result;
    }

    public static class CodeToken
    extends Token {
        public CodeToken(String name) {
            super((Object)name);
        }
    }
}

