/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.builder;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.genmodel.builder.BindingUtil;
import org.eclipse.etrice.core.genmodel.builder.Wiring;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInterfaceInstance;
import org.eclipse.etrice.core.genmodel.etricegen.BindingInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ConnectionInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenFactory;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedProtocolClass;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.OptionalActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortKind;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SPPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.impl.AbstractInstanceImpl;
import org.eclipse.etrice.core.genmodel.etricegen.impl.StructureInstanceImpl;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilder;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilderFactory;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.xtext.EcoreUtil2;

public class GeneratorModelBuilder {
    private RoomHelpers roomHelpers = new RoomHelpers();
    HashSet<WorkItem> alreadyDone = new HashSet();
    private static final int OBJ_ID_OFFSET = 0;
    private LinkedList<InstanceBase> allObjects = new LinkedList();
    private HashMap<ActorClass, OptionalActorInstance> optionalActors = new HashMap();
    private ILogger logger;
    private IDiagnostician diagnostician;
    private ExtendedFsmGenBuilderFactory fsmGenBuilderFactory;
    private boolean debug;

    public GeneratorModelBuilder(ExtendedFsmGenBuilderFactory fsmGenBuilderFactory, ILogger logger, IDiagnostician diagnostician) {
        this.logger = logger;
        this.diagnostician = diagnostician;
        this.fsmGenBuilderFactory = fsmGenBuilderFactory;
    }

    public Root createGeneratorModel(List<RoomModel> mainModels, List<RoomModel> importedModels, boolean asLibrary) {
        return this.createGeneratorModel(mainModels, importedModels, asLibrary, false);
    }

    public Root createGeneratorModel(List<RoomModel> mainModels, List<RoomModel> importedModels, boolean asLibrary, boolean debug) {
        Root root = ETriceGenFactory.eINSTANCE.createRoot();
        root.getModels().addAll(mainModels);
        root.getImportedModels().addAll(importedModels);
        root.setLibrary(asLibrary);
        this.debug = debug;
        if (root.isLibrary()) {
            this.findOptionalActorClasses(root);
        } else {
            boolean hasSystem;
            this.checkRelayPorts(root);
            for (RoomModel mdl : mainModels) {
                this.roomHelpers.getRoomClasses(mdl, LogicalSystem.class).forEach(sys -> {
                    SystemInstance si = this.createLogicalSystemInstance((LogicalSystem)sys);
                    root.getSystemInstances().add((Object)si);
                });
            }
            boolean bl = hasSystem = !root.getSystemInstances().isEmpty();
            if (!hasSystem) {
                this.logger.logInfo("GeneratorModelBuilder: no SystemClass found, assuming SubSystemClasses as top level elements");
                for (SubSystemClass comp : root.getSubSystemClasses()) {
                    root.getOwnSubSystemInstances().add((Object)this.createSubSystemInstance(comp, comp.getName()));
                }
            }
            if (!root.getSubSystemInstances().isEmpty()) {
                this.createOptionalActorInstanceTrees(root);
                this.connectPorts(root);
                this.checkPortMultiplicity(root);
                this.connectServices(root);
                this.matchOptionalActorInstances(root);
            }
            this.setObjectIDs();
        }
        this.createWiredInstances(root);
        this.createExpandedActorClasses(root);
        if (!root.isLibrary()) {
            this.createExpandedProtocolClasses(root);
        }
        return root;
    }

    private void createWiredInstances(Root root) {
        new Wiring(root).createWiredClasses();
    }

    boolean dependenciesSatisfied(WorkItem ... items) {
        WorkItem[] workItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItem item = workItemArray[n2];
            if (!this.alreadyDone.contains((Object)item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void matchOptionalActorInstances(Root root) {
        assert (this.dependenciesSatisfied(WorkItem.CONNECT_SERVICES, WorkItem.CREATE_OPTIONAL_INSTANCES)) : "dependencies satisfied";
        for (SubSystemInstance ssi : root.getSubSystemInstances()) {
            TreeIterator it = ssi.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof ActorInterfaceInstance)) continue;
                ActorInterfaceInstance aii = (ActorInterfaceInstance)obj;
                HashSet<ProtocolClass> provided = this.computeProvidedServices(aii);
                String kind = aii.isArray() ? "array" : "instance";
                this.logger.logInfo("matches for optional actor " + kind + ": " + aii.getPath());
                ActorClass optAC = aii.getActorClass();
                ArrayList<ActorClass> candidates = new ArrayList<ActorClass>((Collection<ActorClass>)root.getSubClasses(optAC));
                candidates.add(optAC);
                for (ActorClass candidate : candidates) {
                    if (candidate.isAbstract()) continue;
                    OptionalActorInstance optAIC = this.optionalActors.get(candidate);
                    HashSet<ProtocolClass> required = new HashSet<ProtocolClass>();
                    for (SAPInstance sap : optAIC.getRequiredServices()) {
                        required.add(sap.getProtocol());
                    }
                    if (provided.containsAll(required)) {
                        this.logger.logInfo("  ok: " + optAIC.getActorClass().getName());
                        aii.getOptionalInstances().add((Object)optAIC);
                        continue;
                    }
                    this.logger.logInfo("  SAPs not satisfied: " + optAIC.getActorClass().getName());
                    for (ProtocolClass pc : required) {
                        if (provided.contains(pc)) continue;
                        this.logger.logInfo("    missing protocol: " + pc.getName());
                    }
                }
            }
        }
    }

    private HashSet<ProtocolClass> computeProvidedServices(ActorInterfaceInstance aii) {
        HashSet<ProtocolClass> satisfied = new HashSet<ProtocolClass>();
        ActorInterfaceInstance inst = aii;
        while (inst instanceof AbstractInstanceImpl) {
            AbstractInstanceImpl sii = (AbstractInstanceImpl)((Object)inst);
            for (ServiceImplInstance svc : sii.protocol2service.values()) {
                if (satisfied.contains(svc.getProtocol())) continue;
                aii.getProvidedServices().add((Object)svc);
                satisfied.add(svc.getProtocol());
            }
            inst = inst.eContainer();
        }
        return satisfied;
    }

    private void findOptionalActorClasses(Root root) {
        HashSet<ActorClass> optionalActorClasses = new HashSet<ActorClass>();
        for (ActorClass ac : root.getActorClasses()) {
            for (ActorRef ar : ac.getActorRefs()) {
                if (ar.getRefType() != ReferenceType.OPTIONAL) continue;
                optionalActorClasses.add(ar.getType());
            }
        }
        root.getOptionalActorClasses().addAll(optionalActorClasses);
    }

    private void createOptionalActorInstanceTrees(Root root) {
        root.computeSubClasses();
        for (ActorClass ac : root.getActorClasses()) {
            for (ActorRef ar : ac.getActorRefs()) {
                if (ar.getRefType() != ReferenceType.OPTIONAL) continue;
                this.optionalActors.put(ar.getType(), null);
            }
        }
        root.getOptionalActorClasses().addAll(this.optionalActors.keySet());
        ArrayList<ActorClass> optional = new ArrayList<ActorClass>(this.optionalActors.keySet());
        for (ActorClass ac : optional) {
            EList<ActorClass> subCls = root.getSubClasses(ac);
            for (ActorClass subCl : subCls) {
                if (subCl.isAbstract()) continue;
                this.optionalActors.put(subCl, null);
            }
            if (!ac.isAbstract()) continue;
            this.optionalActors.remove(ac);
        }
        for (Map.Entry entry : this.optionalActors.entrySet()) {
            OptionalActorInstance ai = ETriceGenFactory.eINSTANCE.createOptionalActorInstance();
            this.recursivelyCreateActorInstances(ai, (ActorClass)entry.getKey(), ((ActorClass)entry.getKey()).getName(), -1);
            entry.setValue(ai);
            root.getOptionalInstances().add((Object)ai);
            for (PortInstance pi : ai.getPorts()) {
                if (pi.getKind() != PortKind.RELAY) continue;
                pi.setKind(PortKind.INTERFACE);
            }
        }
        for (OptionalActorInstance optAI : this.optionalActors.values()) {
            this.connectServices(optAI);
        }
        this.alreadyDone.add(WorkItem.CREATE_OPTIONAL_INSTANCES);
    }

    private void connectServices(OptionalActorInstance optAI) {
        this.createServiceMappings(optAI);
        this.bindSAPs(optAI, (List<SAPInstance>)optAI.getRequiredServices());
        HashMap<ProtocolClass, ServiceImplInstance> protocol2svc = new HashMap<ProtocolClass, ServiceImplInstance>();
        for (SAPInstance sap : optAI.getRequiredServices()) {
            ProtocolClass pc = sap.getProtocol();
            ServiceImplInstance svc = (ServiceImplInstance)protocol2svc.get(pc);
            if (svc == null) {
                svc = ETriceGenFactory.eINSTANCE.createServiceImplInstance();
                RoomModel mdl = (RoomModel)pc.eContainer();
                String fqn = mdl.getName() + "." + pc.getName();
                svc.setName(fqn.replace('.', '_'));
                protocol2svc.put(pc, svc);
                optAI.getServices().add((Object)svc);
            }
            sap.getPeers().add((Object)svc);
            svc.getPeers().add((Object)sap);
        }
    }

    private void connectServices(Root root) {
        this.createServiceMappings(root);
        this.bindSAPs(root);
        this.alreadyDone.add(WorkItem.CONNECT_SERVICES);
    }

    private void createServiceMappings(Root root) {
        assert (this.dependenciesSatisfied(WorkItem.CREATE_INSTANCES, WorkItem.CREATE_BINDINGS)) : "dependencies satisfied";
        for (SubSystemInstance comp : root.getSubSystemInstances()) {
            this.createServiceMappings(comp);
        }
    }

    private void createServiceMappings(StructureInstance si) {
        for (ConnectionInstance ci : si.getConnections()) {
            if (ci.getFromSPP() == null) {
                this.addService(ci.getFromAI(), ci);
                continue;
            }
            if (!ci.getFromSPP().getIncoming().isEmpty()) continue;
            this.addService(si, ci);
        }
        for (ActorInstance child : si.getActorInstances()) {
            this.createServiceMappings(child);
        }
    }

    private void addService(AbstractInstance si, ConnectionInstance ci) {
        assert (si instanceof AbstractInstanceImpl) : "unknown implementation " + si.eClass().getName();
        AbstractInstanceImpl sii = (AbstractInstanceImpl)si;
        ProtocolClass pc = ci.getToSPP().getSpp().getProtocol();
        if (sii.protocol2service.get(pc) != null) {
            Object obj = null;
            obj = si instanceof ActorInstance ? ((ActorInstance)si).getActorClass() : (si instanceof ActorInterfaceInstance ? ((ActorInterfaceInstance)si).getActorClass() : (si instanceof SubSystemInstance ? ((SubSystemInstance)si).getSubSystemClass() : si));
            this.diagnostician.error("A service can only be offered once per actor instance, consider pushing one down to a contained actor!", (EObject)obj, (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ServiceProvisionPoints());
        } else if (ci.getFromSPP() != null && ci.getFromSPP().getSpp().getProtocol() != pc) {
            this.diagnostician.error("Layer connection must connect same protocols!", (EObject)ci.getConnection(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        } else {
            SPPInstance sppi;
            do {
                if ((sppi = ci.getToSPP()).getOutgoing() != null) continue;
                boolean found = false;
                if (sppi.eContainer() instanceof ActorInstance) {
                    ActorInstance implementor = (ActorInstance)sppi.eContainer();
                    for (ServiceImplInstance svc : implementor.getServices()) {
                        if (svc.getSvcImpl().getSpp() != sppi.getSpp()) continue;
                        found = true;
                        sii.protocol2service.put(pc, svc);
                    }
                } else assert (false);
                if (!found) {
                    ActorContainerClass acr = (ActorContainerClass)sppi.getSpp().eContainer();
                    int idx = acr.getServiceProvisionPoints().indexOf((Object)sppi.getSpp());
                    this.diagnostician.error("An SPP mus be connected by a layer connection or implemented by a ServiceImplementation!", (EObject)sppi.getSpp(), (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ServiceProvisionPoints(), idx);
                }
                return;
            } while ((ci = sppi.getOutgoing()).getToSPP().getSpp().getProtocol() == pc);
            this.diagnostician.error("Layer connection must connect same protocols!", (EObject)ci.getConnection(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
            return;
        }
    }

    private void bindSAPs(Root root) {
        ArrayList<SAPInstance> unsatisfied = new ArrayList<SAPInstance>();
        for (SubSystemInstance comp : root.getSubSystemInstances()) {
            this.bindSAPs(comp, unsatisfied);
        }
        for (SAPInstance sap : unsatisfied) {
            EObject container;
            ActorClass ac = (ActorClass)sap.getSap().eContainer();
            int idx = ac.getServiceAccessPoints().indexOf((Object)sap.getSap());
            this.diagnostician.error("SAP " + sap.getPath() + " not satisfied!", (EObject)ac, (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_ServiceAccessPoints(), idx);
            SubSystemInstance subSystemInstance = (SubSystemInstance)EcoreUtil2.getContainerOfType((EObject)sap, SubSystemInstance.class);
            if (subSystemInstance == null || !((container = subSystemInstance.eContainer()) instanceof SystemInstance)) continue;
            SystemInstance systemInstance = (SystemInstance)container;
            idx = systemInstance.getInstances().indexOf((Object)subSystemInstance);
            this.diagnostician.error("SAP " + sap.getPath() + " not satisfied!", (EObject)systemInstance.getLogicalSystem(), (EStructuralFeature)RoomPackage.eINSTANCE.getLogicalSystem_SubSystems(), idx);
        }
    }

    private void bindSAPs(StructureInstance si, List<SAPInstance> unsatisfied) {
        for (SAPInstance sap : si.getSaps()) {
            if (this.bindSAP(si, sap)) continue;
            unsatisfied.add(sap);
        }
        for (ActorInstance child : si.getActorInstances()) {
            this.bindSAPs(child, unsatisfied);
        }
    }

    private boolean bindSAP(StructureInstance si, SAPInstance sap) {
        assert (si instanceof StructureInstanceImpl);
        StructureInstanceImpl sii = (StructureInstanceImpl)si;
        do {
            ServiceImplInstance svc;
            if ((svc = (ServiceImplInstance)sii.protocol2service.get(sap.getSap().getProtocol())) == null) continue;
            sap.getPeers().add((Object)svc);
            svc.getPeers().add((Object)sap);
            return true;
        } while ((sii = sii.eContainer() instanceof StructureInstanceImpl ? (StructureInstanceImpl)sii.eContainer() : null) != null);
        return false;
    }

    private void checkRelayPorts(Root root) {
        for (ActorClass ac : root.getActorClasses()) {
            for (Port port : ac.getRelayPorts()) {
                if (!(port.getProtocol() instanceof ProtocolClass) || port.getProtocol().getCommType() != CommunicationType.DATA_DRIVEN || !port.isConjugated()) continue;
                int count = 0;
                for (Binding b : ac.getBindings()) {
                    if (b.getEndpoint1().getPort() == port) {
                        ++count;
                    }
                    if (b.getEndpoint2().getPort() != port) continue;
                    ++count;
                }
                if (count <= true) continue;
                int idx = ac.getInterfacePorts().indexOf((Object)port);
                this.diagnostician.error("data driven conjugate relay port is multiply connected inside its actor class", (EObject)ac, (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_InterfacePorts(), idx);
            }
        }
    }

    private void setObjectIDs() {
        int counter = 0;
        for (InstanceBase obj : this.allObjects) {
            if (obj instanceof SubSystemInstance) {
                counter = 0;
                obj.setObjId(counter++);
                continue;
            }
            if (obj instanceof ActorInstance) {
                obj.setObjId(counter++);
                continue;
            }
            if (obj instanceof PortInstance) {
                PortInstance pi = (PortInstance)obj;
                if (pi.getKind() == PortKind.RELAY) continue;
                int multiplicity = Math.max(pi.getPeers().size(), 1);
                pi.setObjId(counter);
                counter += multiplicity;
                continue;
            }
            if (obj instanceof SAPInstance) {
                obj.setObjId(counter++);
                continue;
            }
            if (!(obj instanceof ServiceImplInstance)) continue;
            ServiceImplInstance svc = (ServiceImplInstance)obj;
            svc.setObjId(counter);
            counter += svc.getPeers().size();
        }
    }

    private SystemInstance createLogicalSystemInstance(LogicalSystem sys) {
        this.logger.logInfo("GeneratorModelBuilder: creating system class from " + sys.getName());
        SystemInstance instance = ETriceGenFactory.eINSTANCE.createSystemInstance();
        this.allObjects.add(instance);
        instance.setName(sys.getName());
        instance.setLogicalSystem(sys);
        for (SubSystemRef sr : sys.getSubSystems()) {
            SubSystemInstance ssi = this.createSubSystemInstance(sr.getType(), sr.getName());
            instance.getInstances().add((Object)ssi);
        }
        return instance;
    }

    private SubSystemInstance createSubSystemInstance(SubSystemClass ssc, String name) {
        this.logger.logInfo("GeneratorModelBuilder: creating subsystem instance from " + name);
        SubSystemInstance instance = ETriceGenFactory.eINSTANCE.createSubSystemInstance();
        this.allObjects.add(instance);
        instance.setName(name);
        instance.setSubSystemClass(ssc);
        this.createPortInstances((EList<Port>)ssc.getRelayPorts(), PortKind.INTERNAL, instance);
        for (ActorRef ar : ssc.getActorRefs()) {
            this.addRefInstances(instance, ar);
        }
        new BindingUtil(instance, this.diagnostician).createBindingInstances();
        this.createConnectionInstances(instance, (List<LayerConnection>)ssc.getConnections());
        this.alreadyDone.add(WorkItem.CREATE_INSTANCES);
        this.alreadyDone.add(WorkItem.CREATE_BINDINGS);
        this.alreadyDone.add(WorkItem.CREATE_PORTS);
        return instance;
    }

    private StructureInstance recursivelyCreateActorInstances(ActorRef aref) {
        return this.recursivelyCreateActorInstances(aref, -1);
    }

    private StructureInstance recursivelyCreateActorInstances(ActorRef aref, int idx) {
        Object name = aref.getName();
        if (idx >= 0) {
            name = (String)name + ":" + idx;
        }
        if (this.debug) {
            this.logger.logInfo("GeneratorModelBuilder: creating actor instance " + (String)name + " from " + aref.getType().getName());
        }
        if (aref.getType().isAbstract()) {
            ActorContainerClass parent = (ActorContainerClass)aref.eContainer();
            int offset = parent.getActorRefs().indexOf((Object)aref);
            this.diagnostician.error("Cannot instantiate abstract actor class '" + aref.getType().getName() + "' as reference '" + aref.getName() + "' in '" + parent.getName() + "'", aref.eContainer(), aref.eContainingFeature(), offset);
        }
        ActorInstance ai = ETriceGenFactory.eINSTANCE.createActorInstance();
        return this.recursivelyCreateActorInstances(ai, aref.getType(), (String)name, idx);
    }

    private StructureInstance recursivelyCreateActorInstances(StructureInstance ai, ActorClass ac, String name, int idx) {
        this.allObjects.add(ai);
        ai.setName(name);
        if (ai instanceof ActorInstance) {
            ((ActorInstance)ai).setActorClass(ac);
            if (idx >= 0) {
                ((ActorInstance)ai).setReplIdx(idx);
            }
        } else if (ai instanceof OptionalActorInstance) {
            ((OptionalActorInstance)ai).setActorClass(ac);
        }
        List classes = this.roomHelpers.getClassHierarchy(ac);
        for (ActorClass acl : classes) {
            this.createPortInstances(ai, acl);
            this.createServiceRelatedInstances(ai, acl);
            for (ActorRef ar : acl.getActorRefs()) {
                this.addRefInstances(ai, ar);
            }
        }
        new BindingUtil(ai, this.diagnostician).createBindingInstances();
        ArrayList<LayerConnection> connections = new ArrayList<LayerConnection>();
        for (ActorClass acl : classes) {
            connections.addAll((Collection<LayerConnection>)acl.getConnections());
        }
        this.createConnectionInstances(ai, connections);
        return ai;
    }

    private ActorInterfaceInstance createActorInterfaceInstance(ActorRef aref) {
        String name = aref.getName();
        if (this.debug) {
            this.logger.logInfo("GeneratorModelBuilder: creating actor interface instance " + name + " from " + aref.getType().getName());
        }
        ActorInterfaceInstance ai = ETriceGenFactory.eINSTANCE.createActorInterfaceInstance();
        this.allObjects.add(ai);
        ai.setName(name);
        ActorClass ac = aref.getType();
        ai.setActorClass(ac);
        ai.setArray(aref.getMultiplicity() < 0);
        for (ActorClass acl : this.roomHelpers.getClassHierarchy(ac)) {
            this.createPortInstances(ai, acl);
        }
        for (PortInstance pi : ai.getPorts()) {
            pi.setKind(PortKind.INTERFACE);
        }
        return ai;
    }

    private void addRefInstances(StructureInstance si, ActorRef ar) {
        if (ar.getRefType() == ReferenceType.OPTIONAL) {
            si.getInstances().add((Object)this.createActorInterfaceInstance(ar));
        } else if (ar.getMultiplicity() > 1) {
            int idx = 0;
            while (idx < ar.getMultiplicity()) {
                si.getInstances().add((Object)this.recursivelyCreateActorInstances(ar, idx));
                ++idx;
            }
        } else {
            si.getInstances().add((Object)this.recursivelyCreateActorInstances(ar));
        }
    }

    private void createPortInstances(AbstractInstance ai, ActorClass ac) {
        this.createPortInstances((EList<Port>)ac.getExternalEndPorts(), PortKind.EXTERNAL, ai);
        if (ai instanceof ActorInstance || ai instanceof OptionalActorInstance) {
            this.createPortInstances((EList<Port>)ac.getInternalPorts(), PortKind.INTERNAL, ai);
        }
        this.createPortInstances((EList<Port>)ac.getRelayPorts(), PortKind.RELAY, ai);
    }

    private void createPortInstances(EList<Port> ports, PortKind kind, AbstractInstance ai) {
        for (Port port : ports) {
            PortInstance pi = ETriceGenFactory.eINSTANCE.createPortInstance();
            this.allObjects.add(pi);
            pi.setName(port.getName());
            pi.setPort(port);
            pi.setKind(kind);
            ai.getPorts().add((Object)pi);
        }
    }

    private void createServiceRelatedInstances(StructureInstance ai, ActorClass ac) {
        InstanceBase si;
        for (SAP sap : ac.getServiceAccessPoints()) {
            si = ETriceGenFactory.eINSTANCE.createSAPInstance();
            this.allObjects.add(si);
            si.setName(sap.getName());
            si.setSap(sap);
            ai.getSaps().add((Object)si);
        }
        for (SAP sap : ac.getServiceProvisionPoints()) {
            si = ETriceGenFactory.eINSTANCE.createSPPInstance();
            this.allObjects.add(si);
            si.setName(sap.getName());
            si.setSpp((SPP)sap);
            ai.getSpps().add((Object)si);
        }
        for (ServiceImplementation svcimpl : ac.getServiceImplementations()) {
            ServiceImplInstance sii = ETriceGenFactory.eINSTANCE.createServiceImplInstance();
            this.allObjects.add(sii);
            sii.setName(svcimpl.getSpp().getName());
            sii.setSvcImpl(svcimpl);
            ai.getServices().add((Object)sii);
        }
    }

    private void createConnectionInstances(StructureInstance si, List<LayerConnection> connections) {
        for (LayerConnection lc : connections) {
            SPPoint to = lc.getTo();
            SPPInstance toSPPinst = this.getSPPInstance(si, to.getRef(), to.getService());
            SAPoint from = lc.getFrom();
            if (from instanceof RefSAPoint) {
                if (((RefSAPoint)from).getRef() instanceof ActorRef) {
                    List<AbstractInstance> fromInstances = this.getSubInstances(si, (ActorRef)((RefSAPoint)from).getRef());
                    for (AbstractInstance fromInst : fromInstances) {
                        ConnectionInstance ci = ETriceGenFactory.eINSTANCE.createConnectionInstance();
                        ci.setConnection(lc);
                        ci.setFromAI(fromInst);
                        ci.setToSPP(toSPPinst);
                        si.getConnections().add((Object)ci);
                    }
                    continue;
                }
                System.err.println("error");
                continue;
            }
            if (from instanceof RelaySAPoint) {
                SPPInstance fromSPPinst = this.getSPPInstance(si, null, ((RelaySAPoint)from).getRelay());
                if (fromSPPinst.getOutgoing() != null) {
                    ActorContainerClass acr = (ActorContainerClass)fromSPPinst.getSpp().eContainer();
                    int idx = acr.getServiceProvisionPoints().indexOf((Object)fromSPPinst.getSpp());
                    this.diagnostician.error("SPP has several outgoing layer connections!", (EObject)fromSPPinst.getSpp(), (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ServiceProvisionPoints(), idx);
                }
                ConnectionInstance ci = ETriceGenFactory.eINSTANCE.createConnectionInstance();
                ci.setConnection(lc);
                ci.setFromSPP(fromSPPinst);
                ci.setToSPP(toSPPinst);
                si.getConnections().add((Object)ci);
                continue;
            }
            assert (false) : "unknown type of " + from.eClass().getName();
        }
    }

    private SPPInstance getSPPInstance(AbstractInstance si, ActorContainerRef ar, SPP spp) {
        if (ar == null && si instanceof StructureInstance) {
            for (SPPInstance sppi : ((StructureInstance)si).getSpps()) {
                if (sppi.getSpp() != spp) continue;
                return sppi;
            }
        } else if (ar instanceof ActorRef) {
            List<AbstractInstance> subais = this.getSubInstances(si, (ActorRef)ar);
            if (!subais.isEmpty()) {
                return this.getSPPInstance(subais.get(0), null, spp);
            }
        } else {
            boolean cfr_ignored_0 = ar instanceof SubSystemRef;
        }
        return null;
    }

    private List<AbstractInstance> getSubInstances(AbstractInstance si, ActorRef ar) {
        ArrayList<AbstractInstance> result = new ArrayList<AbstractInstance>();
        if (si instanceof StructureInstance) {
            for (AbstractInstance subai : ((StructureInstance)si).getInstances()) {
                if (subai instanceof ActorInstance) {
                    if (!((ActorInstance)subai).getUnindexedName().equals(ar.getName())) continue;
                    result.add(subai);
                    continue;
                }
                if (!subai.getName().equals(ar.getName())) continue;
                result.add(subai);
            }
        }
        return result;
    }

    private void connectPorts(Root root) {
        EObject obj;
        assert (this.dependenciesSatisfied(WorkItem.CREATE_BINDINGS)) : "dependencies satisfied";
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            obj = (EObject)it.next();
            if (!(obj instanceof AbstractInstance)) continue;
            for (PortInstance pi : ((AbstractInstance)obj).getPorts()) {
                if (pi.getKind() == PortKind.RELAY) continue;
                List<PortInstance> peers = this.getFinalPeers(pi, null);
                pi.getPeers().addAll(peers);
            }
        }
        it = root.eAllContents();
        while (it.hasNext()) {
            obj = (EObject)it.next();
            if (!(obj instanceof AbstractInstance)) continue;
            for (PortInstance pi : ((AbstractInstance)obj).getPorts()) {
                BindingInstance bi;
                if (pi.getKind() == PortKind.RELAY || pi.getPeers().size() <= 1 || ((InterfaceItemInstance)pi.getPeers().get(0)).getPeers().size() <= 1 || ((PortInstance)(bi = (BindingInstance)pi.getBindings().get(0)).getPorts().get(0)).getKind() != PortKind.RELAY && ((PortInstance)bi.getPorts().get(1)).getKind() != PortKind.RELAY) continue;
                this.connectPeersOneToOne(pi);
            }
        }
        this.alreadyDone.add(WorkItem.CONNECT_PORTS);
    }

    private List<PortInstance> getFinalPeers(PortInstance pi, BindingInstance from) {
        LinkedList<PortInstance> peers = new LinkedList<PortInstance>();
        for (BindingInstance bi : pi.getBindings()) {
            PortInstance end;
            if (bi == from || from != null && from.eContainer() == bi.eContainer()) continue;
            PortInstance portInstance = end = bi.getPorts().get(0) != pi ? (PortInstance)bi.getPorts().get(0) : (PortInstance)bi.getPorts().get(1);
            if (end.getKind() == PortKind.RELAY) {
                peers.addAll(this.getFinalPeers(end, bi));
                continue;
            }
            peers.add(end);
        }
        return peers;
    }

    private void connectPeersOneToOne(PortInstance pi) {
        HashSet<InterfaceItemInstance> thatSide;
        HashSet<InterfaceItemInstance> thisSide = new HashSet<InterfaceItemInstance>((Collection<InterfaceItemInstance>)pi.getPeers());
        if (!Collections.disjoint(thisSide, thatSide = new HashSet<InterfaceItemInstance>((Collection<InterfaceItemInstance>)((InterfaceItemInstance)pi.getPeers().get(0)).getPeers()))) {
            assert (false) : "sets expected to be disjoint";
            return;
        }
        for (InterfaceItemInstance pi1 : thisSide) {
            if (!this.isSameCollection((Collection<InterfaceItemInstance>)thatSide, (Collection<InterfaceItemInstance>)pi1.getPeers())) assert (false) : "expected reciprocal peer lists";
        }
        for (InterfaceItemInstance pi2 : thatSide) {
            if (!this.isSameCollection((Collection<InterfaceItemInstance>)thisSide, (Collection<InterfaceItemInstance>)pi2.getPeers())) assert (false) : "expected reciprocal peer lists";
        }
        boolean thisGreaterThat = this.totalSize(thisSide) > this.totalSize(thatSide);
        Iterator<InterfaceItemInstance> lit = thisGreaterThat ? thisSide.iterator() : thatSide.iterator();
        Iterator<InterfaceItemInstance> sit = thisGreaterThat ? thatSide.iterator() : thisSide.iterator();
        while (sit.hasNext() && lit.hasNext()) {
            InterfaceItemInstance first = lit.next();
            InterfaceItemInstance second = sit.next();
            first.getPeers().clear();
            first.getPeers().add((Object)second);
            second.getPeers().clear();
            second.getPeers().add((Object)first);
        }
        while (lit.hasNext()) {
            InterfaceItemInstance item = lit.next();
            this.reportPortInstanceError(item, "port '" + item.getPath() + "'could not be connected");
        }
    }

    private void reportPortInstanceError(InterfaceItemInstance item, String msg) {
        if (item.eContainer() instanceof ActorInstance) {
            ActorClass ac = ((ActorInstance)item.eContainer()).getActorClass();
            Port port = ((PortInstance)item).getPort();
            EReference feat = ac.getInterfacePorts().contains((Object)port) ? RoomPackage.Literals.ACTOR_CLASS__INTERNAL_PORTS : RoomPackage.Literals.ACTOR_CLASS__INTERFACE_PORTS;
            int idx = ac.getInterfacePorts().indexOf((Object)port);
            if (idx < 0) {
                ac.getInternalPorts().indexOf((Object)port);
            }
            this.diagnostician.warning(msg, (EObject)ac, (EStructuralFeature)feat, idx);
        } else assert (false) : "SubSystems can only have relay ports";
    }

    private int totalSize(Collection<InterfaceItemInstance> coll) {
        int size = 0;
        for (InterfaceItemInstance ii : coll) {
            if (ii instanceof PortInstance) {
                int multiplicity = ((PortInstance)ii).getPort().getMultiplicity();
                if (multiplicity != 1) {
                    this.reportPortInstanceError(ii, "port '" + ii.getPath() + "' must have multiplicity 1");
                }
                size += multiplicity;
                continue;
            }
            assert (false) : "should be called with PortInstances onl";
        }
        return size;
    }

    private boolean isSameCollection(Collection<InterfaceItemInstance> coll1, Collection<InterfaceItemInstance> coll2) {
        for (InterfaceItemInstance ii : coll1) {
            if (coll2.contains(ii)) continue;
            return false;
        }
        for (InterfaceItemInstance ii : coll2) {
            if (coll1.contains(ii)) continue;
            return false;
        }
        return true;
    }

    private void checkPortMultiplicity(Root root) {
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof ActorInstance) {
                ActorInstance ai = (ActorInstance)obj;
                ActorClass ac = ai.getActorClass();
                for (PortInstance pi : ai.getPorts()) {
                    if (pi.getKind() == PortKind.RELAY || pi.getProtocol().getCommType() != CommunicationType.EVENT_DRIVEN || pi.getBindings().size() <= pi.getPort().getMultiplicity() || pi.getPort().getMultiplicity() == -1) continue;
                    EReference feature = RoomPackage.eINSTANCE.getActorClass_InterfacePorts();
                    int idx = ac.getInterfacePorts().indexOf((Object)pi.getPort());
                    if (idx < 0) {
                        feature = RoomPackage.eINSTANCE.getActorClass_InternalPorts();
                        idx = ac.getInternalPorts().indexOf((Object)pi.getPort());
                    }
                    this.diagnostician.error("number of peers (" + pi.getBindings().size() + ") of port '" + pi.getName() + "' exceeds multiplicity " + pi.getPort().getMultiplicity() + " in instance " + ai.getPath(), (EObject)ac, (EStructuralFeature)feature, idx);
                }
                continue;
            }
            boolean cfr_ignored_0 = obj instanceof SubSystemInstance;
        }
    }

    private void createExpandedActorClasses(Root root) {
        HashMap<ActorClass, ExpandedActorClass> map = new HashMap<ActorClass, ExpandedActorClass>();
        for (ActorClass ac2 : root.getActorClasses()) {
            ExpandedActorClass xpac2 = this.createExpandedActorClass(ac2);
            root.getXpActorClasses().add((Object)xpac2);
            map.put(ac2, xpac2);
        }
        for (RoomModel model : root.getImportedModels()) {
            this.roomHelpers.getRoomClasses(model, ActorClass.class).forEach(ac -> {
                ExpandedActorClass xpac = this.createExpandedActorClass((ActorClass)ac);
                root.getXpActorClasses().add((Object)xpac);
                map.put((ActorClass)ac, xpac);
            });
        }
        map.values().forEach(xpac -> {
            boolean isTracing = this.roomHelpers.hasTracingAnnotation(xpac.getActorClass()) && this.roomHelpers.getAllInterfaceItems(xpac.getActorClass()).stream().anyMatch(ifItem -> ifItem.isEventDriven());
            xpac.setTracingEnabled(isTracing);
        });
        this.allObjects.forEach(inst -> {
            if (inst instanceof ActorInstance) {
                ActorInstance ai = (ActorInstance)inst;
                ai.setXpActorClass((ExpandedActorClass)Verify.verifyNotNull((Object)((ExpandedActorClass)map.get(ai.getActorClass()))));
            }
        });
    }

    public ExpandedActorClass createExpandedActorClass(ActorClass ac) {
        if (this.debug) {
            this.logger.logInfo("GeneratorModelBuilder: creating expanded actor class from " + ac.getName() + " of " + ((RoomModel)ac.eContainer()).getName());
        }
        ExpandedActorClass xpac = ETriceGenFactory.eINSTANCE.createExpandedActorClass();
        ExtendedFsmGenBuilder fsmGenBuilder = this.fsmGenBuilderFactory.create(this.diagnostician);
        GraphContainer gc = fsmGenBuilder.createTransformedModel((ModelComponent)ac);
        fsmGenBuilder.withChainHeads(gc);
        fsmGenBuilder.withCommonData(gc);
        fsmGenBuilder.withTriggersInStates(gc);
        xpac.setGraphContainer(gc);
        return xpac;
    }

    private void createExpandedProtocolClasses(Root root) {
        HashMap map = new HashMap();
        root.getProtocolClasses().forEach(pc -> {
            ExpandedProtocolClass xppc = this.createExpandedProtocolClasses((ProtocolClass)pc);
            root.getXpProtocolClasses().add((Object)xppc);
            map.put(pc, xppc);
        });
        this.allObjects.forEach(inst -> {
            if (inst instanceof InterfaceItemInstance) {
                InterfaceItemInstance ifItem = (InterfaceItemInstance)inst;
                ProtocolClass pc = ifItem.getProtocol();
                if (!map.containsKey(pc)) {
                    ExpandedProtocolClass xppc = this.createExpandedProtocolClasses(pc);
                    root.getXpProtocolClasses().add((Object)xppc);
                    map.put(pc, xppc);
                }
                ifItem.setXpProtocolClass((ExpandedProtocolClass)Verify.verifyNotNull((Object)((ExpandedProtocolClass)map.get(pc))));
            }
        });
    }

    public ExpandedProtocolClass createExpandedProtocolClasses(ProtocolClass pc) {
        ExpandedProtocolClass xppc = ETriceGenFactory.eINSTANCE.createExpandedProtocolClass();
        xppc.setProtocolClass(pc);
        Stream.concat(this.roomHelpers.getAllOutgoingMessages(pc).stream(), this.roomHelpers.getAllIncomingMessages(pc).stream()).forEach(msg -> xppc.getOrderedMessageNames().add((Object)msg.getName()));
        return xppc;
    }

    private static enum WorkItem {
        CREATE_INSTANCES,
        CREATE_PORTS,
        CREATE_BINDINGS,
        CONNECT_PORTS,
        CONNECT_SERVICES,
        CREATE_OPTIONAL_INSTANCES;

    }
}

