/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.emf.prettyprint;

import java.util.List;
import org.eclipse.escet.common.emf.prettyprint.PrettyEFeat;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class IdProvider {
    private int id = -1;
    private List<RegisteredIdCallback> prettyFeatureCallbacks = Lists.list();

    public void setIdNumber(int id) {
        Assert.check((this.id < 0 ? 1 : 0) != 0);
        Assert.check((id >= 0 ? 1 : 0) != 0);
        this.id = id;
        for (RegisteredIdCallback prettyCb : this.prettyFeatureCallbacks) {
            prettyCb.prettyFeat.resolveId(id, prettyCb.index);
        }
        this.prettyFeatureCallbacks = null;
    }

    public void registerPrettyFeature(PrettyEFeat prettyFeat, int index) {
        if (this.id >= 0) {
            prettyFeat.resolveId(this.id, index);
        } else {
            this.prettyFeatureCallbacks.add(new RegisteredIdCallback(prettyFeat, index));
        }
    }

    private record RegisteredIdCallback(PrettyEFeat prettyFeat, int index) {
    }
}

