/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.sequencing.elements;

import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.common.dsm.sequencing.graph.Vertex;
import org.eclipse.escet.common.java.Strings;

public abstract class Element {
    public final BitSet inputs;
    public final BitSet outputs;

    protected Element(BitSet inputs, BitSet outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public boolean hasInputDeps(BitSet elementSet) {
        return this.inputs.intersects(elementSet);
    }

    public boolean hasOutputDeps(BitSet elementSet) {
        return this.outputs.intersects(elementSet);
    }

    public abstract void setVertexIndices(BitSet var1);

    public abstract void clearVertexIndices(BitSet var1);

    public abstract int getVertexCount();

    public abstract void appendVertices(List<Vertex> var1);

    protected abstract String getSelfNumbers();

    public String toString() {
        String inputText = this.inputs.stream().mapToObj(String::valueOf).collect(Collectors.joining(","));
        String outputText = this.outputs.stream().mapToObj(String::valueOf).collect(Collectors.joining(","));
        return Strings.fmt((String)"<<Element %s: [%s] -> [%s]>>", (Object[])new Object[]{this.getSelfNumbers(), inputText, outputText});
    }
}

