/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.common;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeParam;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolParamExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.VariableExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ObjectType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeParamRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.UnresolvedType;

public class ToolDefTypeUtils {
    private ToolDefTypeUtils() {
    }

    public static boolean mayBeNullable(ToolDefType type) {
        if ((type = ToolDefTypeUtils.normalizeType(type)).isNullable()) {
            return true;
        }
        return type instanceof TypeParamRef;
    }

    public static boolean areEqualTypes(ToolDefType t1, ToolDefType t2) {
        Assert.check((!(t1 instanceof UnresolvedType) ? 1 : 0) != 0);
        Assert.check((!(t2 instanceof UnresolvedType) ? 1 : 0) != 0);
        t1 = ToolDefTypeUtils.normalizeType(t1);
        t2 = ToolDefTypeUtils.normalizeType(t2);
        if (t1.isNullable() != t2.isNullable()) {
            return false;
        }
        if (t1 instanceof BoolType && t2 instanceof BoolType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof IntType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof StringType && t2 instanceof StringType) {
            return true;
        }
        if (t1 instanceof ObjectType && t2 instanceof ObjectType) {
            return true;
        }
        if (t1 instanceof ListType && t2 instanceof ListType) {
            ListType lt1 = (ListType)t1;
            ListType lt2 = (ListType)t2;
            return ToolDefTypeUtils.areEqualTypes(lt1.getElemType(), lt2.getElemType());
        }
        if (t1 instanceof SetType && t2 instanceof SetType) {
            SetType st1 = (SetType)t1;
            SetType st2 = (SetType)t2;
            return ToolDefTypeUtils.areEqualTypes(st1.getElemType(), st2.getElemType());
        }
        if (t1 instanceof MapType && t2 instanceof MapType) {
            MapType mt1 = (MapType)t1;
            MapType mt2 = (MapType)t2;
            return ToolDefTypeUtils.areEqualTypes(mt1.getKeyType(), mt2.getKeyType()) && ToolDefTypeUtils.areEqualTypes(mt1.getValueType(), mt2.getValueType());
        }
        if (t1 instanceof TupleType && t2 instanceof TupleType) {
            EList fields1 = ((TupleType)t1).getFields();
            EList fields2 = ((TupleType)t2).getFields();
            if (fields1.size() != fields2.size()) {
                return false;
            }
            int i = 0;
            while (i < fields1.size()) {
                if (!ToolDefTypeUtils.areEqualTypes((ToolDefType)fields1.get(i), (ToolDefType)fields2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (t1 instanceof TypeParamRef && t2 instanceof TypeParamRef) {
            return ((TypeParamRef)t1).getType() == ((TypeParamRef)t2).getType();
        }
        return false;
    }

    public static boolean areDistinguishableTypes(ToolDefType t1, ToolDefType t2) {
        Assert.check((!(t1 instanceof UnresolvedType) ? 1 : 0) != 0);
        Assert.check((!(t2 instanceof UnresolvedType) ? 1 : 0) != 0);
        t1 = ToolDefTypeUtils.normalizeType(t1);
        t2 = ToolDefTypeUtils.normalizeType(t2);
        if (t1 instanceof TypeParamRef) {
            return false;
        }
        if (t2 instanceof TypeParamRef) {
            return false;
        }
        if (t1.isNullable() != t2.isNullable()) {
            return true;
        }
        if (t1 instanceof BoolType && t2 instanceof BoolType) {
            return false;
        }
        if (t1 instanceof IntType && t2 instanceof IntType) {
            return false;
        }
        if (t1 instanceof LongType && t2 instanceof LongType) {
            return false;
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return false;
        }
        if (t1 instanceof StringType && t2 instanceof StringType) {
            return false;
        }
        if (t1 instanceof ObjectType && t2 instanceof ObjectType) {
            return false;
        }
        if (t1 instanceof ListType && t2 instanceof ListType) {
            ListType lt1 = (ListType)t1;
            ListType lt2 = (ListType)t2;
            return ToolDefTypeUtils.areDistinguishableTypes(lt1.getElemType(), lt2.getElemType());
        }
        if (t1 instanceof SetType && t2 instanceof SetType) {
            SetType st1 = (SetType)t1;
            SetType st2 = (SetType)t2;
            return ToolDefTypeUtils.areDistinguishableTypes(st1.getElemType(), st2.getElemType());
        }
        if (t1 instanceof MapType && t2 instanceof MapType) {
            MapType mt1 = (MapType)t1;
            MapType mt2 = (MapType)t2;
            return ToolDefTypeUtils.areDistinguishableTypes(mt1.getKeyType(), mt2.getKeyType()) || ToolDefTypeUtils.areDistinguishableTypes(mt1.getValueType(), mt2.getValueType());
        }
        if (t1 instanceof TupleType && t2 instanceof TupleType) {
            EList fields1 = ((TupleType)t1).getFields();
            EList fields2 = ((TupleType)t2).getFields();
            if (fields1.size() != fields2.size()) {
                return true;
            }
            int i = 0;
            while (i < fields1.size()) {
                if (ToolDefTypeUtils.areDistinguishableTypes((ToolDefType)fields1.get(i), (ToolDefType)fields2.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public static boolean isSubType(ToolDefType t1, ToolDefType t2) {
        Assert.check((!(t1 instanceof UnresolvedType) ? 1 : 0) != 0);
        Assert.check((!(t2 instanceof UnresolvedType) ? 1 : 0) != 0);
        t1 = ToolDefTypeUtils.normalizeType(t1);
        t2 = ToolDefTypeUtils.normalizeType(t2);
        if (t1 instanceof TypeParamRef && t2 instanceof TypeParamRef) {
            TypeParam param2;
            TypeParam param1 = ((TypeParamRef)t1).getType();
            return param1 == (param2 = ((TypeParamRef)t2).getType());
        }
        if (t1 instanceof TypeParamRef) {
            return t2 instanceof ObjectType && t2.isNullable();
        }
        if (t2 instanceof TypeParamRef) {
            return false;
        }
        if (t1.isNullable() && !t2.isNullable()) {
            return false;
        }
        if (t2 instanceof ObjectType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof IntType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof BoolType && t2 instanceof BoolType) {
            return true;
        }
        if (t1 instanceof StringType && t2 instanceof StringType) {
            return true;
        }
        if (t1 instanceof ListType && t2 instanceof ListType) {
            ListType lt1 = (ListType)t1;
            ListType lt2 = (ListType)t2;
            return ToolDefTypeUtils.isSubType(lt1.getElemType(), lt2.getElemType());
        }
        if (t1 instanceof SetType && t2 instanceof SetType) {
            SetType st1 = (SetType)t1;
            SetType st2 = (SetType)t2;
            return ToolDefTypeUtils.isSubType(st1.getElemType(), st2.getElemType());
        }
        if (t1 instanceof MapType && t2 instanceof MapType) {
            MapType mt1 = (MapType)t1;
            MapType mt2 = (MapType)t2;
            return ToolDefTypeUtils.isSubType(mt1.getKeyType(), mt2.getKeyType()) && ToolDefTypeUtils.isSubType(mt1.getValueType(), mt2.getValueType());
        }
        if (t1 instanceof TupleType && t2 instanceof TupleType) {
            EList fields1 = ((TupleType)t1).getFields();
            EList fields2 = ((TupleType)t2).getFields();
            if (fields1.size() != fields2.size()) {
                return false;
            }
            int i = 0;
            while (i < fields1.size()) {
                if (!ToolDefTypeUtils.isSubType((ToolDefType)fields1.get(i), (ToolDefType)fields2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isSuperType(ToolDefType t1, ToolDefType t2) {
        Assert.check((!(t1 instanceof UnresolvedType) ? 1 : 0) != 0);
        Assert.check((!(t2 instanceof UnresolvedType) ? 1 : 0) != 0);
        t1 = ToolDefTypeUtils.normalizeType(t1);
        t2 = ToolDefTypeUtils.normalizeType(t2);
        if (t1 instanceof TypeParamRef && t2 instanceof TypeParamRef) {
            TypeParam param2;
            TypeParam param1 = ((TypeParamRef)t1).getType();
            return param1 == (param2 = ((TypeParamRef)t2).getType());
        }
        if (t2 instanceof TypeParamRef) {
            return t1 instanceof ObjectType && t1.isNullable();
        }
        if (t1 instanceof TypeParamRef) {
            return false;
        }
        if (!t1.isNullable() && t2.isNullable()) {
            return false;
        }
        if (t1 instanceof ObjectType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof IntType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof IntType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof IntType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof BoolType && t2 instanceof BoolType) {
            return true;
        }
        if (t1 instanceof StringType && t2 instanceof StringType) {
            return true;
        }
        if (t1 instanceof ListType && t2 instanceof ListType) {
            ListType lt1 = (ListType)t1;
            ListType lt2 = (ListType)t2;
            return ToolDefTypeUtils.isSuperType(lt1.getElemType(), lt2.getElemType());
        }
        if (t1 instanceof SetType && t2 instanceof SetType) {
            SetType st1 = (SetType)t1;
            SetType st2 = (SetType)t2;
            return ToolDefTypeUtils.isSuperType(st1.getElemType(), st2.getElemType());
        }
        if (t1 instanceof MapType && t2 instanceof MapType) {
            MapType mt1 = (MapType)t1;
            MapType mt2 = (MapType)t2;
            return ToolDefTypeUtils.isSuperType(mt1.getKeyType(), mt2.getKeyType()) && ToolDefTypeUtils.isSuperType(mt1.getValueType(), mt2.getValueType());
        }
        if (t1 instanceof TupleType && t2 instanceof TupleType) {
            EList fields1 = ((TupleType)t1).getFields();
            EList fields2 = ((TupleType)t2).getFields();
            if (fields1.size() != fields2.size()) {
                return false;
            }
            int i = 0;
            while (i < fields1.size()) {
                if (!ToolDefTypeUtils.isSuperType((ToolDefType)fields1.get(i), (ToolDefType)fields2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static ToolDefType normalizeType(ToolDefType type) {
        while (type instanceof TypeRef) {
            type = ((TypeRef)type).getType().getType();
        }
        return type;
    }

    public static int hashType(ToolDefType type) {
        int rslt;
        int n = rslt = (type = ToolDefTypeUtils.normalizeType(type)).isNullable() ? 1 : 0;
        if (type instanceof BoolType) {
            return rslt ^ 8;
        }
        if (type instanceof IntType) {
            return rslt ^ 0x40;
        }
        if (type instanceof LongType) {
            return rslt ^ 0x200;
        }
        if (type instanceof DoubleType) {
            return rslt ^ 0x1000;
        }
        if (type instanceof StringType) {
            return rslt ^ 0x2000;
        }
        if (type instanceof ObjectType) {
            return rslt ^ 0x8000;
        }
        if (type instanceof ListType) {
            return (rslt ^= 0x40000) + ToolDefTypeUtils.hashType(((ListType)type).getElemType());
        }
        if (type instanceof SetType) {
            return (rslt ^= 0x200000) + ToolDefTypeUtils.hashType(((SetType)type).getElemType());
        }
        if (type instanceof MapType) {
            return (rslt ^= 0x1000000) + ToolDefTypeUtils.hashType(((MapType)type).getKeyType()) * 7 + ToolDefTypeUtils.hashType(((MapType)type).getValueType()) * 11;
        }
        if (type instanceof TupleType) {
            rslt ^= 0x8000000;
            for (ToolDefType fieldType : ((TupleType)type).getFields()) {
                rslt += ToolDefTypeUtils.hashType(fieldType) * 7;
            }
            return rslt;
        }
        if (type instanceof TypeParamRef) {
            return (rslt ^= 0x40000000) + ((TypeParamRef)type).getType().getName().hashCode();
        }
        throw new RuntimeException("Unknown/unsupported type: " + String.valueOf(type));
    }

    public static int compareTypes(ToolDefType t1, ToolDefType t2) {
        int o2;
        t1 = ToolDefTypeUtils.normalizeType(t1);
        t2 = ToolDefTypeUtils.normalizeType(t2);
        if (ToolDefTypeUtils.mayBeNullable(t1) && !ToolDefTypeUtils.mayBeNullable(t2)) {
            return 1;
        }
        if (!ToolDefTypeUtils.mayBeNullable(t1) && ToolDefTypeUtils.mayBeNullable(t2)) {
            return -1;
        }
        int o1 = ToolDefTypeUtils.getBasicSortOrder(t1);
        if (o1 < (o2 = ToolDefTypeUtils.getBasicSortOrder(t2))) {
            return -1;
        }
        if (o1 > o2) {
            return 1;
        }
        if (t1 instanceof BoolType) {
            return 0;
        }
        if (t1 instanceof IntType) {
            return 0;
        }
        if (t1 instanceof LongType) {
            return 0;
        }
        if (t1 instanceof DoubleType) {
            return 0;
        }
        if (t1 instanceof StringType) {
            return 0;
        }
        if (t1 instanceof ObjectType) {
            return 0;
        }
        if (t1 instanceof ListType) {
            ListType lt1 = (ListType)t1;
            ListType lt2 = (ListType)t2;
            return ToolDefTypeUtils.compareTypes(lt1.getElemType(), lt2.getElemType());
        }
        if (t1 instanceof SetType) {
            SetType st1 = (SetType)t1;
            SetType st2 = (SetType)t2;
            return ToolDefTypeUtils.compareTypes(st1.getElemType(), st2.getElemType());
        }
        if (t1 instanceof MapType) {
            MapType mt1 = (MapType)t1;
            MapType mt2 = (MapType)t2;
            int krslt = ToolDefTypeUtils.compareTypes(mt1.getKeyType(), mt2.getKeyType());
            if (krslt != 0) {
                return krslt;
            }
            return ToolDefTypeUtils.compareTypes(mt1.getValueType(), mt2.getValueType());
        }
        if (t1 instanceof TupleType) {
            EList fields1 = ((TupleType)t1).getFields();
            EList fields2 = ((TupleType)t2).getFields();
            if (fields1.size() < fields2.size()) {
                return -1;
            }
            if (fields1.size() > fields2.size()) {
                return 1;
            }
            int i = 0;
            while (i < fields1.size()) {
                int frslt = ToolDefTypeUtils.compareTypes((ToolDefType)fields1.get(i), (ToolDefType)fields2.get(i));
                if (frslt != 0) {
                    return frslt;
                }
                ++i;
            }
            return 0;
        }
        if (t1 instanceof TypeParamRef) {
            TypeParam param1 = ((TypeParamRef)t1).getType();
            TypeParam param2 = ((TypeParamRef)t2).getType();
            return Strings.SORTER.compare(param1.getName(), param2.getName());
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(t1));
    }

    private static int getBasicSortOrder(ToolDefType type) {
        if (type instanceof BoolType) {
            return 1;
        }
        if (type instanceof IntType) {
            return 2;
        }
        if (type instanceof LongType) {
            return 3;
        }
        if (type instanceof DoubleType) {
            return 4;
        }
        if (type instanceof StringType) {
            return 5;
        }
        if (type instanceof TupleType) {
            return 6;
        }
        if (type instanceof ListType) {
            return 7;
        }
        if (type instanceof SetType) {
            return 8;
        }
        if (type instanceof MapType) {
            return 9;
        }
        if (type instanceof TypeParamRef) {
            return 10;
        }
        if (type instanceof ObjectType) {
            return 11;
        }
        throw new RuntimeException("Unsupported type: " + String.valueOf(type));
    }

    public static ToolDefType mergeTypes(ToolDefType t1, ToolDefType t2) {
        TypeParam param2;
        TypeParam param1;
        boolean nullable;
        t1 = ToolDefTypeUtils.normalizeType(t1);
        t2 = ToolDefTypeUtils.normalizeType(t2);
        boolean bl = nullable = ToolDefTypeUtils.mayBeNullable(t1) || ToolDefTypeUtils.mayBeNullable(t2);
        if (t1 instanceof BoolType && t2 instanceof BoolType) {
            return ToolDefConstructors.newBoolType((Boolean)nullable, null);
        }
        if (t1 instanceof IntType && t2 instanceof IntType) {
            return ToolDefConstructors.newIntType((Boolean)nullable, null);
        }
        if (t1 instanceof IntType && t2 instanceof LongType) {
            return ToolDefConstructors.newLongType((Boolean)nullable, null);
        }
        if (t1 instanceof IntType && t2 instanceof DoubleType) {
            return ToolDefConstructors.newDoubleType((Boolean)nullable, null);
        }
        if (t1 instanceof LongType && t2 instanceof IntType) {
            return ToolDefConstructors.newLongType((Boolean)nullable, null);
        }
        if (t1 instanceof LongType && t2 instanceof LongType) {
            return ToolDefConstructors.newLongType((Boolean)nullable, null);
        }
        if (t1 instanceof LongType && t2 instanceof DoubleType) {
            return ToolDefConstructors.newDoubleType((Boolean)nullable, null);
        }
        if (t1 instanceof DoubleType && t2 instanceof IntType) {
            return ToolDefConstructors.newDoubleType((Boolean)nullable, null);
        }
        if (t1 instanceof DoubleType && t2 instanceof LongType) {
            return ToolDefConstructors.newDoubleType((Boolean)nullable, null);
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return ToolDefConstructors.newDoubleType((Boolean)nullable, null);
        }
        if (t1 instanceof StringType && t2 instanceof StringType) {
            return ToolDefConstructors.newStringType((Boolean)nullable, null);
        }
        if (t1 instanceof ListType && t2 instanceof ListType) {
            ListType lt1 = (ListType)t1;
            ListType lt2 = (ListType)t2;
            ToolDefType elemType = ToolDefTypeUtils.mergeTypes(lt1.getElemType(), lt2.getElemType());
            return ToolDefConstructors.newListType((ToolDefType)elemType, (Boolean)nullable, null);
        }
        if (t1 instanceof SetType && t2 instanceof SetType) {
            SetType st1 = (SetType)t1;
            SetType st2 = (SetType)t2;
            ToolDefType elemType = ToolDefTypeUtils.mergeTypes(st1.getElemType(), st2.getElemType());
            return ToolDefConstructors.newSetType((ToolDefType)elemType, (Boolean)nullable, null);
        }
        if (t1 instanceof MapType && t2 instanceof MapType) {
            MapType mt1 = (MapType)t1;
            MapType mt2 = (MapType)t2;
            ToolDefType keyType = ToolDefTypeUtils.mergeTypes(mt1.getKeyType(), mt2.getKeyType());
            ToolDefType valueType = ToolDefTypeUtils.mergeTypes(mt1.getValueType(), mt2.getValueType());
            return ToolDefConstructors.newMapType((ToolDefType)keyType, (Boolean)nullable, null, (ToolDefType)valueType);
        }
        if (t1 instanceof TupleType && t2 instanceof TupleType) {
            int cnt2;
            TupleType tt1 = (TupleType)t1;
            TupleType tt2 = (TupleType)t2;
            int cnt1 = tt1.getFields().size();
            if (cnt1 == (cnt2 = tt2.getFields().size())) {
                TupleType rslt = ToolDefConstructors.newTupleType(null, (Boolean)nullable, null);
                int i = 0;
                while (i < cnt1) {
                    ToolDefType fieldType1 = (ToolDefType)tt1.getFields().get(i);
                    ToolDefType fieldType2 = (ToolDefType)tt2.getFields().get(i);
                    rslt.getFields().add((Object)ToolDefTypeUtils.mergeTypes(fieldType1, fieldType2));
                    ++i;
                }
                return rslt;
            }
        }
        if (t1 instanceof TypeParamRef && t2 instanceof TypeParamRef && (param1 = ((TypeParamRef)t1).getType()) == (param2 = ((TypeParamRef)t2).getType())) {
            return ToolDefConstructors.newTypeParamRef((Boolean)false, null, (TypeParam)param1);
        }
        Assert.check((!(t1 instanceof UnresolvedType) ? 1 : 0) != 0);
        Assert.check((!(t2 instanceof UnresolvedType) ? 1 : 0) != 0);
        return ToolDefConstructors.newObjectType((Boolean)nullable, null);
    }

    public static boolean hasDefaultValue(ToolDefType type) {
        if ((type = ToolDefTypeUtils.normalizeType(type)) instanceof TypeParamRef) {
            return false;
        }
        if (type.isNullable()) {
            return true;
        }
        if (type instanceof BoolType) {
            return true;
        }
        if (type instanceof IntType) {
            return true;
        }
        if (type instanceof LongType) {
            return true;
        }
        if (type instanceof DoubleType) {
            return true;
        }
        if (type instanceof StringType) {
            return true;
        }
        if (type instanceof ObjectType) {
            return false;
        }
        if (type instanceof ListType) {
            return true;
        }
        if (type instanceof SetType) {
            return true;
        }
        if (type instanceof MapType) {
            return true;
        }
        if (type instanceof TupleType) {
            for (ToolDefType fieldType : ((TupleType)type).getFields()) {
                if (ToolDefTypeUtils.hasDefaultValue(fieldType)) continue;
                return false;
            }
            return true;
        }
        throw new RuntimeException("Unknown/unsupported type: " + String.valueOf(type));
    }

    public static ToolDefType makeTupleType(List<ToolDefType> fieldTypes) {
        Assert.check((!fieldTypes.isEmpty() ? 1 : 0) != 0);
        if (fieldTypes.size() == 1) {
            return (ToolDefType)Lists.first(fieldTypes);
        }
        return ToolDefConstructors.newTupleType(fieldTypes, (Boolean)false, null);
    }

    public static ToolDefType makeTupleTypeFromValues(List<Expression> values) {
        List types = Lists.listc((int)values.size());
        for (Expression value : values) {
            types.add((ToolDefType)EMFHelper.deepclone((EObject)value.getType()));
        }
        return ToolDefTypeUtils.makeTupleType(types);
    }

    public static PositionObject getRefObjFromRef(Expression refExpr) {
        if (refExpr instanceof VariableExpression) {
            return ((VariableExpression)refExpr).getVariable();
        }
        if (refExpr instanceof ToolParamExpression) {
            return ((ToolParamExpression)refExpr).getParam();
        }
        throw new RuntimeException("Unexpected ref expr: " + String.valueOf(refExpr));
    }
}

