/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.OptionValue;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class Options {
    private static Map<Class, Option> instances = Maps.map();
    private Map<Option<?>, OptionValue<?>> opts = Maps.map();

    public static Map<Option<?>, OptionValue<?>> getOptionMap() {
        return Maps.copy(AppEnv.getOptions().opts);
    }

    public static <T> boolean hasValue(Class optionClass) {
        Option<T> option = Options.getInstance(optionClass);
        return AppEnv.getOptions().opts.containsKey(option);
    }

    public static <T> boolean hasValue(Option<T> option) {
        return AppEnv.getOptions().opts.containsKey(option);
    }

    private <T> T getInternal(Option<T> option) {
        if (!this.opts.containsKey(option)) {
            String msg = Strings.fmt((String)"Unknown option: %s. Please register it with the application.", (Object[])new Object[]{option});
            throw new IllegalStateException(msg);
        }
        OptionValue<?> value = this.opts.get(option);
        return (T)value.getValue();
    }

    private <T> void setInternal(Option<T> option, T value) {
        this.opts.put(option, new OptionValue<T>(option, value));
    }

    public static <T> T get(Class<? extends Option<T>> optionClass) {
        Option<T> option = Options.getInstance(optionClass);
        return AppEnv.getOptions().getInternal(option);
    }

    public static <T> T get(Option<T> option) {
        return AppEnv.getOptions().getInternal(option);
    }

    public static <T> void set(Class optionClass, T value) {
        Option<T> option = Options.getInstance(optionClass);
        AppEnv.getOptions().setInternal(option, value);
    }

    public static <T> void set(Option<T> option, T value) {
        AppEnv.getOptions().setInternal(option, value);
    }

    public static void initialize(OptionCategory options, boolean inclNonDlg) {
        Map lmap = Maps.map();
        options.fillLongOptMap(lmap);
        for (Option opt : lmap.values()) {
            if (!opt.showInDialog && !inclNonDlg) continue;
            Options.set(opt, opt.getDefault());
        }
    }

    public static void parse(OptionCategory options, String[] args) {
        Assert.check((boolean)options.getOptions().isEmpty());
        Map smap = Maps.map();
        Map lmap = Maps.map();
        options.fillShortOptMap(smap);
        options.fillLongOptMap(lmap);
        boolean inOpt = false;
        Option lastOpt = null;
        String lastOptName = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!inOpt) {
                if (arg.startsWith("--")) {
                    String argValue;
                    String argName;
                    argPart = arg.substring(2);
                    int idx = argPart.indexOf(61);
                    if (idx == -1) {
                        argName = argPart;
                        argValue = null;
                    } else {
                        argName = argPart.substring(0, idx);
                        argValue = argPart.substring(idx + 1);
                    }
                    Option opt = (Option)lmap.get(argName);
                    String optName = "--" + argName;
                    if (opt == null) {
                        String msg = Strings.fmt((String)"Unknown option: \"%s\"", (Object[])new Object[]{arg});
                        throw new InvalidOptionException(msg);
                    }
                    if (opt.getCmdValue() == null) {
                        if (argValue != null) {
                            String msg = Strings.fmt((String)"No value expected for option: \"%s\"", (Object[])new Object[]{arg});
                            throw new InvalidOptionException(msg);
                        }
                        Options.set(opt, Options.parseOptionValue(opt, optName, null));
                    } else {
                        if (argValue == null) {
                            String msg = Strings.fmt((String)"Missing \"=\" character in: \"%s\"", (Object[])new Object[]{arg});
                            throw new InvalidOptionException(msg);
                        }
                        Options.set(opt, Options.parseOptionValue(opt, optName, argValue));
                    }
                } else if (arg.startsWith("-")) {
                    String msg;
                    argPart = arg.substring(1);
                    if (argPart.length() == 0) {
                        String msg2 = Strings.fmt((String)"Invalid option format: \"%s\"", (Object[])new Object[]{arg});
                        throw new InvalidOptionException(msg2);
                    }
                    Character c = Character.valueOf(argPart.charAt(0));
                    Option opt = (Option)smap.get(c);
                    String optName = "-" + String.valueOf(c);
                    if (opt == null) {
                        msg = Strings.fmt((String)"Unknown option: \"%s\"", (Object[])new Object[]{arg});
                        throw new InvalidOptionException(msg);
                    }
                    if (opt.getCmdValue() == null) {
                        if (argPart.length() > 1) {
                            msg = Strings.fmt((String)"No value expected for option: \"%s\"", (Object[])new Object[]{arg});
                            throw new InvalidOptionException(msg);
                        }
                        Options.set(opt, Options.parseOptionValue(opt, optName, null));
                    } else if (argPart.length() > 1) {
                        Options.set(opt, Options.parseOptionValue(opt, optName, argPart.substring(1)));
                    } else {
                        inOpt = true;
                        lastOpt = opt;
                        lastOptName = optName;
                    }
                } else {
                    Option opt = (Option)lmap.get("*");
                    if (opt == null) {
                        String msg = Strings.fmt((String)"Non-option argument not expected: \"%s\"", (Object[])new Object[]{arg});
                        throw new InvalidOptionException(msg);
                    }
                    List curValues = (List)AppEnv.getOptions().opts.get(opt).getValue();
                    List newValues = (List)Options.parseOptionValue(opt, null, arg);
                    curValues.addAll(newValues);
                }
            } else {
                Options.set(lastOpt, Options.parseOptionValue(lastOpt, lastOptName, arg));
                inOpt = false;
                lastOpt = null;
                lastOptName = null;
            }
            Assert.implies((boolean)inOpt, (lastOpt != null ? 1 : 0) != 0);
            Assert.implies((!inOpt ? 1 : 0) != 0, (lastOpt == null ? 1 : 0) != 0);
            Assert.check((lastOpt == null == (lastOptName == null) ? 1 : 0) != 0);
            ++i;
        }
        if (inOpt) {
            Assert.notNull(lastOptName);
            String msg = Strings.fmt((String)"Incomplete command line for option \"%s\".", (Object[])new Object[]{lastOptName});
            throw new InvalidOptionException(msg);
        }
    }

    private static <T> T parseOptionValue(Option<T> opt, String optName, String value) {
        try {
            return opt.parseValue(optName, value);
        }
        catch (Application.SuccessfulExitException e) {
            throw e;
        }
        catch (ApplicationException e) {
            String msg = optName == null ? Strings.fmt((String)"Invalid value for argument: \"%s\".", (Object[])new Object[]{value}) : Strings.fmt((String)"Invalid value for option \"%s\": \"%s\".", (Object[])new Object[]{optName, value});
            throw new InvalidOptionException(msg, (Throwable)e);
        }
    }

    public static void postProcess(OptionCategory options) {
        Assert.check((boolean)options.getOptions().isEmpty());
        Map lmap = Maps.map();
        options.fillLongOptMap(lmap);
        for (Option opt : lmap.values()) {
            opt.postProcessValue(Options.get(opt));
        }
    }

    public static void verifyOptions(OptionCategory options) {
        Assert.check((boolean)options.getOptions().isEmpty());
        Map lmap = Maps.map();
        options.fillLongOptMap(lmap);
        for (Option opt : lmap.values()) {
            try {
                opt.verifyValue(Options.get(opt));
            }
            catch (InvalidOptionException e) {
                String cmdLong = opt.getCmdLong();
                if (cmdLong.equals("*")) {
                    throw e;
                }
                String msg = Strings.fmt((String)"Invalid value for option \"--%s\".", (Object[])new Object[]{cmdLong});
                throw new InvalidOptionException(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Option<T> getInstance(Class<?> optionClass) {
        Map<Class, Option> map = instances;
        synchronized (map) {
            Option rslt;
            if (instances.containsKey(optionClass)) {
                Option rslt2 = instances.get(optionClass);
                Assert.notNull((Object)rslt2);
                return rslt2;
            }
            try {
                rslt = (Option)optionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                String msg = "Can't create singleton option instance.";
                throw new RuntimeException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Can't create singleton option instance.";
                throw new RuntimeException(msg, e);
            }
            catch (SecurityException e) {
                String msg = "Can't create singleton option instance.";
                throw new RuntimeException(msg, e);
            }
            instances.put(optionClass, rslt);
            return rslt;
        }
    }
}

