/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolParameter;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolArgument;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolInvokeExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.ExprsChecker;
import org.eclipse.escet.tooldef.typechecker.FormatPatternChecker;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.eclipse.escet.tooldef.typechecker.TypeConstraints;
import org.eclipse.escet.tooldef.typechecker.TypeHints;
import org.eclipse.escet.tooldef.typechecker.TypeMatcher;

public class ToolInvokeChecker {
    private ToolInvokeChecker() {
    }

    public static void tcheck(ToolInvokeExpression expr, CheckerContext ctxt, TypeHints hints, boolean asExpr) {
        block33: {
            boolean builtin = expr.getTool().isBuiltin();
            String toolRefTxt = expr.getTool().getName();
            Position toolRefPos = expr.getTool().getPosition();
            List<ToolRef> toolRefs = builtin ? ctxt.resolveBuiltin(toolRefTxt, toolRefPos) : ctxt.resolveTool(toolRefTxt, toolRefPos);
            List tools = Lists.listc((int)toolRefs.size());
            for (ToolRef toolRef : toolRefs) {
                tools.add(new ToolOverload(toolRef));
            }
            String toolName = ((ToolOverload)Lists.first((List)tools)).tool.getName();
            Map argNameMap = Maps.map();
            for (ToolArgument arg : expr.getArguments()) {
                String name = arg.getName();
                if (name == null) continue;
                Position prevPos = (Position)argNameMap.get(name);
                if (prevPos == null) {
                    argNameMap.put(name, arg.getPosition());
                    continue;
                }
                Position argPos = arg.getPosition();
                ctxt.addProblem(Message.INVOKE_DUPL_NAMED_ARG, prevPos, name);
                ctxt.addProblem(Message.INVOKE_DUPL_NAMED_ARG, argPos, name);
                throw new SemanticException();
            }
            ToolArgument namedArg = null;
            for (ToolArgument arg : expr.getArguments()) {
                if (arg.getName() != null && namedArg == null) {
                    namedArg = arg;
                }
                if (arg.getName() != null || namedArg == null) continue;
                ctxt.addProblem(Message.INVOKE_POS_ARG_AFTER_NAMED_ARG, arg.getPosition(), namedArg.getName());
                throw new SemanticException();
            }
            if (asExpr) {
                for (ToolOverload tool : tools) {
                    tool.checkHasReturnType();
                }
            }
            for (ToolArgument arg : expr.getArguments()) {
                ToolOverload tool;
                ToolParameter param;
                List params = Lists.listc((int)tools.size());
                for (ToolOverload tool2 : tools) {
                    param = tool2.matchNextArgument(arg);
                    params.add(param);
                }
                if (ToolInvokeChecker.allOverloadsFailed(tools)) break;
                TypeHints argHints = new TypeHints();
                int i = 0;
                while (i < tools.size()) {
                    param = (ToolParameter)params.get(i);
                    if (param != null) {
                        tool = (ToolOverload)tools.get(i);
                        argHints.add(tool.computeArgHint(arg, param));
                    }
                    ++i;
                }
                ExprsChecker.tcheck(arg.getValue(), ctxt, argHints);
                i = 0;
                while (i < tools.size()) {
                    param = (ToolParameter)params.get(i);
                    if (param != null) {
                        tool = (ToolOverload)tools.get(i);
                        tool.checkTypeMatch(arg, param);
                    }
                    ++i;
                }
                if (ToolInvokeChecker.allOverloadsFailed(tools)) break;
            }
            for (ToolOverload tool : tools) {
                tool.checkComplete();
            }
            if (ToolInvokeChecker.allOverloadsFailed(tools)) {
                ctxt.addProblem(Message.INVOKE_NO_MATCH, expr.getPosition(), toolName, Strings.str((Object)tools.size()), tools.size() == 1 ? "" : "s", ToolInvokeChecker.getFailureReasons(tools));
                throw new SemanticException();
            }
            for (ToolOverload tool : tools) {
                if (tool.hasFailed()) continue;
                tool.computeParamTypes();
            }
            List matches = Lists.list();
            for (ToolOverload tool : tools) {
                if (tool.hasFailed()) continue;
                matches.add(tool);
            }
            Collections.sort(matches);
            ToolOverload chosenTool = (ToolOverload)Lists.first((List)matches);
            expr.setTool(chosenTool.toolRef);
            Assert.implies((chosenTool.returnType == null ? 1 : 0) != 0, (!asExpr ? 1 : 0) != 0);
            if (chosenTool.returnType != null) {
                expr.setType((ToolDefType)EMFHelper.deepclone((EObject)chosenTool.computeReturnType()));
            }
            if (!chosenTool.toolRef.isBuiltin()) break block33;
            switch (toolName) {
                case "err": 
                case "fmt": 
                case "out": 
                case "errln": 
                case "outln": {
                    FormatPatternChecker.tcheck(expr, ctxt);
                }
            }
        }
    }

    private static String getFailureReasons(List<ToolOverload> tools) {
        Map msgMap = Maps.map();
        for (ToolOverload tool : tools) {
            Integer cnt = (Integer)msgMap.get(tool.failureMsg);
            if (cnt == null) {
                cnt = 0;
            }
            cnt = cnt + 1;
            msgMap.put(tool.failureMsg, cnt);
        }
        List msgs = Sets.sortedstrings(msgMap.keySet());
        int i = 0;
        while (i < msgs.size()) {
            String msg = (String)msgs.get(i);
            int cnt = (Integer)msgMap.get(msg);
            if (cnt > 1) {
                msgs.set(i, msg + Strings.fmt((String)" (%d overloads)", (Object[])new Object[]{cnt}));
            }
            ++i;
        }
        return String.join((CharSequence)", ", msgs);
    }

    private static boolean allOverloadsFailed(List<ToolOverload> tools) {
        for (ToolOverload tool : tools) {
            if (tool.hasFailed()) continue;
            return false;
        }
        return true;
    }

    private static class ToolOverload
    implements Comparable<ToolOverload> {
        public final ToolRef toolRef;
        public final Tool tool;
        public final ToolDefType returnType;
        public final List<ToolParameter> params;
        public final int variadicIdx;
        public int posIdx = 0;
        public boolean[] matched;
        public TypeConstraints constraints = new TypeConstraints();
        public List<ToolDefType> paramTypes = null;
        public String failureMsg = null;

        public ToolOverload(ToolRef toolRef) {
            this.toolRef = toolRef;
            this.tool = toolRef.getTool();
            this.returnType = this.tool.getReturnTypes().isEmpty() ? null : ToolDefTypeUtils.makeTupleType((List)EMFHelper.deepclone((List)this.tool.getReturnTypes()));
            this.params = this.tool.getParameters();
            int vi = -1;
            int i = 0;
            while (i < this.params.size()) {
                if (this.params.get(i).isVariadic()) {
                    vi = i;
                    break;
                }
                ++i;
            }
            this.variadicIdx = vi;
            this.matched = new boolean[this.params.size()];
        }

        public boolean hasFailed() {
            return this.failureMsg != null;
        }

        public void checkHasReturnType() {
            if (this.hasFailed()) {
                return;
            }
            if (this.returnType == null) {
                this.failureMsg = "no return types present";
            }
        }

        public ToolParameter matchNextArgument(ToolArgument arg) {
            if (this.hasFailed()) {
                return null;
            }
            String argName = arg.getName();
            if (argName == null) {
                if (this.posIdx >= this.params.size() && this.variadicIdx == -1) {
                    this.failureMsg = Strings.fmt((String)"no %s parameter found", (Object[])new Object[]{Numbers.toOrdinal((int)(this.posIdx + 1))});
                    return null;
                }
                ToolParameter param = this.params.get(this.posIdx);
                this.matched[this.posIdx] = true;
                ++this.posIdx;
                if (this.variadicIdx != -1 && this.posIdx == this.variadicIdx + 1) {
                    --this.posIdx;
                }
                return param;
            }
            int i = 0;
            while (i < this.params.size()) {
                ToolParameter param = this.params.get(i);
                if (param.getName().equals(argName)) {
                    if (this.matched[i]) {
                        this.failureMsg = Strings.fmt((String)"a positional and a named argument both match parameter \"%s\"", (Object[])new Object[]{argName});
                        return null;
                    }
                    this.matched[i] = true;
                    return param;
                }
                ++i;
            }
            this.failureMsg = Strings.fmt((String)"no \"%s\" parameter found", (Object[])new Object[]{argName});
            return null;
        }

        public ToolDefType computeArgHint(ToolArgument arg, ToolParameter param) {
            ToolDefType paramType = ToolOverload.getType(arg, param);
            return TypeMatcher.substitute(paramType, this.constraints, true);
        }

        public static ToolDefType getType(ToolArgument arg, ToolParameter param) {
            ToolDefType type = param.getType();
            if (param.isVariadic() && arg.getName() == null) {
                Assert.check((boolean)(type instanceof ListType));
                type = ((ListType)type).getElemType();
            }
            return type;
        }

        public void checkTypeMatch(ToolArgument arg, ToolParameter param) {
            Assert.check((!this.hasFailed() ? 1 : 0) != 0);
            ToolDefType argType = arg.getValue().getType();
            ToolDefType paramType = ToolOverload.getType(arg, param);
            if (TypeMatcher.computeSubType(argType, paramType, this.constraints)) {
                return;
            }
            this.failureMsg = Strings.fmt((String)"type \"%s\" doesn't fit parameter \"%s\"", (Object[])new Object[]{ToolDefTextUtils.typeToStr((ToolDefType)argType), param.getName()});
        }

        public void checkComplete() {
            if (this.hasFailed()) {
                return;
            }
            int i = 0;
            while (i < this.params.size()) {
                ToolParameter param = this.params.get(i);
                if (!param.isVariadic() && param.getValue() == null && !this.matched[i]) {
                    this.failureMsg = Strings.fmt((String)"no argument for mandatory parameter \"%s\"", (Object[])new Object[]{param.getName()});
                    return;
                }
                ++i;
            }
        }

        public void computeParamTypes() {
            Assert.check((!this.hasFailed() ? 1 : 0) != 0);
            Assert.check((this.paramTypes == null ? 1 : 0) != 0);
            this.paramTypes = Lists.listc((int)this.params.size());
            for (ToolParameter param : this.params) {
                ToolDefType paramType = param.getType();
                this.paramTypes.add(TypeMatcher.substitute(paramType, this.constraints, false));
            }
        }

        public ToolDefType computeReturnType() {
            Assert.notNull((Object)this.returnType);
            return TypeMatcher.substitute(this.returnType, this.constraints, true);
        }

        @Override
        public int compareTo(ToolOverload other) {
            int cnt = Math.max(this.params.size(), other.params.size());
            int i = 0;
            while (i < cnt) {
                ToolParameter thisParam = null;
                ToolParameter otherParam = null;
                if (i < this.params.size()) {
                    thisParam = this.params.get(i);
                }
                if (i < other.params.size()) {
                    otherParam = other.params.get(i);
                }
                if (thisParam == null && otherParam != null) {
                    return -1;
                }
                if (thisParam != null && otherParam == null) {
                    return 1;
                }
                Assert.notNull((Object)thisParam);
                Assert.notNull((Object)otherParam);
                ToolDefType thisType = this.paramTypes.get(i);
                ToolDefType otherType = other.paramTypes.get(i);
                int rslt = ToolDefTypeUtils.compareTypes((ToolDefType)thisType, (ToolDefType)otherType);
                if (rslt != 0) {
                    return rslt;
                }
                if (!thisParam.isVariadic() && otherParam.isVariadic()) {
                    return -1;
                }
                if (thisParam.isVariadic() && !otherParam.isVariadic()) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
    }
}

