/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.eval.ShapeEval;
import org.apache.jena.shex.expressions.TripleExprCardinality;
import org.apache.jena.shex.sys.ValidationContext;

public class ShapeEvalCardinality {
    static boolean matchesCardinality(ValidationContext vCxt, Set<Triple> matchables, Node node, TripleExprCardinality tripleExprCard, Set<Node> extras) {
        int min2 = tripleExprCard.min();
        int max2 = tripleExprCard.max();
        if (min2 == 1 && max2 == 1) {
            return ShapeEval.matches(vCxt, matchables, node, tripleExprCard.target(), extras);
        }
        if (min2 == 0) {
            return true;
        }
        List<List<Set<Triple>>> partitions = ShapeEvalCardinality.cardinalityPartition(matchables, min2, max2);
        if (ShapeEval.DEBUG_cardinalityOf) {
            System.out.println("Cardinality: " + tripleExprCard);
            if (partitions.isEmpty()) {
                System.out.println("--");
                System.out.println("<empty>");
            }
            System.out.println("----");
        }
        for (List<Set<Triple>> partition : partitions) {
            boolean OK = true;
            if (ShapeEval.DEBUG_cardinalityOf) {
                System.out.println(partition);
            }
            for (Set<Triple> part : partition) {
                boolean b = ShapeEval.matches(vCxt, part, node, tripleExprCard.target(), extras);
                if (ShapeEval.DEBUG_cardinalityOf) {
                    System.out.println("  " + b);
                }
                if (b) continue;
                OK = false;
                break;
            }
            if (!OK) continue;
            return true;
        }
        return false;
    }

    private static <X> List<List<Set<X>>> cardinalityPartition(Set<X> collection, int min2, int max2) {
        if (max2 == 1) {
            return List.of(List.of(collection));
        }
        ArrayList<List<Set<X>>> results = new ArrayList<List<Set<X>>>();
        int maxK = max2 < 0 ? collection.size() : max2;
        for (int k = min2; k <= maxK; ++k) {
            List<List<Set<X>>> allSizeK = ShapeEvalCardinality.partition(collection, k);
            if (allSizeK == null) continue;
            results.addAll(allSizeK);
        }
        return results;
    }

    private static <X> List<List<Set<X>>> partition(Set<X> collection, int k) {
        if (k <= 0) {
            return null;
        }
        if (collection.size() < k) {
            return null;
        }
        if (collection.size() == k) {
            ArrayList result1 = new ArrayList();
            collection.forEach(item -> {
                HashSet<Object> xs = new HashSet<Object>();
                xs.add(item);
                result1.add(xs);
            });
            return List.of(result1);
        }
        X item2 = CollectionUtils.oneElt(collection);
        HashSet<X> processing = new HashSet<X>(collection);
        processing.remove(item2);
        ArrayList<List<Set<X>>> results = new ArrayList<List<Set<X>>>();
        List<List<Set<X>>> x2 = ShapeEvalCardinality.partition(processing, k - 1);
        if (x2 != null) {
            for (List<Set<X>> partition : x2) {
                ArrayList<Set<X>> partition2 = new ArrayList<Set<X>>(partition);
                partition2.add(Set.of(item2));
                results.add(partition2);
            }
        }
        List<List<Set<X>>> x = ShapeEvalCardinality.partition(processing, k);
        for (int i = 0; i < x.size(); ++i) {
            List<Set<X>> subPartition = x.get(i);
            for (int j = 0; j < subPartition.size(); ++j) {
                HashSet<X> box = new HashSet<X>((Collection)subPartition.get(j));
                ArrayList<Set<X>> withItem = new ArrayList<Set<X>>(subPartition);
                box.add(item2);
                withItem.set(j, box);
                results.add(withItem);
            }
        }
        return results;
    }
}

