/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public class DatasetGraphMap
extends DatasetGraphTriplesQuads {
    private final DatasetGraphFactory.GraphMaker graphMaker;
    private final Map<Node, Graph> graphs = new HashMap<Node, Graph>();
    private final Graph defaultGraph;
    private final PrefixMap prefixes;
    private final Transactional txn = TransactionalLock.createMRSW();

    public DatasetGraphMap() {
        this(null, DatasetGraphFactory.graphMakerMem);
    }

    public DatasetGraphMap(Graph defaultGraph) {
        this(defaultGraph, DatasetGraphFactory.graphMakerMem);
    }

    private DatasetGraphMap(Graph baseDefaultGraph, DatasetGraphFactory.GraphMaker baseGraphMaker) {
        this.graphMaker = DatasetGraphMap.namedGraphMaker(baseGraphMaker);
        this.defaultGraph = baseDefaultGraph == null ? this.graphMaker.create(null) : (baseDefaultGraph instanceof NamedGraph ? baseDefaultGraph : this.graphMaker.create(null));
        this.prefixes = Prefixes.adapt(this.defaultGraph);
    }

    private static DatasetGraphFactory.GraphMaker namedGraphMaker(DatasetGraphFactory.GraphMaker baseMaker) {
        return name -> {
            Graph g = baseMaker.create(name);
            if (g instanceof NamedGraph) {
                return g;
            }
            return new NamedGraphWrapper(name, g);
        };
    }

    private final Transactional txn() {
        return this.txn;
    }

    @Override
    public void begin() {
        this.txn().begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.txn().begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn().begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        return this.txn().promote(txnType);
    }

    @Override
    public void commit() {
        this.txn().commit();
    }

    @Override
    public void abort() {
        this.txn().abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn().isInTransaction();
    }

    @Override
    public void end() {
        this.txn().end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txn().transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txn().transactionType();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphs.entrySet().stream().filter(e2 -> !((Graph)e2.getValue()).isEmpty()).map(Map.Entry::getKey).iterator();
    }

    @Override
    public PrefixMap prefixes() {
        return this.prefixes;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        if (Quad.isDefaultGraph(graphNode)) {
            return true;
        }
        if (Quad.isUnionGraph(graphNode)) {
            return true;
        }
        Graph g = this.graphs.get(graphNode);
        return g != null && !g.isEmpty();
    }

    @Override
    protected void addToDftGraph(Node s, Node p, Node o) {
        this.getDefaultGraph().add(Triple.create(s, p, o));
    }

    @Override
    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.getGraph(g).add(Triple.create(s, p, o));
    }

    @Override
    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.getDefaultGraph().delete(Triple.create(s, p, o));
    }

    @Override
    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.getGraph(g).delete(Triple.create(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        ExtendedIterator<Triple> iter = this.getDefaultGraph().find(s, p, o);
        return G.triples2quadsDftGraph(iter);
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        ExtendedIterator<Triple> iter = this.getGraph(g).find(s, p, o);
        return G.triples2quads(g, iter);
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        Iterator<Node> gnames = this.listGraphNodes();
        IteratorConcat<Quad> iter = new IteratorConcat<Quad>();
        while (gnames.hasNext()) {
            Node gn = gnames.next();
            Iterator<Quad> qIter = this.findInSpecificNamedGraph(gn, s, p, o);
            if (qIter == null) continue;
            iter.add(qIter);
        }
        return iter;
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (Quad.isUnionGraph(graphNode)) {
            return GraphOps.unionGraph(this);
        }
        if (Quad.isDefaultGraph(graphNode)) {
            return this.getDefaultGraph();
        }
        Graph g = this.graphs.get(graphNode);
        if (g == null && (g = this.getGraphCreate(graphNode)) != null) {
            this.graphs.put(graphNode, g);
        }
        return g;
    }

    @Override
    public void clear() {
        super.clear();
        this.graphs.clear();
    }

    protected Graph getGraphCreate(Node graphNode) {
        Graph g = this.graphMaker.create(graphNode);
        if (g == null) {
            throw new ARQException("Can't make new graphs");
        }
        return g;
    }

    @Override
    public long size() {
        return this.graphs.size();
    }

    private static class NamedGraphWrapper
    extends GraphWrapper
    implements NamedGraph {
        private final Node graphName;

        public NamedGraphWrapper(Node graphName, Graph graph) {
            super(graph);
            this.graphName = graphName;
        }

        @Override
        public Node getGraphName() {
            return this.graphName;
        }

        public String toString() {
            return "NamedGraphWrapper(" + this.graphName + ")";
        }
    }
}

