/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.changeTracking.NotificationToOperationConverter;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.CommandObserver;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreCommandStack;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.NotificationInfo;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter.FilterStack;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.recording.NotificationRecorder;
import org.eclipse.emf.emfstore.client.model.impl.OperationRecorderListener;
import org.eclipse.emf.emfstore.client.model.observers.PostCreationObserver;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.common.model.util.EObjectChangeNotifier;
import org.eclipse.emf.emfstore.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.common.model.util.SettingWithReferencedElement;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.impl.CreateDeleteOperationImpl;
import org.eclipse.emf.emfstore.server.model.versioning.operations.semantic.SemanticCompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationRecorder
implements CommandObserver,
IdEObjectCollectionChangeObserver {
    public static final String UNKOWN_CREATOR = "unknown";
    private int currentOperationListSize;
    private EditingDomain editingDomain;
    private EMFStoreCommandStack emfStoreCommandStack;
    private Set<EObject> currentClipboard;
    private List<AbstractOperation> operations;
    private List<EObject> removedElements;
    private NotificationToOperationConverter converter;
    private NotificationRecorder notificationRecorder;
    private CompositeOperation compositeOperation;
    private IdEObjectCollectionImpl collection;
    private EObjectChangeNotifier changeNotifier;
    private boolean isRecording;
    private boolean commandIsRunning;
    private boolean cutOffIncomingCrossReferences;
    private boolean emitOperationsWhenCommandCompleted;

    public OperationRecorder(IdEObjectCollectionImpl collection, EObjectChangeNotifier changeNotifier) {
        this.collection = collection;
        this.changeNotifier = changeNotifier;
        this.operations = new ArrayList<AbstractOperation>();
        this.editingDomain = Configuration.getEditingDomain();
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (!(commandStack instanceof EMFStoreCommandStack)) {
            throw new IllegalStateException("Setup of ResourceSet is invalid, there is no EMFStoreCommandStack!");
        }
        this.emfStoreCommandStack = (EMFStoreCommandStack)commandStack;
        this.emfStoreCommandStack.addCommandStackObserver(this);
        this.removedElements = new ArrayList<EObject>();
        this.converter = new NotificationToOperationConverter(collection);
        this.cutOffIncomingCrossReferences = true;
        Boolean cutOff = new ExtensionPoint("org.eclipse.emf.emfstore.client.recording.options").getBoolean("cutOffIncomingCrossReferences");
        if (cutOff != null) {
            this.cutOffIncomingCrossReferences = cutOff;
        }
        this.emitOperationsWhenCommandCompleted = true;
    }

    public void clearOperations() {
        this.operations.clear();
    }

    public IdEObjectCollection getCollection() {
        return this.collection;
    }

    public List<EObject> getRemovedElements() {
        return this.removedElements;
    }

    private Set<EObject> getModelElementsFromClipboard() {
        HashSet<EObject> result = new HashSet<EObject>();
        if (this.editingDomain == null) {
            return result;
        }
        Collection clipboard = this.editingDomain.getClipboard();
        if (clipboard == null) {
            return result;
        }
        for (Object element : clipboard) {
            if (!(element instanceof EObject)) continue;
            result.add((EObject)element);
        }
        return result;
    }

    public void modelElementAdded(IdEObjectCollection project, EObject modelElement) {
        if (this.getModelElementsFromClipboard().contains(modelElement)) {
            return;
        }
        if (this.isRecording) {
            this.stopChangeRecording();
            ((PostCreationObserver)WorkspaceManager.getObserverBus().notify(PostCreationObserver.class)).onCreation(modelElement);
            this.startChangeRecording();
            HashSet<EObject> allModelElements = new HashSet<EObject>();
            allModelElements.add(modelElement);
            allModelElements.addAll(ModelUtil.getAllContainedModelElements((EObject)modelElement, (boolean)false));
            List crossReferences = ModelUtil.collectOutgoingCrossReferences((IdEObjectCollection)this.collection, allModelElements);
            List<SettingWithReferencedElement> ingoingCrossReferences = OperationRecorder.collectIngoingCrossReferences((IdEObjectCollection)this.collection, allModelElements);
            crossReferences.addAll(ingoingCrossReferences);
            CreateDeleteOperation createDeleteOperation = this.createCreateDeleteOperation(modelElement, false);
            List<ReferenceOperation> recordedOperations = this.generateCrossReferenceOperations(crossReferences);
            createDeleteOperation.getSubOperations().addAll(recordedOperations);
            if (this.compositeOperation != null) {
                this.compositeOperation.getSubOperations().add((Object)createDeleteOperation);
            } else if (this.commandIsRunning && this.emitOperationsWhenCommandCompleted) {
                this.operations.add((AbstractOperation)createDeleteOperation);
            } else {
                this.operationRecorded((AbstractOperation)createDeleteOperation);
            }
        }
    }

    private static List<SettingWithReferencedElement> collectIngoingCrossReferences(IdEObjectCollection collection, Set<EObject> allModelElements) {
        ArrayList<SettingWithReferencedElement> settings = new ArrayList<SettingWithReferencedElement>();
        for (EObject modelElement : allModelElements) {
            Collection<EStructuralFeature.Setting> inverseReferences = WorkspaceManager.getInstance().findInverseCrossReferences(modelElement);
            for (EStructuralFeature.Setting setting : inverseReferences) {
                if (!ModelUtil.shouldBeCollected((IdEObjectCollection)collection, allModelElements, (EObject)setting.getEObject())) continue;
                EReference reference = (EReference)setting.getEStructuralFeature();
                EClassifier eType = reference.getEType();
                if (reference.isContainer() || reference.isContainment() || !reference.isChangeable() || !(eType instanceof EClass)) continue;
                SettingWithReferencedElement settingWithReferencedElement = new SettingWithReferencedElement(setting, modelElement);
                settings.add(settingWithReferencedElement);
            }
        }
        return settings;
    }

    private List<ReferenceOperation> generateCrossReferenceOperations(Collection<SettingWithReferencedElement> crossReferences) {
        ArrayList<ReferenceOperation> result = new ArrayList<ReferenceOperation>();
        for (SettingWithReferencedElement setting : crossReferences) {
            EObject referencedElement = setting.getReferencedElement();
            ModelElementId newModelElementId = this.collection.getModelElementId(referencedElement);
            if (newModelElementId == null) {
                newModelElementId = this.collection.getDeletedModelElementId(referencedElement);
            }
            EObject eObject = setting.getSetting().getEObject();
            EReference reference = (EReference)setting.getSetting().getEStructuralFeature();
            if (setting.getSetting().getEStructuralFeature().isMany()) {
                int position = ((List)eObject.eGet((EStructuralFeature)reference)).indexOf(referencedElement);
                MultiReferenceOperation multiRefOp = NotificationToOperationConverter.createMultiReferenceOperation(this.collection, eObject, reference, Arrays.asList(referencedElement), true, position);
                result.add((ReferenceOperation)multiRefOp);
                continue;
            }
            SingleReferenceOperation singleRefOp = NotificationToOperationConverter.createSingleReferenceOperation(this.collection, null, newModelElementId, reference, eObject);
            result.add((ReferenceOperation)singleRefOp);
        }
        return result;
    }

    private void operationsRecorded(List<? extends AbstractOperation> operations) {
        if (operations.size() == 0) {
            return;
        }
        ((OperationRecorderListener)WorkspaceManager.getObserverBus().notify(OperationRecorderListener.class)).operationsRecorded(operations);
    }

    public void addOperationRecorderListener(OperationRecorderListener observer) {
        WorkspaceManager.getObserverBus().register((IObserver)observer);
    }

    public void removeOperationRecorderListener(OperationRecorderListener observer) {
        WorkspaceManager.getObserverBus().unregister((IObserver)observer);
    }

    public void startChangeRecording() {
        if (this.notificationRecorder == null) {
            this.notificationRecorder = new NotificationRecorder();
        }
        this.isRecording = true;
    }

    public void disableNotifications(boolean notificationDisabled) {
        if (this.changeNotifier != null) {
            this.changeNotifier.disableNotifications(notificationDisabled);
        }
    }

    public void stopChangeRecording() {
        this.isRecording = false;
    }

    private List<AbstractOperation> recordingFinished() {
        LinkedList<AbstractOperation> ops = new LinkedList<AbstractOperation>();
        List<NotificationInfo> rec = this.notificationRecorder.getRecording().asMutableList();
        for (NotificationInfo n : rec) {
            if (!n.isValid()) {
                WorkspaceUtil.log("INVALID NOTIFICATION MESSAGE DETECTED: " + n.getValidationMessage(), null, 0);
                continue;
            }
            AbstractOperation op = this.converter.convert(n);
            if (op != null) {
                ops.add(op);
                continue;
            }
            WorkspaceUtil.log("INVALID NOTIFICATION CLASSIFICATION, notification is valid, but cannot be converted to an operation: " + n.toString(), null, 0);
        }
        return ops;
    }

    public NotificationRecorder getNotificationRecorder() {
        return this.notificationRecorder;
    }

    private CreateDeleteOperation createCreateDeleteOperation(EObject modelElement, boolean delete) {
        CreateDeleteOperation createDeleteOperation = OperationsFactory.eINSTANCE.createCreateDeleteOperation();
        createDeleteOperation.setDelete(delete);
        EObject element = modelElement;
        List allContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)element, (boolean)false);
        allContainedModelElements.add(element);
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, false);
        EObject copiedElement = copier.copy(element);
        copier.copyReferences();
        List copiedAllContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)copiedElement, (boolean)false);
        copiedAllContainedModelElements.add(copiedElement);
        int i = 0;
        while (i < allContainedModelElements.size()) {
            EObject child = (EObject)allContainedModelElements.get(i);
            if (!ModelUtil.isIgnoredDatatype((EObject)child)) {
                EObject copiedChild = (EObject)copiedAllContainedModelElements.get(i);
                ModelElementId childId = this.collection.getModelElementId(child);
                ((CreateDeleteOperationImpl)createDeleteOperation).getEObjectToIdMap().put((Object)copiedChild, (Object)childId);
            }
            ++i;
        }
        createDeleteOperation.setModelElement(copiedElement);
        createDeleteOperation.setModelElementId(this.collection.getModelElementId(modelElement));
        createDeleteOperation.setClientDate(new Date());
        return createDeleteOperation;
    }

    public void modelElementRemoved(IdEObjectCollection project, EObject modelElement) {
        if (this.isRecording) {
            this.removedElements.add(modelElement);
        }
    }

    @Override
    public void commandCompleted(Command command) {
        ArrayList<EObject> deletedElements = new ArrayList<EObject>();
        int i = this.removedElements.size() - 1;
        while (i >= 0) {
            EObject removedElement = this.removedElements.get(i);
            if (!this.collection.containsInstance(removedElement) && !deletedElements.contains(removedElement)) {
                deletedElements.add(0, removedElement);
            }
            --i;
        }
        Set<EObject> newElementsOnClipboardAfterCommand = this.getModelElementsFromClipboard();
        for (EObject deletedElement : deletedElements) {
            if (newElementsOnClipboardAfterCommand.contains(deletedElement)) continue;
            this.handleElementDelete(deletedElement);
        }
        this.operationsRecorded(this.operations);
        this.removedElements.clear();
        this.operations.clear();
        this.commandIsRunning = false;
        newElementsOnClipboardAfterCommand.removeAll(deletedElements);
        this.collection.clearVolatileCaches();
    }

    private void deleteOutgoingCrossReferencesOfContainmentTree(Set<EObject> allEObjects) {
        for (EObject modelElement : allEObjects) {
            for (EReference reference : modelElement.eClass().getEAllReferences()) {
                EClassifier eType = reference.getEType();
                if (!(eType instanceof EClass)) continue;
                if (Map.Entry.class.isAssignableFrom(eType.getInstanceClass()) && reference.isContainment() && reference.isChangeable()) {
                    EClass mapEntryEClass = (EClass)eType;
                    EReference nonContainmentKeyReference = this.getNonContainmentKeyReference(mapEntryEClass);
                    if (nonContainmentKeyReference == null) continue;
                    List mapEntriesEList = (List)modelElement.eGet((EStructuralFeature)reference);
                    boolean outgoingKeyReferenceFound = false;
                    for (EObject eObject : mapEntriesEList) {
                        Object eGet = eObject.eGet((EStructuralFeature)nonContainmentKeyReference);
                        if (allEObjects.contains(eGet)) continue;
                        outgoingKeyReferenceFound = true;
                        break;
                    }
                    if (!outgoingKeyReferenceFound) continue;
                    ArrayList mapEntries = new ArrayList(mapEntriesEList);
                    EcoreUtil.resolveAll((EObject)modelElement);
                    modelElement.eUnset((EStructuralFeature)reference);
                    for (EObject mapEntry : mapEntries) {
                        this.handleElementDelete(mapEntry);
                    }
                    continue;
                }
                if (reference.isContainer() || reference.isContainment() || !reference.isChangeable()) continue;
                if (reference.isMany()) {
                    List referencedElements = (List)modelElement.eGet((EStructuralFeature)reference);
                    ArrayList<EObject> referencesToRemove = new ArrayList<EObject>();
                    for (EObject referencedElement : referencedElements) {
                        if (allEObjects.contains(referencedElement)) continue;
                        referencesToRemove.add(referencedElement);
                    }
                    referencedElements.removeAll(referencesToRemove);
                    continue;
                }
                EObject referencedElement = (EObject)modelElement.eGet((EStructuralFeature)reference);
                if (referencedElement == null || allEObjects.contains(referencedElement)) continue;
                modelElement.eSet((EStructuralFeature)reference, null);
            }
        }
    }

    private EReference getNonContainmentKeyReference(EClass eClass) {
        for (EReference eRef : eClass.getEReferences()) {
            if (eRef.getName().equals("key") && !eRef.isContainment()) {
                return eRef;
            }
            if (!eRef.getName().equals("key") || !eRef.isContainment()) continue;
            return null;
        }
        return null;
    }

    private void handleElementDelete(EObject deletedElement) {
        Set allContainedModelElementsSet = ModelUtil.getAllContainedModelElements((EObject)deletedElement, (boolean)false);
        allContainedModelElementsSet.add(deletedElement);
        this.deleteOutgoingCrossReferencesOfContainmentTree(allContainedModelElementsSet);
        if (this.cutOffIncomingCrossReferences) {
            for (EObject eObject : allContainedModelElementsSet) {
                Collection<EStructuralFeature.Setting> inverseReferences = WorkspaceManager.getInstance().findInverseCrossReferences(eObject);
                ModelUtil.deleteIncomingCrossReferencesFromParent(inverseReferences, (EObject)eObject);
            }
        }
        if (!this.isRecording) {
            return;
        }
        List allContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)deletedElement, (boolean)false);
        allContainedModelElements.add(deletedElement);
        EObject copiedElement = ModelUtil.clone((EObject)deletedElement);
        List copiedAllContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)copiedElement, (boolean)false);
        copiedAllContainedModelElements.add(copiedElement);
        CreateDeleteOperation deleteOperation = OperationsFactory.eINSTANCE.createCreateDeleteOperation();
        deleteOperation.setClientDate(new Date());
        deleteOperation.setModelElement(copiedElement);
        deleteOperation.setModelElementId(this.collection.getDeletedModelElementId(deletedElement));
        int i = 0;
        while (i < allContainedModelElements.size()) {
            EObject child = (EObject)allContainedModelElements.get(i);
            EObject copiedChild = (EObject)copiedAllContainedModelElements.get(i);
            ModelElementId childId = this.collection.getDeletedModelElementId(child);
            ((CreateDeleteOperationImpl)deleteOperation).getEObjectToIdMap().put((Object)copiedChild, (Object)childId);
            ++i;
        }
        deleteOperation.setDelete(true);
        ArrayList<CompositeOperation> compositeOperationsToDelete = new ArrayList<CompositeOperation>();
        deleteOperation.getSubOperations().addAll(this.extractReferenceOperationsForDelete(deletedElement, compositeOperationsToDelete));
        this.operations.removeAll(compositeOperationsToDelete);
        if (this.compositeOperation != null) {
            this.compositeOperation.getSubOperations().add((Object)deleteOperation);
            this.saveResource(this.compositeOperation.eResource());
        } else if (this.commandIsRunning) {
            this.operations.add((AbstractOperation)deleteOperation);
        } else {
            this.operationRecorded((AbstractOperation)deleteOperation);
        }
    }

    private List<ReferenceOperation> extractReferenceOperationsForDelete(EObject deletedElement, List<CompositeOperation> compositeOperationsToDelete) {
        HashSet<ModelElementId> allDeletedElementsIds = new HashSet<ModelElementId>();
        for (EObject child : ModelUtil.getAllContainedModelElements((EObject)deletedElement, (boolean)false)) {
            ModelElementId childId = this.collection.getDeletedModelElementId(child);
            allDeletedElementsIds.add(childId);
        }
        allDeletedElementsIds.add(this.collection.getDeletedModelElementId(deletedElement));
        ArrayList<ReferenceOperation> referenceOperationsForDelete = new ArrayList<ReferenceOperation>();
        List<AbstractOperation> newOperations = this.operations.subList(0, this.operations.size());
        ArrayList<AbstractOperation> l = new ArrayList<AbstractOperation>();
        int i = newOperations.size() - 1;
        while (i >= 0) {
            AbstractOperation operation = newOperations.get(i);
            if (this.belongsToDelete(operation, allDeletedElementsIds)) {
                referenceOperationsForDelete.add(0, (ReferenceOperation)operation);
                l.add(operation);
            } else {
                if (!(operation instanceof CompositeOperation) || ((CompositeOperation)operation).getMainOperation() == null) break;
                CompositeOperation compositeOperation = (CompositeOperation)operation;
                boolean doesNotBelongToDelete = false;
                for (AbstractOperation subOperation : compositeOperation.getSubOperations()) {
                    if (this.belongsToDelete(subOperation, allDeletedElementsIds)) continue;
                    doesNotBelongToDelete = true;
                    break;
                }
                if (!doesNotBelongToDelete) {
                    referenceOperationsForDelete.addAll(0, (Collection<ReferenceOperation>)compositeOperation.getSubOperations());
                    compositeOperationsToDelete.add(compositeOperation);
                }
            }
            --i;
        }
        this.operations.removeAll(l);
        return referenceOperationsForDelete;
    }

    private boolean belongsToDelete(AbstractOperation operation, Set<ModelElementId> allDeletedElementsIds) {
        ReferenceOperation referenceOperation;
        Set allInvolvedModelElements;
        if (operation instanceof ReferenceOperation && (allInvolvedModelElements = (referenceOperation = (ReferenceOperation)operation).getAllInvolvedModelElements()).removeAll(allDeletedElementsIds)) {
            return this.isDestructorReferenceOperation(referenceOperation);
        }
        return false;
    }

    private boolean isDestructorReferenceOperation(ReferenceOperation referenceOperation) {
        if (referenceOperation instanceof MultiReferenceOperation) {
            MultiReferenceOperation multiReferenceOperation = (MultiReferenceOperation)referenceOperation;
            return !multiReferenceOperation.isAdd();
        }
        if (referenceOperation instanceof SingleReferenceOperation) {
            SingleReferenceOperation singleReferenceOperation = (SingleReferenceOperation)referenceOperation;
            return singleReferenceOperation.getOldValue() != null && singleReferenceOperation.getNewValue() == null;
        }
        return false;
    }

    @Override
    public void commandFailed(Command command, Exception exception) {
        if (this.compositeOperation != null) {
            int i = this.compositeOperation.getSubOperations().size() - 1;
            while (i >= this.currentOperationListSize) {
                this.compositeOperation.getSubOperations().remove(i);
                --i;
            }
        }
    }

    @Override
    public void commandStarted(Command command) {
        this.currentOperationListSize = 0;
        this.currentClipboard = this.getModelElementsFromClipboard();
        this.commandIsRunning = true;
    }

    public CompositeOperation getCompositeOperation() {
        return this.compositeOperation;
    }

    public CompositeOperationHandle beginCompositeOperation() {
        if (this.compositeOperation != null) {
            throw new IllegalStateException("Can only have one composite at once!");
        }
        this.compositeOperation = OperationsFactory.eINSTANCE.createCompositeOperation();
        CompositeOperationHandle handle = new CompositeOperationHandle(this, this.compositeOperation);
        this.notificationRecorder.newRecording();
        this.operations.add((AbstractOperation)this.compositeOperation);
        return handle;
    }

    public void endCompositeOperation(SemanticCompositeOperation semanticCompositeOperation) {
        this.compositeOperation = semanticCompositeOperation;
        this.endCompositeOperation();
    }

    public void endCompositeOperation() {
        this.compositeOperation = null;
    }

    public void abortCompositeOperation() {
        if (this.operations.size() > 0) {
            AbstractOperation lastOp = this.operations.get(this.operations.size() - 1);
            this.stopChangeRecording();
            try {
                lastOp.reverse().apply(this.getCollection());
                this.operations.remove(this.operations.size() - 1);
            }
            finally {
                this.startChangeRecording();
            }
            this.removedElements.clear();
        }
        this.notificationRecorder.stopRecording();
        this.compositeOperation = null;
        this.currentOperationListSize = this.operations.size();
        this.removedElements.clear();
    }

    public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
        if (FilterStack.DEFAULT.check(new NotificationInfo(notification))) {
            return;
        }
        if (this.isRecording) {
            this.notificationRecorder.record(notification);
        }
        if (this.notificationRecorder.isRecordingComplete()) {
            if (!this.isRecording) {
                return;
            }
            List<AbstractOperation> ops = this.recordingFinished();
            if (this.compositeOperation != null) {
                this.compositeOperation.getSubOperations().addAll(ops);
                this.saveResource(this.compositeOperation.eResource());
                return;
            }
            if (ops.size() > 1) {
                CompositeOperation op = OperationsFactory.eINSTANCE.createCompositeOperation();
                op.getSubOperations().addAll(ops);
                op.setMainOperation(ops.get(ops.size() - 1));
                op.setModelElementId((ModelElementId)ModelUtil.clone((EObject)op.getMainOperation().getModelElementId()));
                if (this.commandIsRunning && this.emitOperationsWhenCommandCompleted) {
                    this.operations.add((AbstractOperation)op);
                } else {
                    this.operationRecorded((AbstractOperation)op);
                }
            } else if (ops.size() == 1) {
                if (this.commandIsRunning && this.emitOperationsWhenCommandCompleted) {
                    this.operations.add(ops.get(0));
                } else {
                    this.operationRecorded(ops.get(0));
                }
            }
        }
    }

    private void operationRecorded(AbstractOperation op) {
        this.operationsRecorded(Arrays.asList(op));
    }

    public void collectionDeleted(IdEObjectCollection collection) {
        if (this.emfStoreCommandStack != null) {
            this.emfStoreCommandStack.removeCommandStackObserver(this);
        }
    }

    public void emitOperationsWhenCommandCompleted(boolean emitOperationsImmediately) {
        this.emitOperationsWhenCommandCompleted = emitOperationsImmediately;
    }

    private void saveResource(Resource resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.save(ModelUtil.getResourceSaveOptions());
        }
        catch (IOException e) {
            String message = String.format("Resource {0} could not be saved!", resource.getURI());
            WorkspaceUtil.logWarning(message, null);
        }
    }
}

