/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.core.subinterfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.EmfStoreController;
import org.eclipse.emf.emfstore.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.helper.HistoryCache;
import org.eclipse.emf.emfstore.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.Version;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistorySubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    public HistorySubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalEmfStoreException {
        super(parentInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HistoryInfo> getHistoryInfo(ProjectId projectId, HistoryQuery historyQuery) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            if (historyQuery.getModelElements().size() > 0) {
                return this.getHistoryInfo(projectId, (List<ModelElementId>)historyQuery.getModelElements(), historyQuery.isIncludeChangePackage());
            }
            List<HistoryInfo> result = this.getHistoryInfo(projectId, historyQuery.getSource(), historyQuery.getTarget(), historyQuery.isIncludeChangePackage());
            if (historyQuery.getSource().compareTo((Object)historyQuery.getTarget()) < 0) {
                Collections.reverse(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            Version version = this.getSubInterface(VersionSubInterfaceImpl.class).getVersion(projectId, versionSpec);
            version.getTagSpecs().add((Object)tag);
            try {
                this.save((EObject)version);
            }
            catch (FatalEmfStoreException e) {
                throw new StorageException("Couldn't save data in database.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTag(ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            Version version = this.getSubInterface(VersionSubInterfaceImpl.class).getVersion(projectId, versionSpec);
            Iterator iterator = version.getTagSpecs().iterator();
            while (iterator.hasNext()) {
                if (!((TagVersionSpec)iterator.next()).getName().equals(tag.getName())) continue;
                iterator.remove();
            }
            try {
                this.save((EObject)version);
            }
            catch (FatalEmfStoreException e) {
                throw new StorageException("Couldn't save data in database.");
            }
        }
    }

    private List<HistoryInfo> getHistoryInfo(ProjectId projectId, List<ModelElementId> moList, boolean includeChangePackage) throws EmfStoreException {
        ModelElementId modelElementId;
        HistoryCache historyCache = EmfStoreController.getInstance().getHistoryCache();
        TreeSet<Version> elements = historyCache.getChangesForModelElement(projectId, modelElementId = moList.get(0));
        ArrayList<Version> versions = new ArrayList<Version>(elements);
        if (versions.size() == 0) {
            return new ArrayList<HistoryInfo>();
        }
        int historyCount = Math.min(versions.size(), 20);
        List<HistoryInfo> historyInfos = this.getHistoryInfo(versions.subList(0, historyCount), projectId, includeChangePackage);
        for (HistoryInfo historyInfo : historyInfos) {
            this.filterOperationsForSelectedME(modelElementId, historyInfo);
        }
        return historyInfos;
    }

    private void filterOperationsForSelectedME(ModelElementId modelElementId, HistoryInfo historyInfo) {
        if (historyInfo.getChangePackage() == null || historyInfo.getChangePackage().getOperations() == null) {
            return;
        }
        HashSet<AbstractOperation> operationsToRemove = new HashSet<AbstractOperation>();
        EList operations = historyInfo.getChangePackage().getOperations();
        for (AbstractOperation operation : operations) {
            if (operation.getAllInvolvedModelElements().contains(modelElementId)) continue;
            operationsToRemove.add(operation);
        }
        operations.removeAll(operationsToRemove);
    }

    private List<HistoryInfo> getHistoryInfo(ProjectId projectId, PrimaryVersionSpec source, PrimaryVersionSpec target, boolean includeChangePackage) throws EmfStoreException {
        if (source == null || target == null) {
            throw new InvalidInputException();
        }
        return this.getHistoryInfo(this.getSubInterface(VersionSubInterfaceImpl.class).getVersions(projectId, source, target), projectId, includeChangePackage);
    }

    private List<HistoryInfo> getHistoryInfo(List<Version> versions, ProjectId projectId, boolean includeChangePackage) throws EmfStoreException {
        ArrayList<HistoryInfo> result = new ArrayList<HistoryInfo>();
        PrimaryVersionSpec headRevision = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId).getLastVersion().getPrimarySpec();
        for (Version version : versions) {
            HistoryInfo history = this.createHistoryInfo(headRevision, version, includeChangePackage);
            result.add(history);
        }
        return result;
    }

    private HistoryInfo createHistoryInfo(PrimaryVersionSpec headRevision, Version version, boolean includeChangePackage) {
        HistoryInfo history = VersioningFactory.eINSTANCE.createHistoryInfo();
        if (includeChangePackage && version.getChanges() != null) {
            history.setChangePackage((ChangePackage)ModelUtil.clone((EObject)version.getChanges()));
        }
        history.setLogMessage((LogMessage)ModelUtil.clone((EObject)version.getLogMessage()));
        history.setPrimerySpec((PrimaryVersionSpec)ModelUtil.clone((EObject)version.getPrimarySpec()));
        for (TagVersionSpec tagSpec : version.getTagSpecs()) {
            history.getTagSpecs().add((Object)((TagVersionSpec)ModelUtil.clone((EObject)tagSpec)));
        }
        if (version.getPrimarySpec().equals(headRevision)) {
            TagVersionSpec spec = VersioningFactory.eINSTANCE.createTagVersionSpec();
            spec.setName("HEAD");
            history.getTagSpecs().add((Object)spec);
        }
        return history;
    }
}

