/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.conflictDetection;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.conflictDetection.ConflictDetectionStrategy;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

public class ByDocumentConflictDetectionStrategy
implements ConflictDetectionStrategy {
    private Project project;

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean doConflict(AbstractOperation operationA, AbstractOperation operationB) {
        EObject modelElement;
        Set allInvolvedModelElementsA = operationA.getAllInvolvedModelElements();
        Set allInvolvedModelElementsB = operationB.getAllInvolvedModelElements();
        HashSet<EObject> allInvolvedRootElementsA = new HashSet<EObject>();
        HashSet<EObject> allInvolvedRootElementsB = new HashSet<EObject>();
        for (ModelElementId modelElementId : allInvolvedModelElementsA) {
            modelElement = this.project.getModelElement(modelElementId);
            if (modelElement == null) continue;
            allInvolvedRootElementsA.add(this.getRootLevelParent(modelElement));
        }
        for (ModelElementId modelElementId : allInvolvedModelElementsB) {
            modelElement = this.project.getModelElement(modelElementId);
            if (modelElement == null) continue;
            allInvolvedRootElementsB.add(this.getRootLevelParent(modelElement));
        }
        return allInvolvedRootElementsA.removeAll(allInvolvedRootElementsB);
    }

    public boolean isRequired(AbstractOperation requiredOperation, AbstractOperation operation) {
        return this.doConflict(requiredOperation, operation);
    }

    private EObject getRootLevelParent(EObject modelElement) {
        EObject parent = modelElement;
        EObject nextParent = modelElement.eContainer();
        while (nextParent != null) {
            parent = nextParent;
            nextParent = nextParent.eContainer();
        }
        return parent;
    }
}

