/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.accesscontrol.authentication;

import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.ClientVersionOutOfDateException;
import org.eclipse.emf.emfstore.server.exceptions.ServerKeyStoreException;
import org.eclipse.emf.emfstore.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ModelFactory;
import org.eclipse.emf.emfstore.server.model.SessionId;

public abstract class AbstractAuthenticationControl
implements AuthenticationControl {
    private String superuser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
    private String superuserpw = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser.password", "super");

    public SessionId logIn(String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        this.checkClientVersion(clientVersionInfo);
        password = this.preparePassword(password);
        if (this.verifySuperUser(username, password) || this.verifyPassword(username, password)) {
            return ModelFactory.eINSTANCE.createSessionId();
        }
        throw new AccessControlException();
    }

    protected String preparePassword(String password) throws ServerKeyStoreException {
        return ServerKeyStoreManager.getInstance().decrypt(password);
    }

    protected boolean verifySuperUser(String username, String password) {
        return username.equals(this.superuser) && password.equals(this.superuserpw);
    }

    public void logout(SessionId sessionId) throws AccessControlException {
    }

    protected abstract boolean verifyPassword(String var1, String var2) throws AccessControlException;

    private void checkClientVersion(ClientVersionInfo clientVersionInfo) throws ClientVersionOutOfDateException {
        if (clientVersionInfo == null) {
            throw new ClientVersionOutOfDateException("No client version recieved.");
        }
        String[] versions = ServerConfiguration.getSplittedProperty("emfstore.acceptedversions");
        if (versions == null) {
            String msg = "No server versions supplied";
            ModelUtil.logWarning((String)msg, (Throwable)new ClientVersionOutOfDateException(msg));
            return;
        }
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equals(clientVersionInfo.getVersion()) || str.equals("any")) {
                return;
            }
            ++n2;
        }
        StringBuffer version = new StringBuffer();
        String[] stringArray2 = versions;
        int n3 = versions.length;
        n = 0;
        while (n < n3) {
            String str = stringArray2[n];
            if (versions.length == 1) {
                version.append(String.valueOf(str) + ". ");
            } else {
                version.append(String.valueOf(str) + ", ");
            }
            ++n;
        }
        version.replace(version.length() - 2, version.length(), ".");
        throw new ClientVersionOutOfDateException("Client version: " + clientVersionInfo.getVersion() + " - Accepted versions: " + version);
    }
}

