/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server;

import java.io.File;
import org.eclipse.emf.emfstore.server.LocationProvider;
import org.eclipse.emf.emfstore.server.ServerConfiguration;

public class DefaultServerWorkspaceLocationProvider
implements LocationProvider {
    protected String getRootDirectory() {
        String parameter = this.getStartParameter("-EMFStoreHome");
        return parameter == null ? DefaultServerWorkspaceLocationProvider.addFolders(DefaultServerWorkspaceLocationProvider.getUserHome(), ".emfstore", "server") : parameter;
    }

    public String getWorkspaceDirectory() {
        return DefaultServerWorkspaceLocationProvider.addFolders(this.getRootDirectory(), "profiles", this.getSelectedProfile());
    }

    protected String getSelectedProfile() {
        String parameter = this.getStartParameter("-profile");
        if (parameter == null) {
            parameter = "default";
            if (ServerConfiguration.isTesting()) {
                parameter = String.valueOf(parameter) + "_test";
            } else if (!ServerConfiguration.isReleaseVersion()) {
                parameter = ServerConfiguration.isInternalReleaseVersion() ? String.valueOf(parameter) + "_internal" : String.valueOf(parameter) + "_dev";
            }
        }
        return parameter;
    }

    public String getBackupDirectory() {
        return DefaultServerWorkspaceLocationProvider.addFolders(this.getRootDirectory(), "backup");
    }

    protected String getStartParameter(String parameter) {
        return ServerConfiguration.getStartArgument(parameter);
    }

    protected static String addFolders(String path, String ... folders) {
        StringBuffer result = new StringBuffer(path);
        if (!path.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            result.append(folder);
            if (!folder.endsWith(File.separator)) {
                result.append(File.separatorChar);
            }
            ++n2;
        }
        return result.toString();
    }

    protected static String getUserHome() {
        StringBuffer sb = new StringBuffer();
        sb.append(System.getProperty("user.home"));
        sb.append(File.separatorChar);
        return sb.toString();
    }
}

