/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.UnkownFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleReferenceConflict
extends Conflict {
    public SingleReferenceConflict(List<AbstractOperation> myOperations, List<AbstractOperation> theirOperations, DecisionManager decisionManager) {
        super(myOperations, theirOperations, decisionManager);
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        String descriptionTxt = "";
        descriptionTxt = this.isContainmentFeature() ? "You have moved the [modelelement] to the [myvalue].This element was moved to [theirvalue] on the repository. Please decide." : "You have changed the reference [feature] of [modelelement] to [myvalue].This reference was set to [theirvalue] on the repository. Please decide.";
        description.setDescription(descriptionTxt);
        EObject myNewValue = this.getDecisionManager().getModelElement(this.getMyOperation(SingleReferenceOperation.class).getNewValue());
        description.add("myvalue", myNewValue == null ? "(unset)" : myNewValue);
        EObject theirNewValue = this.getDecisionManager().getModelElement(this.getTheirOperation(SingleReferenceOperation.class).getNewValue());
        description.add("theirvalue", theirNewValue == null ? "(unset)" : theirNewValue);
        description.setImage("singleref.gif");
        return description;
    }

    private boolean isContainmentFeature() {
        EObject modelElement = this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId());
        if (modelElement == null) {
            return false;
        }
        try {
            if (((EReference)this.getMyOperation(SingleReferenceOperation.class).getFeature(modelElement)).isContainer()) {
                return true;
            }
        }
        catch (UnkownFeatureException unkownFeatureException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ModelElementId newValue = this.getMyOperation(SingleReferenceOperation.class).getNewValue();
        ConflictOption myOption = new ConflictOption(newValue == null ? "(unset)" : DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(newValue)), ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ModelElementId theirNewValue = this.getTheirOperation(SingleReferenceOperation.class).getNewValue();
        ConflictOption theirOption = new ConflictOption(DecisionUtil.getLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(theirNewValue)), "(unset)"), ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        options.add(myOption);
        options.add(theirOption);
    }
}

