/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.editor.ModelElementChangeListener;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.AddReferenceAction;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControl;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControlFactory;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.NewReferenceAction;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MESingleLinkControl
extends AbstractMEControl {
    private Composite composite;
    private EReference eReference;
    private Composite linkArea;
    private Composite parent;
    private int style;
    private MELinkControl meControl;
    private Label labelWidget;
    private static final int PRIORITY = 1;
    private ModelElementChangeListener modelElementChangeListener;

    @Override
    public Control createControl(Composite parent, int style) {
        Object feature = this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.eReference = (EReference)feature;
        this.composite = this.getToolkit().createComposite(parent, style);
        this.composite.setLayout((Layout)new GridLayout(3, false));
        if (!this.getItemPropertyDescriptor().canSetProperty((Object)this.getModelElement())) {
            this.composite.setEnabled(false);
        }
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(3).equalWidth(false).applyTo(this.composite);
        this.parent = parent;
        this.style = style;
        this.linkArea = this.getToolkit().createComposite(this.composite);
        this.linkArea.setLayout((Layout)new FillLayout());
        this.updateLink();
        for (Action action : this.initActions()) {
            this.createButtonForAction(action);
        }
        this.modelElementChangeListener = new ModelElementChangeListener(this.getModelElement()){

            public void onChange(Notification notification) {
                if (notification.getFeature() == MESingleLinkControl.this.eReference) {
                    MESingleLinkControl.this.updateLink();
                }
            }
        };
        return this.composite;
    }

    protected List<Action> initActions() {
        ArrayList<Action> result = new ArrayList<Action>();
        AddReferenceAction addAction = new AddReferenceAction(this.getModelElement(), this.eReference, this.getItemPropertyDescriptor(), this.getContext());
        result.add(addAction);
        NewReferenceAction newAction = new NewReferenceAction(this.getModelElement(), this.eReference, this.getItemPropertyDescriptor(), this.getContext());
        result.add(newAction);
        return result;
    }

    protected EReference geteReference() {
        return this.eReference;
    }

    protected void createButtonForAction(final Action action) {
        Button selectButton = this.getToolkit().createButton(this.composite, "", 8);
        selectButton.setImage(action.getImageDescriptor().createImage());
        selectButton.setToolTipText(action.getToolTipText());
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
    }

    private void updateLink() {
        EObject opposite;
        if (this.meControl != null) {
            this.meControl.dispose();
        }
        if (this.labelWidget != null) {
            this.labelWidget.dispose();
        }
        if ((opposite = (EObject)this.getModelElement().eGet((EStructuralFeature)this.eReference)) != null) {
            MELinkControlFactory meLinkControlFactory = new MELinkControlFactory();
            this.meControl = meLinkControlFactory.createMELinkControl(this.getItemPropertyDescriptor(), opposite, this.getModelElement(), this.getContext());
            this.meControl.createControl(this.linkArea, this.style, this.getItemPropertyDescriptor(), opposite, this.getModelElement(), this.getToolkit(), this.getContext());
        } else {
            this.labelWidget = this.getToolkit().createLabel(this.linkArea, "(Not Set)");
            this.labelWidget.setBackground(this.parent.getBackground());
            this.labelWidget.setForeground(this.parent.getShell().getDisplay().getSystemColor(16));
        }
        this.linkArea.layout(true);
        this.composite.layout(true);
    }

    @Override
    public void dispose() {
        this.modelElementChangeListener.remove();
        if (this.meControl != null) {
            this.meControl.dispose();
        }
    }

    @Override
    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        Object feature = itemPropertyDescriptor.getFeature((Object)modelElement);
        if (feature instanceof EReference && !((EReference)feature).isMany() && EObject.class.isAssignableFrom(((EReference)feature).getEType().getInstanceClass())) {
            return 1;
        }
        return -1;
    }
}

