/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.model.ModelElementContextListener;
import org.eclipse.emf.ecp.common.utilities.ShortLabelProvider;
import org.eclipse.emf.ecp.editor.AbstractMEEditorPage;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.MEEditorInput;
import org.eclipse.emf.ecp.editor.MEEditorPage;
import org.eclipse.emf.ecp.editor.ModelElementChangeListener;
import org.eclipse.emf.ecp.editor.PageCandidate;
import org.eclipse.emf.ecp.editor.StatusMessageProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;

public class MEEditor
extends SharedHeaderFormEditor {
    public static final String ID = "org.eclipse.emf.ecp.editor";
    private EObject modelElement;
    private EditingDomain editingDomain;
    private MEEditorPage mePage;
    private ILabelProviderListener labelProviderListener;
    private StatusMessageProvider statusMessageProvider;
    private ModelElementChangeListener modelElementChangeListener;
    private ECPModelelementContext modelElementContext;
    private ModelElementContextListener modelElementContextListener;

    protected void addPages() {
        String editorID = "Edit";
        String editorDesc = "Standard View";
        MEEditorInput editorInput = (MEEditorInput)this.getEditorInput();
        IConfigurationElement[] configTemp = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.editor.pages");
        IConfigurationElement[] configIn = null;
        boolean replaceMEEditor = false;
        int counter = 0;
        int i = 0;
        while (i < configTemp.length) {
            if (configTemp[i].getAttribute("replace") != null && configTemp[i].getAttribute("replace").equals(editorID)) {
                replaceMEEditor = true;
                try {
                    AbstractMEEditorPage newPage = (AbstractMEEditorPage)configTemp[i].createExecutableExtension("class");
                    FormPage createPage = newPage.createPage(this, this.editingDomain, this.modelElement);
                    if (createPage != null) {
                        this.addPage((IFormPage)createPage);
                    }
                }
                catch (CoreException e1) {
                    Activator.logException((Exception)((Object)e1));
                }
                configIn = new IConfigurationElement[configTemp.length - 1];
                int j = 0;
                int k = 0;
                while (j < configTemp.length - 1) {
                    if (counter == j) {
                        --j;
                    } else {
                        configIn[j] = configTemp[k];
                    }
                    ++j;
                    ++k;
                }
                break;
            }
            ++counter;
            ++i;
        }
        if (!replaceMEEditor) {
            try {
                this.mePage = editorInput.getProblemFeature() != null ? new MEEditorPage(this, editorID, editorDesc, this.modelElementContext, this.modelElement, editorInput.getProblemFeature()) : new MEEditorPage(this, editorID, editorDesc, this.modelElementContext, this.modelElement);
                this.addPage((IFormPage)this.mePage);
                configIn = configTemp;
            }
            catch (PartInitException e) {
                Activator.logException((Exception)((Object)e));
            }
        }
        List<IConfigurationElement> config = PageCandidate.getPages(configIn);
        for (IConfigurationElement e : config) {
            try {
                AbstractMEEditorPage newPage = (AbstractMEEditorPage)e.createExecutableExtension("class");
                FormPage createPage = newPage.createPage(this, this.editingDomain, this.modelElement);
                if (createPage == null) continue;
                this.addPage((IFormPage)createPage);
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, final IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof MEEditorInput)) {
            throw new PartInitException("MEEditor is only appliable for MEEditorInputs");
        }
        this.setInput(input);
        final MEEditorInput meInput = (MEEditorInput)input;
        this.modelElement = meInput.getModelElement();
        this.setPartName(new ShortLabelProvider().getText((Object)this.modelElement));
        this.setTitleImage(input.getImageDescriptor().createImage());
        this.modelElementContext = meInput.getModelElementContext();
        this.initializeEditingDomain();
        this.modelElementContextListener = new ModelElementContextListener(){

            public void onModelElementDeleted(EObject deleted) {
                if (MEEditor.this.modelElement == deleted) {
                    MEEditor.this.close(false);
                } else if (!MEEditor.this.modelElementContext.contains(MEEditor.this.modelElement)) {
                    MEEditor.this.close(false);
                }
            }

            public void onContextDeleted() {
                this.onModelElementDeleted(MEEditor.this.modelElement);
            }
        };
        this.modelElementContext.addModelElementContextListener(this.modelElementContextListener);
        this.modelElementChangeListener = new ModelElementChangeListener(this.modelElement){

            public void onChange(Notification notification) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MEEditor.this.updateIcon(input);
                        MEEditor.this.setPartName(new ShortLabelProvider().getText((Object)MEEditor.this.modelElement));
                        if (MEEditor.this.mePage != null) {
                            MEEditor.this.mePage.updateSectionTitle();
                            MEEditor.this.mePage.updateLiveValidation();
                        }
                        MEEditor.this.updateStatusMessage();
                    }
                });
            }
        };
        this.initStatusProvider();
        this.updateStatusMessage();
        this.labelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                MEEditor.this.updateIcon(meInput);
            }
        };
        meInput.getLabelProvider().addListener(this.labelProviderListener);
    }

    private void initStatusProvider() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.editor.statusmessage");
        ArrayList<IConfigurationElement> provider = new ArrayList<IConfigurationElement>();
        provider.addAll(Arrays.asList(configurationElements));
        int priority = 0;
        for (IConfigurationElement e : provider) {
            try {
                StatusMessageProvider statusMessageProvider = (StatusMessageProvider)e.createExecutableExtension("class");
                int newpriority = statusMessageProvider.canRender(this.modelElement);
                if (newpriority <= priority) continue;
                priority = newpriority;
                this.statusMessageProvider = statusMessageProvider;
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
        }
    }

    private void updateStatusMessage() {
        if (this.statusMessageProvider != null) {
            this.getEditorSite().getActionBars().getStatusLineManager().setMessage(this.statusMessageProvider.getMessage(this.modelElement));
        }
    }

    protected void initializeEditingDomain() {
        this.editingDomain = this.modelElementContext.getEditingDomain();
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        super.setFocus();
        if (this.mePage != null) {
            this.mePage.setFocus();
        }
        this.updateStatusMessage();
    }

    public void dispose() {
        this.modelElementChangeListener.remove();
        this.modelElementContext.removeModelElementContextListener(this.modelElementContextListener);
        ((MEEditorInput)this.getEditorInput()).getLabelProvider().removeListener(this.labelProviderListener);
        ((MEEditorInput)this.getEditorInput()).dispose();
        super.dispose();
    }

    private void updateIcon(IEditorInput input) {
        Image titleImage = input.getImageDescriptor().createImage();
        this.setTitleImage(titleImage);
        if (this.mePage != null) {
            try {
                this.mePage.getManagedForm().getForm().setImage(titleImage);
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    public ECPModelelementContext getModelElementContext() {
        return this.modelElementContext;
    }
}

