/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.jet.template;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.editors.templateEditor.AbstractTemplateEditor;
import org.eclipse.egf.pattern.ui.jet.Activator;
import org.eclipse.egf.pattern.ui.jet.editor.JetTextEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.internal.editor.JETEditorHelper;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetTemplateEditor
extends AbstractTemplateEditor {
    private String TEMPLATE_FILE_EXTENTION = ".jet";
    private List<Problem> problems = new ArrayList<Problem>();
    private Map<String, List<Problem>> methodProblems = new HashMap<String, List<Problem>>();
    private IFile templateFile;
    private static Map<String, List<Problem>> METHODPROBLEMS = new HashMap<String, List<Problem>>();

    protected void createPages() {
        Pattern pattern = this.getPattern();
        this.addPatternChangeAdapter(pattern);
        EList methods = pattern.getMethods();
        try {
            this.templateFile = this.setPublicTemplateEditor(pattern, methods, this.TEMPLATE_FILE_EXTENTION);
        }
        catch (Exception e) {
            Activator.getDefault();
            Activator.log(e);
        }
        this.initProblems();
        this.divideByMethods();
        int i = 0;
        while (i < methods.size()) {
            this.createPage((PatternMethod)methods.get(i));
            ++i;
        }
        String patternName = pattern.getName();
        this.setTitle(patternName);
    }

    void createPage(PatternMethod method) {
        try {
            JetTextEditor editor = new JetTextEditor(this.getPattern());
            this.addEditor((TextEditor)editor, method);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
        }
    }

    protected void initProblems() {
        IEditorPart editorPart = this.openEditor;
        JETTextEditor jetTextEditor = (JETTextEditor)editorPart;
        if (jetTextEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = jetTextEditor.getDocumentProvider();
        IEditorInput editorInput = jetTextEditor.getEditorInput();
        if (documentProvider == null || editorInput == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        List javaContentProblems = JETEditorHelper.evaluateProblems((JETTextEditor)jetTextEditor, (IDocument)document);
        this.problems.addAll(javaContentProblems);
    }

    protected void divideByMethods() {
        this.methodProblems.clear();
        METHODPROBLEMS.clear();
        for (String key : this.startPositions.keySet()) {
            Position position = (Position)this.startPositions.get(key);
            LinkedList<Problem> methodproblems = new LinkedList<Problem>();
            int startOffset = position.offset;
            int endOffset = position.offset + position.length;
            for (Problem problem : this.problems) {
                int offset = problem.getStart();
                if (startOffset == 0 && offset == -1) {
                    methodproblems.add(problem);
                }
                if (offset < startOffset || offset > endOffset) continue;
                problem = this.translateOffsetForProblem(problem, offset - startOffset);
                methodproblems.add(problem);
            }
            this.methodProblems.put(key, methodproblems);
        }
        METHODPROBLEMS = this.methodProblems;
    }

    private Problem translateOffsetForProblem(Problem problem, int newStart) {
        int colOffset = problem.getColOffset();
        int end = problem.getEnd();
        int id = problem.getId();
        int lineNumber = problem.getLineNumber();
        String message = problem.getMessage();
        Object[] messageArgs = problem.getMessageArgs();
        ProblemSeverity problemSeverity = problem.getProblemSeverity();
        if (this.templateFile == null) {
            return null;
        }
        URI locationURI = this.templateFile.getProject().getLocationURI();
        String string = this.templateFile.getProjectRelativePath().toString();
        Problem newProblem = new Problem(locationURI, string, problemSeverity, id, message, messageArgs, newStart, end, lineNumber, colOffset);
        return newProblem;
    }

    public static Map<String, List<Problem>> getMethodProblems() {
        return METHODPROBLEMS;
    }

    public IEditorPart getTemplateFileEditorPart() {
        return this.openEditor;
    }

    public IFile getTemplateFile() {
        return this.templateFile;
    }

    public void setFocus() {
        super.setFocus();
    }

    public void setActivePage(String methodId) {
        JetTextEditor javaTextEditor;
        if (methodId != null && !"".equals(methodId) && (javaTextEditor = (JetTextEditor)((Object)this.editorMap.get(methodId))) != null) {
            this.setActiveEditor((IEditorPart)javaTextEditor);
        }
    }

    protected void executeMethodEditorAdd(PatternMethod addMethod) {
        try {
            if (addMethod.getID() == null) {
                return;
            }
            this.setPatternFilePath(addMethod);
            JetTextEditor newEditor = new JetTextEditor(this.getPattern());
            this.addEditor((TextEditor)newEditor, addMethod);
            super.executeMethodEditorAdd(addMethod);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e);
        }
    }

    protected TextEditor createNewEditor() {
        try {
            JetTextEditor newEditor = new JetTextEditor(this.getPattern());
            return newEditor;
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e);
        }
        return null;
    }

    protected String getDelegateEditorID() {
        return "org.eclipse.jet.editor.JETEditor";
    }
}

