/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.contentassist;

import java.util.ArrayList;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jet.internal.editor.JETDocumentReader;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.contentassist.AbstractJETAssistProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public abstract class AbstractXMLTagsBasedAssistProcessor
extends AbstractJETAssistProcessor {
    private TreeSet keywordSet = new TreeSet();
    private TreeSet innerKeywordSet = new TreeSet();
    private TreeMap innerMap = new TreeMap();

    public AbstractXMLTagsBasedAssistProcessor(JETTextEditor editor) {
        super(editor);
        String[][] tagAttrs = this.getTagAttributes();
        int i = 0;
        while (i < tagAttrs.length) {
            this.keywordSet.add(tagAttrs[i][0]);
            ++i;
        }
        i = 0;
        while (i < tagAttrs.length) {
            TreeSet<String> innerSet = new TreeSet<String>();
            int j = 1;
            while (j < tagAttrs[i].length) {
                innerSet.add(tagAttrs[i][j]);
                this.innerKeywordSet.add(tagAttrs[i][j]);
                ++j;
            }
            this.innerMap.put(tagAttrs[i][0], innerSet);
            ++i;
        }
    }

    public abstract String[] getRootTags();

    public abstract String[][] getTagAttributes();

    public String[] getAllKeywords() {
        return this.keywordSet.toArray(new String[this.keywordSet.size()]);
    }

    public String[] getAllInnerKeywords() {
        return this.innerKeywordSet.toArray(new String[this.innerKeywordSet.size()]);
    }

    public String[] getInnerKeywordsFor(String key) {
        TreeSet set = (TreeSet)this.innerMap.get(key);
        if (set == null && key.length() == 0) {
            return this.getRootTags();
        }
        if (set != null) {
            return set.toArray(new String[set.size()]);
        }
        return new String[0];
    }

    private boolean prefixMatches(String prefix, String word) {
        prefix = prefix.toLowerCase();
        return word.startsWith(prefix);
    }

    public String[] getAllWordsWithPrefix(String prefix) {
        String[] all = this.getAllKeywords();
        return this.getMatched(prefix, all);
    }

    private String[] getMatched(String prefix, String[] all) {
        ArrayList<String> matched = new ArrayList<String>(10);
        int i = 0;
        while (i < all.length) {
            if (this.prefixMatches(prefix, all[i])) {
                matched.add(all[i]);
            }
            ++i;
        }
        return matched.toArray(new String[matched.size()]);
    }

    public String[] getTagsWithPrefix(String prefix) {
        return this.getMatched(prefix, this.getRootTags());
    }

    public String[] getNonTagsKeywordsWithPrefix(String key, String prefix) {
        return this.getMatched(prefix, this.getInnerKeywordsFor(key));
    }

    protected String[] getAllWords(char c, JETDocumentReader reader) {
        ArrayList<String> all = new ArrayList<String>(20);
        char currChar = c;
        currChar = this.trimBlanksBackward(reader, currChar);
        boolean done = false;
        while (!done) {
            Stack<Character> stack = new Stack<Character>();
            while (currChar != '\uffff' && !Character.isWhitespace(currChar)) {
                stack.push(new Character(currChar));
                currChar = reader.readBackward();
            }
            String s = new String();
            while (!stack.empty()) {
                s = String.valueOf(s) + ((Character)stack.pop()).toString();
            }
            int jspPt = s.indexOf("<%@");
            if (jspPt >= 0) {
                s = s.substring(jspPt + 3);
                done = true;
            }
            all.add(s);
            currChar = this.trimBlanksBackward(reader, currChar);
            if (currChar != '\uffff' && currChar != '@') continue;
            done = true;
        }
        return all.toArray(new String[all.size()]);
    }

    private char trimBlanksBackward(JETDocumentReader reader, char currChar) {
        while (currChar != '\uffff' && Character.isWhitespace(currChar)) {
            currChar = reader.readBackward();
        }
        return currChar;
    }

    protected abstract char getRootTagPrevChar();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] result;
        block4: {
            String[] allWords;
            char c;
            block5: {
                block3: {
                    IDocument doc = viewer.getDocument();
                    JETDocumentReader reader = new JETDocumentReader(doc, offset);
                    c = reader.readBackward();
                    result = null;
                    allWords = this.getAllWords(c, reader);
                    if (!Character.isSpaceChar(c)) break block3;
                    String[] nonTagWords = this.getInnerKeywordsFor(allWords[allWords.length - 1]);
                    result = new ICompletionProposal[nonTagWords.length];
                    int i = 0;
                    while (i < nonTagWords.length) {
                        result[i] = new CompletionProposal(nonTagWords[i], offset, 0, nonTagWords[i].length());
                        ++i;
                    }
                    break block4;
                }
                if (c != this.getRootTagPrevChar()) break block5;
                String[] words = this.getRootTags();
                result = new ICompletionProposal[words.length];
                int i = 0;
                while (i < words.length) {
                    result[i] = new CompletionProposal(words[i].substring(allWords[0].length()), offset, 0, words[i].length() - allWords[0].length(), null, words[i], null, null);
                    ++i;
                }
                break block4;
            }
            if (!Character.isLetter(c)) break block4;
            String[] words = allWords.length > 1 ? this.getNonTagsKeywordsWithPrefix(allWords[allWords.length - 1], allWords[0]) : this.getTagsWithPrefix(allWords[0]);
            result = new ICompletionProposal[words.length];
            int i = 0;
            while (i < words.length) {
                result[i] = new CompletionProposal(words[i].substring(allWords[0].length()), offset, 0, words[i].length() - allWords[0].length(), null, words[i], null, null);
                ++i;
            }
        }
        return result;
    }
}

