/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.adapter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalFoldersManager;

public class ClassPathSearchUtil {
    private static Logger logger;
    private static Map<String, List<Entry>> cache;

    static {
        cache = new HashMap<String, List<Entry>>();
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerCreator.createLogger(ClassPathSearchUtil.class);
        }
        return logger;
    }

    private static List<Entry> searchJar(String absoluteJarPath, String uri) throws IOException {
        ArrayList<Entry> results = new ArrayList<Entry>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile jar = new ZipFile(absoluteJarPath);){
                Enumeration<? extends ZipEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry el = entries.nextElement();
                    if (el == null || !el.getName().endsWith(".cssext")) continue;
                    Object elPath = el.getName().startsWith("/") ? el.getName() : "/" + el.getName();
                    results.add(new StringUriEntry("archive:" + uri + "!" + (String)elPath));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }

    private static void searchFolderRec(File file, String innerPath, String uri, List<Entry> result) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ClassPathSearchUtil.searchFolderRec(f, innerPath + "/" + f.getName(), uri, result);
                ++n2;
            }
        } else if (file.getName().endsWith(".cssext")) {
            result.add(new StringUriEntry(uri + innerPath));
        }
    }

    private static List<Entry> searchFolder(String absolutePath, String uri) throws IOException {
        ArrayList<Entry> results = new ArrayList<Entry>();
        ClassPathSearchUtil.searchFolderRec(new File(absolutePath), "", uri, results);
        return results;
    }

    public static List<Entry> checkJar(String absoluteJarPath, String uri) {
        List<Entry> results = cache.get(absoluteJarPath);
        if (results == null) {
            try {
                results = ClassPathSearchUtil.searchJar(absoluteJarPath, uri);
                cache.put(absoluteJarPath, results);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public static List<Entry> checkFolder(String absolutePath, String uri) {
        List<Entry> results = cache.get(absolutePath);
        if (results == null) {
            try {
                results = ClassPathSearchUtil.searchFolder(absolutePath, uri);
                cache.put(absolutePath, results);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public static List<Entry> checkResource(IResource r) {
        ClassPathSearchUtil.getLogger().debug("checkResource " + String.valueOf(r));
        if (r == null) {
            return Collections.emptyList();
        }
        SearchResourceVisitor v = new SearchResourceVisitor();
        try {
            r.accept((IResourceVisitor)v);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return v.getResult();
    }

    private static List<Entry> checkInternalLibrary(IFile file) {
        ClassPathSearchUtil.getLogger().debug("checkInternalJar " + String.valueOf(file));
        ArrayList<Entry> results = new ArrayList<Entry>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile jar = new ZipFile(file.getLocation().toFile());){
                Enumeration<? extends ZipEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry el = entries.nextElement();
                    if (el == null || !el.getName().endsWith(".cssext")) continue;
                    Object elPath = el.getName().startsWith("/") ? el.getName() : "/" + el.getName();
                    results.add(new IFileArchiveEntry(file, (String)elPath));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }

    private static List<Entry> checkInternalExpandedLibrary(IFolder folder) {
        return ClassPathSearchUtil.checkResource((IResource)folder);
    }

    private static List<Entry> checkExternalJar(File jarFile) {
        ClassPathSearchUtil.getLogger().debug("checkExternalJar " + String.valueOf(jarFile));
        ArrayList<Entry> results = new ArrayList<Entry>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile jar = new ZipFile(jarFile);){
                Enumeration<? extends ZipEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry el = entries.nextElement();
                    if (el == null || !el.getName().endsWith(".cssext")) continue;
                    Object elPath = el.getName().startsWith("/") ? el.getName() : "/" + el.getName();
                    results.add(new FileArchiveEntry(jarFile, (String)elPath));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }

    private static void searchFolderRec(File file, List<Entry> result) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ClassPathSearchUtil.searchFolderRec(f, result);
                ++n2;
            }
        } else if (file.getName().endsWith(".cssext")) {
            result.add(new FileEntry(file));
        }
    }

    private static List<Entry> checkExternalFolder(File folder) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        try {
            ClassPathSearchUtil.searchFolderRec(folder, results);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }

    private static List<Entry> checkSourceEntry(IWorkspaceRoot root, IClasspathEntry entry) {
        IResource resource = root.findMember(entry.getPath());
        return ClassPathSearchUtil.checkResource(resource);
    }

    private static List<Entry> checkLibraryEntry(IWorkspaceRoot root, IClasspathEntry entry) {
        ClassPathSearchUtil.getLogger().debug("checkLibraryEntry " + String.valueOf(entry.getPath()));
        IPath path = entry.getPath();
        switch (entry.getContentKind()) {
            case 1: {
                ClassPathSearchUtil.getLogger().debug(" is source");
                return ClassPathSearchUtil.checkSourceEntry(root, entry);
            }
            case 2: {
                ClassPathSearchUtil.getLogger().debug(" is binary");
                IResource member = root.findMember(path);
                if (member != null && member.exists()) {
                    ClassPathSearchUtil.getLogger().debug(" is workspace resource");
                    URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)false);
                    switch (member.getType()) {
                        case 1: {
                            return ClassPathSearchUtil.checkInternalLibrary((IFile)member);
                        }
                        case 2: {
                            return ClassPathSearchUtil.checkInternalExpandedLibrary((IFolder)member);
                        }
                    }
                    break;
                }
                ClassPathSearchUtil.getLogger().debug(" is external");
                IFolder jdtMappedFolder = ExternalFoldersManager.getExternalFoldersManager().getFolder(path);
                if (jdtMappedFolder != null) {
                    ClassPathSearchUtil.getLogger().debug(" but is mapped to internal by jdt");
                    return ClassPathSearchUtil.checkInternalExpandedLibrary(jdtMappedFolder);
                }
                File file = path.toFile();
                if (file.isDirectory()) {
                    return ClassPathSearchUtil.checkExternalFolder(file);
                }
                return ClassPathSearchUtil.checkExternalJar(file);
            }
        }
        return Collections.emptyList();
    }

    private static List<Entry> checkProjectEntry(IWorkspaceRoot root, IClasspathEntry entry) {
        ClassPathSearchUtil.getLogger().debug("checkProjectEntry " + String.valueOf(entry.getPath()));
        try {
            IPath path = entry.getPath();
            IProject p = (IProject)root.findMember(path);
            IJavaProject jp = JavaCore.create((IProject)p);
            IResource output = root.findMember(jp.getOutputLocation());
            if (output != null) {
                return ClassPathSearchUtil.checkResource(output);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public static List<Entry> checkEntry(IWorkspaceRoot root, IClasspathEntry entry) {
        ClassPathSearchUtil.getLogger().debug("checkEntry " + String.valueOf(entry.getPath()));
        switch (entry.getEntryKind()) {
            case 3: {
                return ClassPathSearchUtil.checkSourceEntry(root, entry);
            }
            case 1: {
                return ClassPathSearchUtil.checkLibraryEntry(root, entry);
            }
            case 2: {
                return ClassPathSearchUtil.checkProjectEntry(root, entry);
            }
        }
        System.err.println("could not handle entry " + String.valueOf(entry));
        return Collections.emptyList();
    }

    public static List<Entry> checkEntries(IWorkspaceRoot root, IClasspathEntry[] entries) {
        ArrayList<Entry> r = new ArrayList<Entry>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            ClassPathSearchUtil.getLogger().debug(" -> " + String.valueOf(entry));
            try {
                r.addAll(ClassPathSearchUtil.checkEntry(root, entry));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return r;
    }

    public static abstract class Entry {
        public abstract URI toURI();

        public String toString() {
            return this.toURI().toString();
        }
    }

    public static class FileArchiveEntry
    extends FileEntry {
        private final String archivePath;

        public FileArchiveEntry(File archiveFile, String archivePath) {
            super(archiveFile);
            this.archivePath = archivePath;
        }

        @Override
        public URI toURI() {
            URI uri = super.toURI();
            return URI.createURI((String)("archive:" + uri.toString() + "!" + this.archivePath));
        }
    }

    public static class FileEntry
    extends Entry {
        private final File f;

        public FileEntry(File f) {
            this.f = f;
        }

        @Override
        public URI toURI() {
            return URI.createURI((String)this.f.toURI().toString().replaceAll("\\\\", "/"));
        }
    }

    public static class IFileArchiveEntry
    extends IFileEntry {
        private final String archivePath;

        public IFileArchiveEntry(IFile archiveFile, String archivePath) {
            super(archiveFile);
            this.archivePath = archivePath;
        }

        @Override
        public URI toURI() {
            URI uri = super.toURI();
            return URI.createURI((String)("archive:" + uri.toString() + "!" + this.archivePath));
        }
    }

    public static class IFileEntry
    extends Entry {
        public final IFile f;

        public IFileEntry(IFile f) {
            this.f = f;
        }

        @Override
        public URI toURI() {
            IPath workspaceRelativePath = this.f.getFullPath();
            return URI.createPlatformResourceURI((String)workspaceRelativePath.toString().replace('\\', '/'), (boolean)true);
        }
    }

    static class SearchResourceVisitor
    implements IResourceVisitor {
        private List<Entry> result = new ArrayList<Entry>();

        SearchResourceVisitor() {
        }

        public List<Entry> getResult() {
            return this.result;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IContainer) {
                return true;
            }
            IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file != null && file.getName().endsWith(".cssext")) {
                this.result.add(new IFileEntry(file));
            }
            return false;
        }
    }

    public static class StringUriEntry
    extends Entry {
        public final String uri;

        public StringUriEntry(String uri) {
            this.uri = uri.replace('\\', '/');
        }

        @Override
        public URI toURI() {
            try {
                return URI.createURI((String)this.uri);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Issue with the following URI: " + this.uri, e);
            }
        }
    }

    public static class URIEntry
    extends Entry {
        private final URI uri;

        public URIEntry(URI uri) {
            this.uri = uri;
        }

        @Override
        public URI toURI() {
            return this.uri;
        }
    }
}

