/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fx.ide.css.cssDsl.AttributeSelector;
import org.eclipse.fx.ide.css.cssDsl.ClassSelector;
import org.eclipse.fx.ide.css.cssDsl.ColorTok;
import org.eclipse.fx.ide.css.cssDsl.CssSelector;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.ElementSelector;
import org.eclipse.fx.ide.css.cssDsl.FuncTok;
import org.eclipse.fx.ide.css.cssDsl.IdSelector;
import org.eclipse.fx.ide.css.cssDsl.IdentifierTok;
import org.eclipse.fx.ide.css.cssDsl.NumberTok;
import org.eclipse.fx.ide.css.cssDsl.PseudoClassFunction;
import org.eclipse.fx.ide.css.cssDsl.PseudoClassName;
import org.eclipse.fx.ide.css.cssDsl.SimpleSelectorForNegation;
import org.eclipse.fx.ide.css.cssDsl.StringTok;
import org.eclipse.fx.ide.css.cssDsl.SymbolTok;
import org.eclipse.fx.ide.css.cssDsl.UrlTok;
import org.eclipse.fx.ide.css.cssDsl.WSTok;
import org.eclipse.fx.ide.css.cssDsl.css_property;
import org.eclipse.fx.ide.css.cssDsl.ruleset;
import org.eclipse.fx.ide.css.cssDsl.selector;
import org.eclipse.fx.ide.css.cssDsl.simple_selector;
import org.eclipse.fx.ide.css.cssDsl.stylesheet;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class CssDslLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public CssDslLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String text(StringTok strTok) {
        if (strTok.getValue() != null) {
            return "\"" + strTok.getValue() + "\"";
        }
        return "null";
    }

    String text(ruleset value) {
        StringBuilder b = new StringBuilder();
        for (selector s : value.getSelectors()) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(this.text(s));
        }
        return b.toString();
    }

    String text(selector value) {
        StringBuilder b = new StringBuilder();
        for (simple_selector s : value.getSimpleselectors()) {
            b.append(this.text(s));
        }
        if (value.getSelector() != null) {
            if (value.getCombinator() != null) {
                b.append(" " + value.getCombinator());
            }
            b.append(" " + this.text(value.getSelector()));
        }
        String r = b.toString();
        return r;
    }

    String image(selector s) {
        return "selector_16x16.png";
    }

    String image(ruleset ele) {
        return "selector_16x16.png";
    }

    String image(css_property ele) {
        return "property_16x16.png";
    }

    String image(CssSelector cssSelector) {
        return "selector_16x16.png";
    }

    String text(IdentifierTok idTok) {
        return idTok.getName();
    }

    String text(PseudoClassFunction pseudoFunc) {
        StringBuilder b = new StringBuilder();
        if (pseudoFunc.isNot()) {
            b.append("not(");
            b.append(this.getText(pseudoFunc.getParamSelector()));
            b.append(")");
        } else {
            b.append(pseudoFunc.getName());
            b.append("(");
            for (CssTok next : pseudoFunc.getParams()) {
                b.append(this.getText(next));
            }
            b.append(")");
        }
        return b.toString();
    }

    String text(CssTok cssTok) {
        if (cssTok instanceof IdentifierTok) {
            return ((IdentifierTok)cssTok).getName();
        }
        if (cssTok instanceof NumberTok) {
            return String.valueOf(((NumberTok)cssTok).getVal());
        }
        if (cssTok instanceof SymbolTok) {
            return ((SymbolTok)cssTok).getSymbol();
        }
        if (cssTok instanceof WSTok) {
            return " ";
        }
        if (cssTok instanceof ColorTok) {
            return ((ColorTok)cssTok).getValue();
        }
        if (cssTok instanceof FuncTok) {
            FuncTok funcTok = (FuncTok)cssTok;
            StringBuilder func = new StringBuilder();
            for (CssTok next : funcTok.getParams()) {
                func.append(this.getText(next));
            }
            return this.getText(funcTok.getName()) + "(" + func.toString().trim() + ")";
        }
        if (cssTok instanceof UrlTok) {
            return "url(" + ((UrlTok)cssTok).getUrl().getUrl() + ")";
        }
        return cssTok.toString();
    }

    String text(CssSelector cssSelector) {
        if (cssSelector instanceof ElementSelector) {
            return ((ElementSelector)cssSelector).getName();
        }
        if (cssSelector instanceof ClassSelector) {
            return "." + ((ClassSelector)cssSelector).getName();
        }
        if (cssSelector instanceof IdSelector) {
            return "#" + ((IdSelector)cssSelector).getName();
        }
        if (cssSelector instanceof PseudoClassName) {
            return ":" + ((PseudoClassName)cssSelector).getName();
        }
        if (cssSelector instanceof PseudoClassFunction) {
            return ":" + this.text((PseudoClassFunction)cssSelector);
        }
        if (cssSelector instanceof AttributeSelector) {
            return "[" + this.text((AttributeSelector)cssSelector) + "]";
        }
        return cssSelector.toString();
    }

    String text(AttributeSelector s) {
        if (s.getOp() != null && s.getValue() != null) {
            return s.getName() + s.getOp() + s.getValue();
        }
        return s.getName();
    }

    String text(ElementSelector elementSelector) {
        return elementSelector.getName();
    }

    String text(ClassSelector classSelector) {
        return "." + classSelector.getName();
    }

    String text(IdSelector idSelector) {
        return "#" + idSelector.getName();
    }

    String text(SimpleSelectorForNegation value) {
        StringBuilder b = new StringBuilder();
        if (value.getElement() != null) {
            b.append(this.getText(value.getElement()));
        } else if (value.getUniversal() != null) {
            b.append("*");
        }
        for (CssSelector sub : value.getSubSelectors()) {
            b.append(this.getText(sub));
        }
        return b.toString();
    }

    String text(simple_selector value) {
        StringBuilder b = new StringBuilder();
        if (value.getElement() != null) {
            b.append(this.text(value.getElement()));
        } else if (value.getUniversal() != null) {
            b.append("*");
        }
        for (CssSelector sub : value.getSubSelectors()) {
            b.append(this.text(sub));
        }
        return b.toString();
    }

    String text(stylesheet value) {
        return "stylesheet";
    }
}

