/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl.generators;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.ide.rrobot.model.bundle.ProductFeature;
import org.eclipse.fx.ide.rrobot.model.bundle.ProductFile;
import org.eclipse.fx.ide.rrobot.model.bundle.ProductFileFeaturebase;
import org.eclipse.fx.ide.rrobot.model.bundle.ProductStartConfig;
import org.eclipse.fx.ide.rrobot.model.task.BooleanExpression;
import org.eclipse.fx.ide.rrobot.model.task.ExcludeableElementMixin;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProductGenerator
implements Generator<ProductFile> {
    public InputStream generate(ProductFile file, Map<String, Object> data) {
        byte[] _bytes = this.generateContent(file, data).toString().getBytes();
        return new ByteArrayInputStream(_bytes);
    }

    public CharSequence generateContent(ProductFile file, final Map<String, Object> data) {
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<?pde version=\"3.5\"?>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("<product name=\"");
        String _productName = file.getProductName();
        _builder.append(_productName);
        _builder.append("\" uid=\"");
        String _id = file.getId();
        _builder.append(_id);
        _builder.append("\" id=\"");
        String _id_1 = file.getId();
        _builder.append(_id_1);
        _builder.append("\" application=\"");
        String _application = file.getApplication();
        _builder.append(_application);
        _builder.append("\" version=\"");
        String _version = file.getVersion();
        _builder.append(_version);
        _builder.append("\" useFeatures=\"");
        _builder.append((Object)(file instanceof ProductFileFeaturebase));
        _builder.append("\" includeLaunchers=\"");
        boolean _isIncludeLaunchers = file.isIncludeLaunchers();
        _builder.append((Object)_isIncludeLaunchers);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<configIni use=\"default\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</configIni>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<launcherArgs>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<programArgs>");
        String _programArgs = file.getProgramArgs();
        _builder.append(_programArgs, "\t\t");
        _builder.append("</programArgs>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("<vmArgs>");
        String _vmArgs = file.getVmArgs();
        _builder.append(_vmArgs, "\t\t");
        _builder.append("</vmArgs>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</launcherArgs>");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<windowImages/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        if (file instanceof ProductFileFeaturebase) {
            _builder.append("\t");
            _builder.append("<features>");
            _builder.newLine();
            Functions.Function1<ProductFeature, Boolean> _function = new Functions.Function1<ProductFeature, Boolean>(){

                public Boolean apply(ProductFeature e) {
                    return ProductGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)((ProductFileFeaturebase)file).getFeatures(), (Functions.Function1)_function);
            for (ProductFeature pf : _filter) {
                boolean _notEquals;
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("<feature id=\"");
                String _id_2 = pf.getId();
                _builder.append(_id_2, "\t\t");
                _builder.append("\" ");
                String _version_1 = pf.getVersion();
                boolean bl = _notEquals = !Objects.equal((Object)_version_1, null);
                if (_notEquals) {
                    _builder.append("version=\"");
                    String _version_2 = pf.getVersion();
                    _builder.append(_version_2, "\t\t");
                    _builder.append("\"");
                }
                _builder.append("/>");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("</features>");
            _builder.newLine();
        }
        boolean bl = _not = !(_isEmpty = file.getStartconfigurations().isEmpty());
        if (_not) {
            _builder.append("\t");
            _builder.append("<configurations>");
            _builder.newLine();
            EList _startconfigurations = file.getStartconfigurations();
            for (ProductStartConfig c : _startconfigurations) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("<plugin id=\"");
                String _id_3 = c.getId();
                _builder.append(_id_3, "\t\t");
                _builder.append("\" autoStart=\"");
                boolean _isAutoStart = c.isAutoStart();
                _builder.append((Object)_isAutoStart, "\t\t");
                _builder.append("\" startLevel=\"");
                int _startLevel = c.getStartLevel();
                _builder.append((Object)_startLevel, "\t\t");
                _builder.append("\" />");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("</configurations>");
            _builder.newLine();
        }
        _builder.append("</product>");
        _builder.newLine();
        _builder.append("   ");
        _builder.newLine();
        return _builder;
    }

    public boolean excludeExpression(ExcludeableElementMixin mixin, Map<String, Object> data) {
        boolean _notEquals;
        BooleanExpression _excludeExpression = mixin.getExcludeExpression();
        boolean bl = _notEquals = !Objects.equal((Object)_excludeExpression, null);
        if (_notEquals) {
            boolean _execute = mixin.getExcludeExpression().execute(data);
            return !_execute;
        }
        return true;
    }
}

