/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import java.text.BreakIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.ui.controls.styledtext.ActionEvent;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;
import org.eclipse.fx.ui.controls.styledtext.behavior.HoverSupport;
import org.eclipse.fx.ui.controls.styledtext.behavior.TextPositionSupport;
import org.eclipse.fx.ui.controls.styledtext.events.TextPositionEvent;
import org.eclipse.fx.ui.controls.styledtext.skin.StyledTextSkin;
import org.eclipse.jdt.annotation.NonNull;

public class StyledTextBehavior {
    private TextPositionSupport textPositionSupport;
    private HoverSupport hoverSupport;
    private final StyledTextArea styledText;
    private KeyMapping keyMapping = new KeyMapping();
    private volatile boolean pressedInSelection = false;
    private volatile boolean dragMoveTextMode = false;
    private volatile boolean dragSelectionMode = false;
    private volatile int dragMoveTextOffset = -1;
    private volatile int dragMoveTextLength = -1;
    private int mousePressedOffset = -1;
    protected final StyledTextInputAction ACTION_NAVIGATE_TEXT_START = new StyledTextInputAction(ActionEvent.ActionType.TEXT_START, this::defaultNavigateTextStart);
    protected final KeyMapping.InputAction ACTION_NAVIGATE_TEXT_END = new StyledTextInputAction(ActionEvent.ActionType.TEXT_END, this::defaultNavigateTextEnd);
    protected final KeyMapping.InputAction ACTION_NAVIGATE_LINE_START = new StyledTextInputAction(ActionEvent.ActionType.LINE_START, this::defaultNavigateLineStart);
    protected final KeyMapping.InputAction ACTION_NAVIGATE_LINE_END = new StyledTextInputAction(ActionEvent.ActionType.LINE_END, this::defaultNavigateLineEnd);
    protected final KeyMapping.InputAction ACTION_NAVIGATE_WORD_NEXT = new StyledTextInputAction(ActionEvent.ActionType.WORD_NEXT, this::defaultNavigateWordNext);
    protected final KeyMapping.InputAction ACTION_NAVIGATE_WORD_PREVIOUS = new StyledTextInputAction(ActionEvent.ActionType.WORD_PREVIOUS, this::defaultNavigateWordPrevious);
    protected final KeyMapping.InputAction ACTION_SELECT_TEXT_START = new StyledTextInputAction(ActionEvent.ActionType.SELECT_TEXT_START, this::defaultSelectTextStart);
    protected final KeyMapping.InputAction ACTION_SELECT_TEXT_END = new StyledTextInputAction(ActionEvent.ActionType.SELECT_TEXT_END, this::defaultSelectTextEnd);
    protected final KeyMapping.InputAction ACTION_SELECT_LINE_START = new StyledTextInputAction(ActionEvent.ActionType.SELECT_LINE_START, this::defaultSelectLineStart);
    protected final KeyMapping.InputAction ACTION_SELECT_LINE_END = new StyledTextInputAction(ActionEvent.ActionType.SELECT_LINE_END, this::defaultSelectLineEnd);
    protected final KeyMapping.InputAction ACTION_SELECT_WORD_NEXT = new StyledTextInputAction(ActionEvent.ActionType.SELECT_WORD_NEXT, this::defaultSelectWordNext);
    protected final KeyMapping.InputAction ACTION_SELECT_WORD_PREVIOUS = new StyledTextInputAction(ActionEvent.ActionType.SELECT_WORD_PREVIOUS, this::defaultSelectWordPrevious);
    protected final KeyMapping.InputAction ACTION_SELECT_WORD = new StyledTextInputAction(ActionEvent.ActionType.SELECT_WORD, this::defaultSelectWord);
    protected final KeyMapping.InputAction ACTION_SELECT_LINE = new StyledTextInputAction(this::defaultSelectLine);
    protected final KeyMapping.InputAction ACTION_DELETE_LINE = new StyledTextInputAction(this::defaultDeleteLine);
    protected final KeyMapping.InputAction ACTION_DELETE_WORD_NEXT = new StyledTextInputAction(ActionEvent.ActionType.DELETE_WORD_NEXT, this::defaultDeleteWordNext);
    protected final KeyMapping.InputAction ACTION_DELETE_WORD_PREVIOUS = new StyledTextInputAction(ActionEvent.ActionType.DELETE_WORD_PREVIOUS, this::defaultDeleteWordPrevious);
    protected final KeyMapping.InputAction ACTION_MOVE_LINES_UP = new StyledTextInputAction(this::defaultMoveLinesUp);
    protected final KeyMapping.InputAction ACTION_MOVE_LINES_DOWN = new StyledTextInputAction(this::defaultMoveLinesDown);
    protected final KeyMapping.InputAction ACTION_NEW_LINE = new StyledTextInputAction(ActionEvent.ActionType.NEW_LINE, this::defaultNewLine);
    protected final KeyMapping.InputAction ACTION_SELECT_ALL = new StyledTextInputAction(this::defaultSelectAll);
    protected final KeyMapping.InputAction ACTION_COPY = new StyledTextInputAction(this::defaultCopy);
    protected final KeyMapping.InputAction ACTION_PASTE = new StyledTextInputAction(this::defaultPaste);
    protected final KeyMapping.InputAction ACTION_CUT = new StyledTextInputAction(this::defaultCut);
    protected final KeyMapping.InputAction ACTION_DELETE = new StyledTextInputAction(this::defaultDelete);
    protected final KeyMapping.InputAction ACTION_BACKSPACE = new StyledTextInputAction(this::defaultBackspace);
    protected final KeyMapping.InputAction ACTION_INDENT = new StyledTextInputAction(ActionEvent.ActionType.INDENT, this::defaultIndent);
    protected final StyledTextInputAction ACTION_OUTDENT = new StyledTextInputAction(ActionEvent.ActionType.OUTDENT, this::defaultOutdent);
    protected final StyledTextInputAction ACTION_MOVE_UP = new StyledTextInputAction(() -> this.defaultUp(false));
    protected final StyledTextInputAction ACTION_SELECT_UP = new StyledTextInputAction(() -> this.defaultUp(true));
    protected final StyledTextInputAction ACTION_MOVE_DOWN = new StyledTextInputAction(() -> this.defaultDown(false));
    protected final StyledTextInputAction ACTION_SELECT_DOWN = new StyledTextInputAction(() -> this.defaultDown(true));
    protected final StyledTextInputAction ACTION_MOVE_LEFT = new StyledTextInputAction(() -> this.defaultLeft(false));
    protected final StyledTextInputAction ACTION_SELECT_LEFT = new StyledTextInputAction(() -> this.defaultLeft(true));
    protected final StyledTextInputAction ACTION_MOVE_RIGHT = new StyledTextInputAction(() -> this.defaultRight(false));
    protected final StyledTextInputAction ACTION_SELECT_RIGHT = new StyledTextInputAction(() -> this.defaultRight(true));
    protected final StyledTextInputAction ACTION_SCROLL_LINE_UP = new StyledTextInputAction(this::defaultScrollLineUp);
    protected final StyledTextInputAction ACTION_SCROLL_LINE_DOWN = new StyledTextInputAction(this::defaultScrollLineDown);

    public StyledTextBehavior(StyledTextArea styledText) {
        this.styledText = styledText;
        styledText.addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyPressed);
        styledText.addEventHandler(KeyEvent.KEY_TYPED, this::onKeyTyped);
        styledText.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        this.initKeymapping(this.keyMapping);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_PRESSED, this::onTextPositionPressed);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_CLICKED, this::onTextPositionClicked);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_RELEASED, this::onTextPositionReleased);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_DRAGGED, this::onTextPositionDragged);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_DRAG_DETECTED, this::onTextPositionDragDetected);
    }

    public void installContentListeners(javafx.scene.layout.Region contentNode) {
        this.textPositionSupport = TextPositionSupport.install(contentNode, this.getControl());
        this.hoverSupport = HoverSupport.install(contentNode);
    }

    static int computeStart(StyledTextContent content, int firstLine) {
        return content.getOffsetAtLine(firstLine);
    }

    static int computeEnd(StyledTextContent content, int lastLine) {
        int endIndex = content.getLineCount() > lastLine + 1 ? content.getOffsetAtLine(lastLine + 1) : content.getOffsetAtLine(lastLine) + content.getLine(lastLine).length();
        return endIndex;
    }

    static int computeLength(StyledTextContent content, int firstLine, int lastLine) {
        return StyledTextBehavior.computeEnd(content, lastLine) - StyledTextBehavior.computeStart(content, firstLine);
    }

    private @NonNull LineRegion getLineRegion(TextSelection selection) {
        int firstLine = this.getControl().getLineAtOffset(selection.offset);
        int lastLine = this.getControl().getLineAtOffset(selection.offset + selection.length);
        int lastLineBegin = this.getControl().getOffsetAtLine(lastLine);
        if (lastLineBegin == selection.offset + selection.length) {
            --lastLine;
        }
        lastLine = Math.min(this.getControl().getContent().getLineCount() - 1, lastLine);
        lastLine = Math.max(firstLine, lastLine);
        return new LineRegion(firstLine, lastLine);
    }

    private static boolean isInRange(int offset, int rangeOffset, int rangeLength) {
        return offset >= rangeOffset && offset < rangeOffset + rangeLength;
    }

    private boolean isInSelection(int offset) {
        int selOffset = this.getControl().getSelection().offset;
        int selLength = this.getControl().getSelection().length;
        boolean r = selLength > 0 && StyledTextBehavior.isInRange(offset, selOffset, selLength);
        return r;
    }

    private void onKeyPressed(KeyEvent event) {
        VerifyEvent evt = new VerifyEvent((Object)this.getControl(), (EventTarget)this.getControl(), event);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
        if (Util.isMacOS() && (event.getCode() == KeyCode.ALT || event.isAltDown())) {
            event.consume();
        }
        if (evt.isConsumed()) {
            event.consume();
            return;
        }
        Optional<KeyMapping.InputAction> keyAction = this.keyMapping.get(event);
        keyAction.ifPresent(a -> {
            a.run();
            event.consume();
        });
    }

    private void onKeyTyped(KeyEvent event) {
        if (this.getControl().getEditable()) {
            String character = event.getCharacter();
            if (character.length() == 0) {
                return;
            }
            if ((event.isControlDown() || event.isAltDown() || Util.isMacOS() && event.isMetaDown()) && (!event.isControlDown() && !Util.isMacOS() || !event.isAltDown())) {
                return;
            }
            if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f' && !event.isMetaDown()) {
                this.getControl().insert(character);
            }
        }
    }

    private void onTextPositionDragDetected(TextPositionEvent event) {
        if (this.pressedInSelection) {
            this.dragMoveTextMode = true;
            this.dragMoveTextOffset = this.getControl().getSelection().offset;
            this.dragMoveTextLength = this.getControl().getSelection().length;
        } else {
            this.dragSelectionMode = true;
        }
    }

    private void onTextPositionDragged(TextPositionEvent event) {
        if (this.dragSelectionMode) {
            this.moveCaretAbsolute(event.getOffset(), true);
            event.consume();
        } else if (this.dragMoveTextMode) {
            event.consume();
        }
    }

    private void onTextPositionReleased(TextPositionEvent event) {
        if (this.dragSelectionMode) {
            this.dragSelectionMode = false;
            event.consume();
        } else if (this.dragMoveTextMode) {
            int targetOffset = event.getOffset();
            if (StyledTextBehavior.isInRange(targetOffset, this.dragMoveTextOffset, this.dragMoveTextLength)) {
                targetOffset = this.dragMoveTextOffset;
            } else if (targetOffset >= this.dragMoveTextOffset + this.dragMoveTextLength) {
                targetOffset -= this.dragMoveTextLength;
            }
            @NonNull String text = this.getControl().getContent().getTextRange(this.dragMoveTextOffset, this.dragMoveTextLength);
            this.getControl().getContent().replaceTextRange(this.dragMoveTextOffset, this.dragMoveTextLength, "");
            this.getControl().getContent().replaceTextRange(targetOffset, 0, text);
            this.moveCaretAbsolute(targetOffset + text.length());
            this.dragMoveTextMode = false;
            event.consume();
        } else if (this.pressedInSelection) {
            this.moveCaretAbsolute(this.mousePressedOffset, event.isShiftDown());
            event.consume();
        }
        this.pressedInSelection = false;
    }

    private void onTextPositionPressed(TextPositionEvent event) {
        this.mousePressedOffset = event.getOffset();
        if (this.isInSelection(this.mousePressedOffset)) {
            this.pressedInSelection = true;
            event.consume();
        } else {
            this.moveCaretAbsolute(this.mousePressedOffset, event.isShiftDown());
            event.consume();
        }
    }

    private void onTextPositionClicked(TextPositionEvent event) {
        if (event.isStillSincePress()) {
            if (event.getClickCount() == 2 && event.getButton() == MouseButton.PRIMARY) {
                this.ACTION_SELECT_WORD.run();
                event.consume();
            }
            if (event.getClickCount() == 3 && event.getButton() == MouseButton.PRIMARY) {
                this.ACTION_SELECT_LINE.run();
                event.consume();
            }
        }
    }

    protected StyledTextArea getControl() {
        return this.styledText;
    }

    private void onMousePressed(MouseEvent event) {
        this.getControl().requestFocus();
    }

    private int computeCurrentLineNumber() {
        int offset = this.getControl().getCaretOffset();
        return this.getControl().getLineAtOffset(offset);
    }

    private int computeCurrentLineStartOffset() {
        int lineNumber = this.computeCurrentLineNumber();
        return this.getControl().getOffsetAtLine(lineNumber);
    }

    protected void defaultNavigateTextStart() {
        this.getControl().setCaretOffset(0);
    }

    protected void defaultNavigateTextEnd() {
        this.getControl().setCaretOffset(this.getControl().getContent().getCharCount());
    }

    protected void defaultNavigateLineStart() {
        this.moveCaretAbsolute(this.computeCurrentLineStartOffset());
    }

    protected void defaultNavigateLineEnd() {
        int caretLine = this.computeCurrentLineNumber();
        this.moveCaretAbsolute(this.getControl().getContent().getOffsetAtLine(caretLine) + this.getControl().getContent().getLine(caretLine).length());
    }

    protected void defaultNavigateWordNext() {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(new StringCharacterIterator(this.getControl().getContent().getTextRange(0, this.getControl().getContent().getCharCount())));
        int following = wordInstance.following(this.getControl().getCaretOffset());
        if (following != -1) {
            this.moveCaretAbsolute(following);
        }
    }

    protected void defaultNavigateWordPrevious() {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(new StringCharacterIterator(this.getControl().getContent().getTextRange(0, this.getControl().getContent().getCharCount())));
        int previous = wordInstance.preceding(this.getControl().getCaretOffset());
        if (previous != -1) {
            this.moveCaretAbsolute(previous);
        }
    }

    protected void defaultSelectTextStart() {
        this.moveCaretAbsolute(0, true);
    }

    protected void defaultSelectTextEnd() {
        this.moveCaretAbsolute(this.getControl().getCharCount(), true);
    }

    protected void defaultSelectLineStart() {
        this.moveCaretAbsolute(this.computeCurrentLineStartOffset(), true);
    }

    protected void defaultSelectLineEnd() {
        int caretLine = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
        int end = this.getControl().getContent().getOffsetAtLine(caretLine) + this.getControl().getContent().getLine(caretLine).length();
        this.moveCaretAbsolute(end, true);
    }

    protected void defaultSelectWordNext() {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(new StringCharacterIterator(this.getControl().getContent().getTextRange(0, this.getControl().getContent().getCharCount())));
        int following = wordInstance.following(this.getControl().getCaretOffset());
        if (following != -1) {
            this.moveCaretAbsolute(following, true);
        }
    }

    protected void defaultSelectWordPrevious() {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(new StringCharacterIterator(this.getControl().getContent().getTextRange(0, this.getControl().getContent().getCharCount())));
        int previous = wordInstance.preceding(this.getControl().getCaretOffset());
        if (previous != -1) {
            this.moveCaretAbsolute(previous, true);
        }
    }

    protected void defaultSelectWord() {
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(new StringCharacterIterator(this.getControl().getContent().getTextRange(0, this.getControl().getContent().getCharCount())));
        int previous = wordInstance.preceding(this.getControl().getCaretOffset());
        int next = wordInstance.following(this.getControl().getCaretOffset());
        if (previous != -1 && next != -1) {
            this.moveCaretAbsolute(previous);
            this.moveCaretAbsolute(next, true);
        }
    }

    protected void defaultSelectLine() {
        @NonNull LineRegion lineRegion = this.getLineRegion(this.getControl().getSelection());
        lineRegion.selectWithCaretAtEnd();
    }

    protected void defaultDeleteLine() {
        LineRegion lineRegion = this.getLineRegion(this.getControl().getSelection());
        lineRegion.replace("");
        this.moveCaretAbsolute(lineRegion.start);
    }

    protected void defaultDeleteWordNext() {
        int offset = this.getControl().getCaretOffset();
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(new StringCharacterIterator(this.getControl().getContent().getTextRange(0, this.getControl().getContent().getCharCount())));
        int following = wordInstance.following(this.getControl().getCaretOffset());
        if (following != -1) {
            this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), following - offset, "");
        }
    }

    protected void defaultDeleteWordPrevious() {
        int offset = this.getControl().getCaretOffset();
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(new StringCharacterIterator(this.getControl().getContent().getTextRange(0, this.getControl().getContent().getCharCount())));
        int previous = wordInstance.preceding(this.getControl().getCaretOffset());
        if (previous != -1) {
            this.getControl().setCaretOffset(previous);
            this.getControl().getContent().replaceTextRange(previous, offset - previous, "");
        }
    }

    protected void defaultMoveLinesUp() {
        LineRegion moveTarget = this.getLineRegion(this.getControl().getSelection());
        if (moveTarget.firstLine > 0) {
            LineRegion above = new LineRegion(moveTarget.firstLine - 1);
            LineRegion all = new LineRegion(above.firstLine, moveTarget.lastLine);
            String aboveText = above.read();
            String moveTargetText = moveTarget.read();
            if (moveTarget.lastLine + 1 == this.getControl().getContent().getLineCount()) {
                moveTargetText = String.valueOf(moveTargetText) + this.getControl().getLineSeparator().getValue();
                aboveText = aboveText.replaceFirst("\r?\n$", "");
            }
            all.replace(String.valueOf(moveTargetText) + aboveText);
            new LineRegion(moveTarget.firstLine - 1, moveTarget.lastLine - 1).selectWithCaretAtStart();
        }
    }

    protected void defaultMoveLinesDown() {
        LineRegion moveTarget = this.getLineRegion(this.getControl().getSelection());
        if (moveTarget.lastLine + 1 < this.getControl().getContent().getLineCount()) {
            LineRegion below = new LineRegion(moveTarget.lastLine + 1);
            LineRegion all = new LineRegion(moveTarget.firstLine, below.lastLine);
            String belowText = below.read();
            String moveTargetText = moveTarget.read();
            if (below.lastLine + 1 == this.getControl().getContent().getLineCount()) {
                belowText = String.valueOf(belowText) + this.getControl().getLineSeparator().getValue();
                moveTargetText = moveTargetText.replaceFirst("\r?\n$", "");
            }
            all.replace(String.valueOf(belowText) + moveTargetText);
            new LineRegion(moveTarget.firstLine + 1, moveTarget.lastLine + 1).selectWithCaretAtStart();
        }
    }

    protected void defaultNewLine() {
        int offset = this.getControl().getCaretOffset();
        int line = this.getControl().getContent().getLineAtOffset(offset);
        String lineContent = this.getControl().getContent().getLine(line);
        char[] chars = lineContent.toCharArray();
        String prefix = "";
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != ' ' && chars[i] != '\t') break;
            prefix = String.valueOf(prefix) + chars[i];
            ++i;
        }
        this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), 0, String.valueOf(this.getControl().getLineSeparator().getValue()) + prefix);
        this.getControl().setCaretOffset(offset + this.getControl().getLineSeparator().getValue().length() + prefix.length());
    }

    protected void defaultSelectAll() {
        int length = this.getControl().getContent().getCharCount();
        this.getControl().setSelectionRange(0, length);
    }

    protected void defaultCopy() {
        this.getControl().copy();
    }

    protected void defaultPaste() {
        if (this.getControl().getEditable()) {
            this.getControl().paste();
        }
    }

    protected void defaultCut() {
        if (this.getControl().getEditable()) {
            this.getControl().cut();
        }
    }

    protected void defaultDelete() {
        int offset = this.getControl().getCaretOffset();
        TextSelection selection = this.getControl().getSelection();
        if (selection.length > 0) {
            this.getControl().getContent().replaceTextRange(selection.offset, selection.length, "");
            this.getControl().setCaretOffset(selection.offset);
        } else {
            this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), 1, "");
            this.getControl().setCaretOffset(offset);
        }
    }

    protected void defaultBackspace() {
        int offset = this.getControl().getCaretOffset();
        TextSelection selection = this.getControl().getSelection();
        if (selection.length > 0) {
            this.getControl().getContent().replaceTextRange(selection.offset, selection.length, "");
            this.getControl().setCaretOffset(selection.offset);
        } else {
            this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset() - 1, 1, "");
            this.getControl().setCaretOffset(offset - 1);
        }
    }

    private boolean isMultilineSelection() {
        return this.getControl().getLineAtOffset(this.getControl().getSelection().offset) != this.getControl().getLineAtOffset(this.getControl().getSelection().offset + this.getControl().getSelection().length);
    }

    protected void defaultIndent() {
        if (this.isMultilineSelection()) {
            String allContent = this.getControl().getContent().getTextRange(0, this.getControl().getCharCount());
            StringBuffer dataBuffer = new StringBuffer(allContent);
            int caret = this.getControl().getCaretOffset();
            int selectionOffset = this.getControl().getSelection().offset;
            int selectionLength = this.getControl().getSelection().length;
            int firstLine = this.getControl().getLineAtOffset(selectionOffset);
            int lastLine = this.getControl().getLineAtOffset(selectionOffset + selectionLength);
            if (this.getControl().getOffsetAtLine(lastLine) < selectionOffset + selectionLength) {
                ++lastLine;
            }
            int added = 0;
            int firstLineDelta = 0;
            int lineNumber = firstLine;
            while (lineNumber < lastLine) {
                int lineStart = this.getControl().getOffsetAtLine(lineNumber) + added;
                dataBuffer.replace(lineStart, lineStart + 0, "\t");
                ++added;
                if (lineNumber == firstLine && selectionOffset > lineStart) {
                    firstLineDelta = 1;
                }
                ++lineNumber;
            }
            String data = dataBuffer.toString();
            this.getControl().getContent().setText(data == null ? "" : data);
            this.getControl().setCaretOffset(caret + added);
            this.getControl().setSelectionRange(selectionOffset + firstLineDelta, selectionLength + added - firstLineDelta);
        }
    }

    protected void defaultOutdent() {
        String allContent = this.getControl().getContent().getTextRange(0, this.getControl().getCharCount());
        StringBuffer dataBuffer = new StringBuffer(allContent);
        int caret = this.getControl().getCaretOffset();
        int selectionOffset = this.getControl().getSelection().offset;
        int selectionLength = this.getControl().getSelection().length;
        int firstLine = this.getControl().getLineAtOffset(selectionOffset);
        int lastLine = this.getControl().getLineAtOffset(selectionOffset + selectionLength);
        if (this.getControl().getOffsetAtLine(lastLine) < selectionOffset + selectionLength) {
            ++lastLine;
        }
        int firstLineDelta = 0;
        int lineNumber = firstLine;
        while (lineNumber < lastLine) {
            int lineStart = this.getControl().getOffsetAtLine(lineNumber);
            if (dataBuffer.charAt(lineStart) != '\t') {
                return;
            }
            if (lineNumber == firstLine && selectionOffset > lineStart) {
                firstLineDelta = 1;
            }
            ++lineNumber;
        }
        int removed = 0;
        int lineNumber2 = lastLine - 1;
        while (lineNumber2 >= firstLine) {
            int lineStart = this.getControl().getOffsetAtLine(lineNumber2);
            dataBuffer.replace(lineStart, lineStart + 1, "");
            ++removed;
            --lineNumber2;
        }
        String data = dataBuffer.toString();
        this.getControl().getContent().setText(data == null ? "" : data);
        this.getControl().setCaretOffset(caret - removed);
        this.getControl().setSelectionRange(selectionOffset - firstLineDelta, selectionLength - removed + firstLineDelta);
    }

    protected void defaultUp(boolean select) {
        int currentRowIndex = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
        int offset = this.getControl().getCaretOffset();
        int rowIndex = currentRowIndex;
        if (rowIndex == 0) {
            return;
        }
        int colIdx = offset - this.getControl().getContent().getOffsetAtLine(rowIndex);
        int lineOffset = this.getControl().getContent().getOffsetAtLine(--rowIndex);
        int newCaretPosition = lineOffset + colIdx;
        int maxPosition = lineOffset + this.getControl().getContent().getLine(rowIndex).length();
        this.moveCaretAbsolute(Math.min(newCaretPosition, maxPosition), select);
    }

    protected void defaultDown(boolean select) {
        int currentRowIndex = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
        int offset = this.getControl().getCaretOffset();
        int rowIndex = currentRowIndex;
        if (rowIndex + 1 == this.getControl().getContent().getLineCount()) {
            return;
        }
        int colIdx = offset - this.getControl().getContent().getOffsetAtLine(rowIndex);
        int lineOffset = this.getControl().getContent().getOffsetAtLine(++rowIndex);
        int newCaretPosition = lineOffset + colIdx;
        int maxPosition = lineOffset + this.getControl().getContent().getLine(rowIndex).length();
        this.moveCaretAbsolute(Math.min(newCaretPosition, maxPosition), select);
    }

    protected void defaultLeft(boolean select) {
        this.moveCaretRelative(-1, select);
    }

    protected void defaultRight(boolean select) {
        this.moveCaretRelative(1, select);
    }

    protected void defaultScrollLineUp() {
        ((StyledTextSkin)this.getControl().getSkin()).scrollLineUp();
    }

    protected void defaultScrollLineDown() {
        ((StyledTextSkin)this.getControl().getSkin()).scrollLineDown();
    }

    void moveCaretAbsolute(int absoluteOffset) {
        int offset = Math.max(0, absoluteOffset);
        offset = Math.min(this.getControl().getCharCount(), offset);
        this.getControl().setCaretOffset(offset);
    }

    private void moveCaretAbsolute(int absoluteOffset, boolean select) {
        int offset = Math.max(0, absoluteOffset);
        offset = Math.min(this.getControl().getCharCount(), offset);
        this.getControl().impl_setCaretOffset(offset, select);
    }

    private void moveCaretRelative(int deltaOffset, boolean select) {
        int offset = this.getControl().getCaretOffset() + deltaOffset;
        this.moveCaretAbsolute(offset, select);
    }

    protected void initKeymapping(KeyMapping keyMapping) {
        if (Util.isMacOS()) {
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, KeyMapping.MetaKey.MetaKey), this.ACTION_NAVIGATE_LINE_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, KeyMapping.MetaKey.MetaKey), this.ACTION_NAVIGATE_LINE_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.UP, KeyMapping.MetaKey.MetaKey), this.ACTION_NAVIGATE_TEXT_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DOWN, KeyMapping.MetaKey.MetaKey), this.ACTION_NAVIGATE_TEXT_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, KeyMapping.MetaKey.AltKey), this.ACTION_NAVIGATE_WORD_NEXT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, KeyMapping.MetaKey.AltKey), this.ACTION_NAVIGATE_WORD_PREVIOUS);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, KeyMapping.MetaKey.MetaKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_LINE_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, KeyMapping.MetaKey.MetaKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_LINE_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.UP, KeyMapping.MetaKey.MetaKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_TEXT_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DOWN, KeyMapping.MetaKey.MetaKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_TEXT_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, KeyMapping.MetaKey.AltKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_WORD_NEXT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, KeyMapping.MetaKey.AltKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_WORD_PREVIOUS);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DELETE, KeyMapping.MetaKey.AltKey), this.ACTION_DELETE_WORD_NEXT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.BACK_SPACE, KeyMapping.MetaKey.AltKey), this.ACTION_DELETE_WORD_PREVIOUS);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.D, KeyMapping.MetaKey.MetaKey), this.ACTION_DELETE_LINE);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.C, KeyMapping.MetaKey.MetaKey), this.ACTION_COPY);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.V, KeyMapping.MetaKey.MetaKey), this.ACTION_PASTE);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.X, KeyMapping.MetaKey.MetaKey), this.ACTION_CUT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.A, KeyMapping.MetaKey.MetaKey), this.ACTION_SELECT_ALL);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.D, KeyMapping.MetaKey.MetaKey), this.ACTION_DELETE_LINE);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.UP, KeyMapping.MetaKey.AltKey), this.ACTION_MOVE_LINES_UP);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DOWN, KeyMapping.MetaKey.AltKey), this.ACTION_MOVE_LINES_DOWN);
        } else {
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, KeyMapping.MetaKey.ControlKey), this.ACTION_NAVIGATE_WORD_NEXT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, KeyMapping.MetaKey.ControlKey), this.ACTION_NAVIGATE_WORD_PREVIOUS);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, KeyMapping.MetaKey.ShiftKey, KeyMapping.MetaKey.ControlKey), this.ACTION_SELECT_WORD_NEXT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, KeyMapping.MetaKey.ShiftKey, KeyMapping.MetaKey.ControlKey), this.ACTION_SELECT_WORD_PREVIOUS);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.HOME, new KeyMapping.MetaKey[0]), this.ACTION_NAVIGATE_LINE_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.HOME, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_LINE_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.HOME, KeyMapping.MetaKey.ControlKey), this.ACTION_NAVIGATE_TEXT_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.HOME, KeyMapping.MetaKey.ControlKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_TEXT_START);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.END, new KeyMapping.MetaKey[0]), this.ACTION_NAVIGATE_LINE_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.END, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_LINE_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.END, KeyMapping.MetaKey.ControlKey), this.ACTION_NAVIGATE_TEXT_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.END, KeyMapping.MetaKey.ControlKey, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_TEXT_END);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DELETE, KeyMapping.MetaKey.ControlKey), this.ACTION_DELETE_WORD_NEXT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.BACK_SPACE, KeyMapping.MetaKey.ControlKey), this.ACTION_DELETE_WORD_PREVIOUS);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.C, KeyMapping.MetaKey.ControlKey), this.ACTION_COPY);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.V, KeyMapping.MetaKey.ControlKey), this.ACTION_PASTE);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.X, KeyMapping.MetaKey.ControlKey), this.ACTION_CUT);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.A, KeyMapping.MetaKey.ControlKey), this.ACTION_SELECT_ALL);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.UP, KeyMapping.MetaKey.ControlKey), this.ACTION_SCROLL_LINE_UP);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DOWN, KeyMapping.MetaKey.ControlKey), this.ACTION_SCROLL_LINE_DOWN);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.D, KeyMapping.MetaKey.ControlKey), this.ACTION_DELETE_LINE);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.UP, KeyMapping.MetaKey.AltKey), this.ACTION_MOVE_LINES_UP);
            keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DOWN, KeyMapping.MetaKey.AltKey), this.ACTION_MOVE_LINES_DOWN);
        }
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.TAB, new KeyMapping.MetaKey[0]), this.ACTION_INDENT, this::isMultilineSelection);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.TAB, KeyMapping.MetaKey.ShiftKey), this.ACTION_OUTDENT);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DELETE, new KeyMapping.MetaKey[0]), this.ACTION_DELETE);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.BACK_SPACE, new KeyMapping.MetaKey[0]), this.ACTION_BACKSPACE);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.ENTER, new KeyMapping.MetaKey[0]), this.ACTION_NEW_LINE);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.UP, new KeyMapping.MetaKey[0]), this.ACTION_MOVE_UP);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DOWN, new KeyMapping.MetaKey[0]), this.ACTION_MOVE_DOWN);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, new KeyMapping.MetaKey[0]), this.ACTION_MOVE_LEFT);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, new KeyMapping.MetaKey[0]), this.ACTION_MOVE_RIGHT);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.UP, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_UP);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.DOWN, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_DOWN);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.LEFT, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_LEFT);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.RIGHT, KeyMapping.MetaKey.ShiftKey), this.ACTION_SELECT_RIGHT);
        keyMapping.mapKey(new KeyMapping.KeyCombo(KeyCode.TAB, new KeyMapping.MetaKey[0]), () -> this.getControl().insert("\t"));
    }

    protected static class KeyMapping {
        private Map<KeyCombo, List<Mapping>> comboMapping = new HashMap<KeyCombo, List<Mapping>>();

        protected KeyMapping() {
        }

        public void mapKey(KeyCombo combo, InputAction action) {
            List<Mapping> list = this.comboMapping.get(combo);
            if (list == null) {
                list = new ArrayList<Mapping>();
                this.comboMapping.put(combo, list);
            }
            list.add(new SimpleMapping(() -> true, action));
        }

        public void mapKey(KeyCombo combo, InputAction action, Supplier<Boolean> condition) {
            List<Mapping> list = this.comboMapping.get(combo);
            if (list == null) {
                list = new ArrayList<Mapping>();
                this.comboMapping.put(combo, list);
            }
            list.add(new SimpleMapping(condition, action));
        }

        public Optional<InputAction> get(KeyCombo combo) {
            List list = this.comboMapping.getOrDefault(combo, Collections.emptyList());
            return list.stream().filter(m -> m.getCondition().get()).findFirst().map(m -> m.getAction());
        }

        public Optional<InputAction> get(KeyEvent event) {
            return this.get(KeyMapping.createFromEvent(event));
        }

        public void clearKeyMappings() {
            this.comboMapping.clear();
        }

        public void unmapKey(KeyCombo combo) {
            this.comboMapping.remove(combo);
        }

        public static KeyCombo createFromEvent(KeyEvent event) {
            HashSet<MetaKey> metaKeys = new HashSet<MetaKey>();
            if (event.isShiftDown()) {
                metaKeys.add(MetaKey.ShiftKey);
            }
            if (event.isControlDown()) {
                metaKeys.add(MetaKey.ControlKey);
            }
            if (event.isAltDown()) {
                metaKeys.add(MetaKey.AltKey);
            }
            if (event.isMetaDown()) {
                metaKeys.add(MetaKey.MetaKey);
            }
            return new KeyCombo(event.getCode(), metaKeys.toArray(new MetaKey[0]));
        }

        public static interface InputAction
        extends Runnable {
        }

        public static class KeyCombo {
            public final KeyCode code;
            public final Set<MetaKey> meta;

            public KeyCombo(KeyCode code, MetaKey ... meta) {
                this.code = code;
                this.meta = Collections.unmodifiableSet(new HashSet<MetaKey>(Arrays.asList(meta)));
            }

            public String toString() {
                return this.code + " " + this.meta;
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
                result = 31 * result + (this.meta == null ? 0 : this.meta.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                KeyCombo other = (KeyCombo)obj;
                if (this.code != other.code) {
                    return false;
                }
                return !(this.meta == null ? other.meta != null : !this.meta.equals(other.meta));
            }
        }

        public static interface Mapping {
            public Supplier<Boolean> getCondition();

            public InputAction getAction();
        }

        public static enum MetaKey {
            AltKey,
            ControlKey,
            MetaKey,
            ShiftKey;

        }

        public static class SimpleMapping
        implements Mapping {
            private final Supplier<Boolean> condition;
            private final InputAction action;

            @Override
            public Supplier<Boolean> getCondition() {
                return this.condition;
            }

            @Override
            public InputAction getAction() {
                return this.action;
            }

            public SimpleMapping(Supplier<Boolean> condition, InputAction action) {
                this.condition = condition;
                this.action = action;
            }
        }
    }

    private class LineRegion
    extends Region {
        public final int firstLine;
        public final int lastLine;

        public LineRegion(int firstLine, int lastLine) {
            super(StyledTextBehavior.computeStart(StyledTextBehavior.this.getControl().getContent(), firstLine), StyledTextBehavior.computeLength(StyledTextBehavior.this.getControl().getContent(), firstLine, lastLine));
            this.firstLine = firstLine;
            this.lastLine = lastLine;
        }

        public LineRegion(int singleLineIndex) {
            this(singleLineIndex, singleLineIndex);
        }
    }

    private class Region {
        public final int start;
        public final int end;
        public final int length;

        Region(int startIndex, int length) {
            this.start = startIndex;
            this.end = startIndex + length;
            this.length = length;
        }

        public String read() {
            return StyledTextBehavior.this.getControl().getContent().getTextRange(this.start, this.length);
        }

        public void replace(@NonNull String replacement) {
            StyledTextBehavior.this.getControl().getContent().replaceTextRange(this.start, this.length, replacement);
        }

        public void selectWithCaretAtStart() {
            StyledTextBehavior.this.moveCaretAbsolute(this.start);
            StyledTextBehavior.this.getControl().setSelection(new TextSelection(this.start, this.length));
        }

        public void selectWithCaretAtEnd() {
            StyledTextBehavior.this.moveCaretAbsolute(this.end);
            StyledTextBehavior.this.getControl().setSelection(new TextSelection(this.start, this.length));
        }
    }

    private class StyledTextInputAction
    implements KeyMapping.InputAction {
        private final ActionEvent.ActionType event;
        private final Runnable fallback;
        private final Runnable action;

        public StyledTextInputAction(ActionEvent.ActionType event, Runnable fallback) {
            this.event = event;
            this.fallback = fallback;
            this.action = null;
        }

        public StyledTextInputAction(Runnable action) {
            this.event = null;
            this.fallback = null;
            this.action = action;
        }

        @Override
        public void run() {
            if (this.event != null) {
                ActionEvent evt = new ActionEvent((Object)StyledTextBehavior.this.getControl(), (EventTarget)StyledTextBehavior.this.getControl(), this.event);
                Event.fireEvent((EventTarget)StyledTextBehavior.this.getControl(), (Event)evt);
                if (!evt.isConsumed()) {
                    this.fallback.run();
                }
            } else {
                this.action.run();
            }
        }
    }
}

