/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.dialog;

import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.eclipse.fx.ui.controls.dialog.Dialog;

public class TitleAreaDialog
extends Dialog {
    public TitleAreaDialog(String frameTitle, String title, String message) {
        this(null, frameTitle, title, message);
    }

    public TitleAreaDialog(Node clientArea, String frameTitle, String title, String message) {
        super(new TitleAreaDialogPane(), clientArea, frameTitle);
        this.getDialogPane().titleProperty().set((Object)title);
        this.getDialogPane().titleMessageProperty().set((Object)message);
    }

    @Override
    protected TitleAreaDialogPane getDialogPane() {
        return (TitleAreaDialogPane)super.getDialogPane();
    }

    public static class TitleAreaDialogPane
    extends Dialog.DefaultDialogContentPane {
        private final Label titleLabel;
        private final Label titleMessage;

        public TitleAreaDialogPane() {
            HBox box = new HBox();
            box.getStyleClass().add((Object)"efx-dialog-title-area");
            VBox messageArea = new VBox();
            messageArea.getStyleClass().add((Object)"efx-dialog-messageArea-area");
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().add((Object)"efx-dialog-title");
            this.titleMessage = new Label();
            this.titleMessage.setWrapText(true);
            this.titleMessage.getStyleClass().add((Object)"efx-dialog-title-message");
            messageArea.getChildren().add((Object)this.titleLabel);
            messageArea.getChildren().add((Object)this.titleMessage);
            HBox.setHgrow((Node)messageArea, (Priority)Priority.ALWAYS);
            ImageView titleImage = new ImageView();
            titleImage.getStyleClass().add((Object)"efx-dialog-title-image");
            box.getChildren().addAll((Object[])new Node[]{messageArea, titleImage});
            this.setTop((Node)box);
        }

        public StringProperty titleProperty() {
            return this.titleLabel.textProperty();
        }

        public StringProperty titleMessageProperty() {
            return this.titleMessage.textProperty();
        }
    }
}

