/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.editors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fx.ide.ui.editor.IFXMLProviderAdapter;
import org.eclipse.fx.ide.ui.util.RelativeFileLocator;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FXMLEditor
extends StructuredTextEditor
implements IFXMLProviderAdapter {
    public String getPreviewFXML() {
        return this.getSourceViewer().getDocument().get();
    }

    public List<String> getPreviewCSSFiles() {
        final IFile file = this.getFile();
        final ArrayList<String> cssFiles = new ArrayList<String>();
        Properties propFile = this.getProperties();
        if (propFile != null) {
            String fileConfig;
            int n;
            if (propFile.getProperty("fxmlpreview.all.stylesheets") != null) {
                String[] stringArray = propFile.getProperty("fxmlpreview.all.stylesheets").split(",");
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String f = stringArray[n2];
                    File absFile = RelativeFileLocator.locateFile((IFile)file, (String)f.trim());
                    if (absFile != null) {
                        try {
                            cssFiles.add(absFile.toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            if (propFile.getProperty(String.valueOf(fileConfig = "fxmlpreview.file." + file.getName().substring(0, file.getName().length() - 5)) + ".stylesheets") != null) {
                String[] stringArray = propFile.getProperty(String.valueOf(fileConfig) + ".stylesheets").split(",");
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String f = stringArray[n];
                    File absFile = RelativeFileLocator.locateFile((IFile)file, (String)f.trim());
                    if (absFile != null) {
                        try {
                            cssFiles.add(absFile.toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n;
                }
            }
        }
        try {
            SAXParser p = SAXParserFactory.newInstance().newSAXParser();
            p.parse(new InputSource(new StringReader(this.getModel().getStructuredDocument().get())), new DefaultHandler(){

                @Override
                public void processingInstruction(String target, String data) throws SAXException {
                    File absFile;
                    if ("scenebuilder-stylesheet".equals(target) && (absFile = RelativeFileLocator.locateFile((IFile)file, (String)data)) != null) {
                        try {
                            cssFiles.add(absFile.toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cssFiles;
    }

    public String getPreviewResourceBundle() {
        final IFile file = this.getFile();
        final AtomicReference ref = new AtomicReference();
        try {
            SAXParser p = SAXParserFactory.newInstance().newSAXParser();
            p.parse(new InputSource(new StringReader(this.getModel().getStructuredDocument().get())), new DefaultHandler(){

                @Override
                public void processingInstruction(String target, String data) throws SAXException {
                    File absFile;
                    if ("scenebuilder-preview-i18n-resource".equals(target) && (absFile = RelativeFileLocator.locateFile((IFile)file, (String)data)) != null && absFile.exists()) {
                        ref.set(absFile.getAbsolutePath());
                        return;
                    }
                }
            });
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ref.get() != null) {
            return (String)ref.get();
        }
        Properties propFile = this.getProperties();
        if (propFile != null) {
            File f;
            String fileConfig = "fxmlpreview.file." + file.getName().substring(0, file.getName().length() - 5);
            if (propFile.getProperty("fxmlpreview.all.messagefile") != null && (f = RelativeFileLocator.locateFile((IFile)file, (String)propFile.getProperty("fxmlpreview.all.messagefile"))) != null && f.exists()) {
                return f.getAbsolutePath();
            }
            if (propFile.getProperty(String.valueOf(fileConfig) + ".messagefile") != null && (f = RelativeFileLocator.locateFile((IFile)file, (String)propFile.getProperty(String.valueOf(fileConfig) + ".messagefile").trim())) != null && f.exists()) {
                return f.getAbsolutePath();
            }
        }
        return null;
    }

    private Properties getProperties() {
        IFile file = this.getFile();
        IProject project = file.getProject();
        IFile previewConfig = project.getFile((IPath)new Path("fxml-preview.properties"));
        if (previewConfig.exists()) {
            Properties propFile = new Properties();
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (InputStream stream = previewConfig.getContents(true);){
                    propFile.load(stream);
                    return propFile;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<URL> getPreviewClasspath() {
        return Collections.emptyList();
    }

    public IFile getFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            return input.getFile();
        }
        return null;
    }

    public String getPreviewSceneFXML() {
        return null;
    }
}

