/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.fx.ide.fxgraph.converter.IFXMLFile;
import org.eclipse.fx.ide.fxgraph.fXGraph.BindValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ConstValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FXGraphFactory;
import org.eclipse.fx.ide.fxgraph.fXGraph.Import;
import org.eclipse.fx.ide.fxgraph.fXGraph.IncludeValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.MapValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Script;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptValueReference;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StringValue;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FXMLLoader {
    public Model loadModel(IFXMLFile file) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            FXMLHandler handler = new FXMLHandler(file);
            parser.parse(file.getContent(), (DefaultHandler)handler);
            return handler.model;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static class FXMLHandler
    extends DefaultHandler {
        private final IFXMLFile fxmlFile;
        private Model model;
        private Map<String, Element> elements = new HashMap<String, Element>();
        private Stack<String> structureStack = new Stack();
        private Stack<Element> elementStack = new Stack();
        private StringBuilder richtTextContent = new StringBuilder();
        private String scriptLanguage = null;
        private String thePropertyIDontWantToForget = null;
        private boolean constant = false;

        public FXMLHandler(IFXMLFile fxmlFile) {
            this.fxmlFile = fxmlFile;
        }

        @Override
        public void startDocument() {
            this.model = FXGraphFactory.eINSTANCE.createModel();
            String packName = this.fxmlFile.getPackagename();
            if (packName != null) {
                PackageDeclaration pack = FXGraphFactory.eINSTANCE.createPackageDeclaration();
                pack.setName(this.fxmlFile.getPackagename());
                this.model.setPackage(pack);
            }
            ComponentDefinition compDef = FXGraphFactory.eINSTANCE.createComponentDefinition();
            String name = this.fxmlFile.getName();
            if (name.toLowerCase().endsWith(".fxml")) {
                name = name.substring(0, name.length() - 5);
            }
            compDef.setName(name);
            this.model.setComponentDef(compDef);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if ("import".equals(target)) {
                Import i = FXGraphFactory.eINSTANCE.createImport();
                i.setImportedNamespace(data);
                this.model.getImports().add((Object)i);
            } else if ("scenebuilder-stylesheet".equals(target)) {
                this.model.getComponentDef().getPreviewCssFiles().add((Object)data);
            } else if ("scenebuilder-preview-i18n-resource".equals(target)) {
                this.model.getComponentDef().setPreviewResourceBundle(data);
            } else if ("language".equals(target)) {
                this.scriptLanguage = data;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.structureStack.push(qName);
            if (!"fx:define".equals(qName)) {
                if ("fx:include".equals(qName)) {
                    IncludeValueProperty p = FXGraphFactory.eINSTANCE.createIncludeValueProperty();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        String propertyQName = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        if ("fx:id".equals(propertyQName)) {
                            p.setName(value);
                        } else if ("source".equals(propertyQName)) {
                            ComponentDefinition cd = FXGraphFactory.eINSTANCE.createComponentDefinition();
                            cd.setName(value);
                            p.setSource(cd);
                        }
                        ++i;
                    }
                } else if ("fx:script".equals(qName)) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        String propertyQName = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        if ("source".equals(propertyQName)) {
                            Script s = this.createScript(value, null);
                            this.model.getComponentDef().getScripts().add((Object)s);
                        }
                        ++i;
                    }
                } else if ("fx:reference".equals(qName)) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        String propertyQName = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        if ("source".equals(propertyQName)) {
                            Element e = this.createElementWithJVMType("idref " + value);
                            this.elementStack.peek().getDefaultChildren().add((Object)e);
                        }
                        ++i;
                    }
                } else if (!"children".equals(localName)) {
                    if (Character.isLowerCase(localName.charAt(0))) {
                        if (this.isSpecial(localName)) {
                            boolean alreadyCreated = false;
                            for (Property p : this.elementStack.peek().getProperties()) {
                                if (!localName.equals(p.getName())) continue;
                                alreadyCreated = true;
                                break;
                            }
                            if (!alreadyCreated) {
                                Property p;
                                p = this.createProperty(localName, FXGraphFactory.eINSTANCE.createMapValueProperty());
                                this.elementStack.peek().getProperties().add((Object)p);
                            }
                        } else if (!this.isContainer(localName)) {
                            this.thePropertyIDontWantToForget = localName;
                        }
                    } else if (!localName.contains(".")) {
                        if (this.checkConstant(localName, attributes)) {
                            ConstValueProperty c = this.createConstValueProperty(localName, attributes);
                            boolean found = false;
                            for (Property p : this.elementStack.peek().getProperties()) {
                                if (!p.getName().equals(this.getStructuralParent())) continue;
                                found = true;
                                p.setValue(c);
                            }
                            if (!found) {
                                Property p;
                                p = this.createProperty(this.getStructuralParent(), c);
                                this.elementStack.peek().getProperties().add((Object)p);
                                if (this.getStructuralParent().equals(this.thePropertyIDontWantToForget)) {
                                    this.thePropertyIDontWantToForget = null;
                                }
                            }
                        } else {
                            Element e = this.createElement(localName, attributes);
                            if (this.model.getComponentDef().getRootNode() == null) {
                                this.model.getComponentDef().setRootNode(e);
                            } else if (this.elementStack.peek().getFactory() != null) {
                                if (attributes.getLength() == 1 && "fx:value".equals(attributes.getQName(0))) {
                                    SimpleValueProperty sp = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                                    sp.setStringValue(attributes.getValue(0));
                                    this.elementStack.peek().getValues().add((Object)sp);
                                } else {
                                    this.elementStack.peek().getValues().add((Object)e);
                                }
                            } else if ("children".equals(this.getStructuralParent())) {
                                this.elementStack.peek().getDefaultChildren().add((Object)e);
                            } else if (this.isContainer(this.getStructuralParent())) {
                                Element parent = this.elementStack.peek();
                                Property p = null;
                                for (Property existingP : parent.getProperties()) {
                                    if (!this.getStructuralParent().equals(existingP.getName())) continue;
                                    p = existingP;
                                    break;
                                }
                                if (p == null) {
                                    p = this.createProperty(this.getStructuralParent(), FXGraphFactory.eINSTANCE.createListValueProperty());
                                }
                                if (p.getValue() instanceof ListValueProperty) {
                                    ListValueProperty list = (ListValueProperty)p.getValue();
                                    list.getValue().add((Object)e);
                                } else if (p.getValue() instanceof ListValueProperty) {
                                    System.err.println("TODO");
                                }
                                parent.getProperties().add((Object)p);
                            } else if ("fx:define".equals(this.getStructuralParent())) {
                                Define d = FXGraphFactory.eINSTANCE.createDefine();
                                d.setElement(e);
                                this.model.getComponentDef().getDefines().add((Object)d);
                            } else if (!this.isSpecial(this.getStructuralParent())) {
                                Property p = this.createProperty(this.getStructuralParent(), e);
                                this.elementStack.peek().getProperties().add((Object)p);
                                if (this.getStructuralParent().equals(this.thePropertyIDontWantToForget)) {
                                    this.thePropertyIDontWantToForget = null;
                                }
                            }
                            this.elementStack.push(e);
                        }
                    }
                }
            }
        }

        private ConstValueProperty createConstValueProperty(String localName, Attributes attributes) {
            ConstValueProperty c = FXGraphFactory.eINSTANCE.createConstValueProperty();
            c.setField(attributes.getValue("fx:constant"));
            JvmParameterizedTypeReference constType = this.createJvmParameterizedTypeReference(localName);
            c.setType((JvmTypeReference)constType);
            return c;
        }

        private boolean isContainer(String name) {
            return "items".equals(name) || "menus".equals(name) || "tabs".equals(name) || "transforms".equals(name) || "points".equals(name);
        }

        private String getStructuralParent() {
            if (this.structureStack.size() < 2) {
                return null;
            }
            String tmp = this.structureStack.pop();
            try {
                String string = this.structureStack.peek();
                return string;
            }
            finally {
                this.structureStack.push(tmp);
            }
        }

        private boolean checkConstant(String localName, Attributes attributes) {
            int i = 0;
            while (i < attributes.getLength()) {
                String qName = attributes.getQName(i);
                if ("fx:constant".equals(qName)) {
                    this.constant = true;
                    return true;
                }
                ++i;
            }
            return false;
        }

        private Element createElement(String localName, Attributes attributes) {
            Element element = this.createElementWithJVMType(localName);
            int i = 0;
            while (i < attributes.getLength()) {
                String qName = attributes.getQName(i);
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                if ("fx:value".equals(qName)) {
                    if (this.isSpecial(this.getStructuralParent())) {
                        boolean attached = false;
                        for (Property p : this.elementStack.peek().getProperties()) {
                            if (!this.getStructuralParent().equals(p.getName())) continue;
                            MapValueProperty prop = (MapValueProperty)p.getValue();
                            SimpleValueProperty e = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                            e.setStringValue(value);
                            Property mapval = this.createProperty(localName, e);
                            prop.getProperties().add((Object)mapval);
                            attached = true;
                            break;
                        }
                        if (!attached) {
                            System.err.println("TODO could not attach value");
                        }
                    } else if (this.elementStack.peek().getFactory() == null) {
                        System.err.println("TODO value found, structural parent is " + this.getStructuralParent());
                    }
                } else if ("fx:factory".equals(qName)) {
                    element.setFactory(value);
                } else if ("fx:controller".equals(qName)) {
                    JvmParameterizedTypeReference c = this.createJvmParameterizedTypeReference(value);
                    this.model.getComponentDef().setController((JvmTypeReference)c);
                } else if ("fx:id".equals(qName)) {
                    element.setName(value);
                    this.elements.put(value, element);
                } else {
                    Property p = this.createProperty(name);
                    p.setValue(this.createValueProperty(p, qName, value));
                    element.getProperties().add((Object)p);
                }
                ++i;
            }
            return element;
        }

        private boolean isSpecial(String s) {
            return "styleClass".equals(s) || "points".equals(s);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.richtTextContent = new StringBuilder().append(new String(ch, start, length));
            this.richtTextContent.trimToSize();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            boolean doPop = false;
            try {
                if ("fx:script".equals(qName)) {
                    String code = this.richtTextContent.toString().replaceAll("\n", "").replaceAll("\t", "").trim();
                    if (code.length() > 0) {
                        Script s = this.createScript(null, code);
                        this.model.getComponentDef().getScripts().add((Object)s);
                    }
                } else if (!"children".equals(localName)) {
                    if (Character.isUpperCase(localName.charAt(0))) {
                        if (localName.contains(".")) {
                            Property p = FXGraphFactory.eINSTANCE.createProperty();
                            p.setValue(this.createStaticCallProperty(p, localName, this.richtTextContent.toString()));
                            this.elementStack.peek().getProperties().add((Object)p);
                        } else if (!this.constant) {
                            doPop = true;
                        }
                    } else if (this.richtTextContent != null && this.richtTextContent.toString().trim().length() > 0) {
                        SimpleValueProperty sp = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                        sp.setStringValue(this.richtTextContent.toString());
                        this.elementStack.peek().getProperties().add((Object)this.createProperty(localName, sp));
                        if (localName.equals(this.thePropertyIDontWantToForget)) {
                            this.thePropertyIDontWantToForget = null;
                        }
                    }
                }
            }
            finally {
                if (doPop) {
                    this.elementStack.pop();
                }
                this.structureStack.pop();
                if (this.thePropertyIDontWantToForget != null) {
                    System.err.println("forgotten property: " + this.thePropertyIDontWantToForget);
                    this.thePropertyIDontWantToForget = null;
                }
                this.constant = false;
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.elements.clear();
            if (this.elementStack.size() > 0) {
                throw new SAXException("elementStack.size() =  " + this.elementStack.size());
            }
        }

        private Script createScript(String source, String sourceCode) {
            if (this.scriptLanguage == null) {
                throw new IllegalArgumentException("scriptLanguage was not defined");
            }
            Script s = FXGraphFactory.eINSTANCE.createScript();
            s.setLanguage(this.scriptLanguage);
            s.setSource(source);
            s.setSourcecode(sourceCode);
            return s;
        }

        private ValueProperty createValueProperty(Property p, String qName, String value) {
            if (qName.startsWith("on")) {
                ControllerHandledValueProperty cp = FXGraphFactory.eINSTANCE.createControllerHandledValueProperty();
                String methodName = null;
                if (value != null && value.startsWith("#")) {
                    methodName = value.replaceFirst("#", "");
                }
                cp.setMethodname(methodName);
                return cp;
            }
            if (value != null && value.startsWith("${") && value.endsWith("}")) {
                BindValueProperty s = FXGraphFactory.eINSTANCE.createBindValueProperty();
                String[] split = value.replaceFirst("[$]", "").replaceFirst("[{]", "").split("[.]");
                if (split.length != 2) {
                    throw new IllegalArgumentException("could not resolve binding \"" + value + "\"");
                }
                s.setElementReference(this.elements.get(split[0]));
                s.setAttribute(split[1].replaceFirst("[}]", ""));
                return s;
            }
            if (value != null && value.startsWith("$")) {
                String valueName = value.replaceFirst("[$]", "");
                if (this.elements.containsKey(valueName)) {
                    return this.createReferenceValueProperty(valueName);
                }
                ScriptValueReference s = FXGraphFactory.eINSTANCE.createScriptValueReference();
                s.setReference(valueName);
                return s;
            }
            if (value != null && value.startsWith("@")) {
                LocationValueProperty l = FXGraphFactory.eINSTANCE.createLocationValueProperty();
                l.setValue(value.replaceFirst("@", ""));
                return l;
            }
            if (value != null && value.startsWith("%")) {
                ResourceValueProperty l = FXGraphFactory.eINSTANCE.createResourceValueProperty();
                StringValue sv = FXGraphFactory.eINSTANCE.createStringValue();
                sv.setValue(value.replaceFirst("%", ""));
                l.setValue(sv);
                return l;
            }
            SimpleValueProperty vp = this.createStaticCallProperty(p, qName, value);
            return vp;
        }

        private ReferenceValueProperty createReferenceValueProperty(String refName) {
            ReferenceValueProperty r = FXGraphFactory.eINSTANCE.createReferenceValueProperty();
            Element refElement = this.createElementWithJVMType(refName);
            r.setReference(refElement);
            return r;
        }

        private Element createElementWithJVMType(String simpleName) {
            Element refElement = FXGraphFactory.eINSTANCE.createElement();
            JvmParameterizedTypeReference type = this.createJvmParameterizedTypeReference(simpleName);
            refElement.setType((JvmTypeReference)type);
            return refElement;
        }

        private JvmParameterizedTypeReference createJvmParameterizedTypeReference(String simpleName) {
            JvmParameterizedTypeReference type = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            JvmPrimitiveType jvmType = TypesFactory.eINSTANCE.createJvmPrimitiveType();
            jvmType.setSimpleName(simpleName);
            type.setType((JvmType)jvmType);
            return type;
        }

        private SimpleValueProperty createStaticCallProperty(Property p, String qName, String value) {
            if (qName.contains(".")) {
                p.setName("call " + qName.replace(".", "#"));
            }
            SimpleValueProperty vp = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
            if ("true".equals(value) || "false".equals(value)) {
                vp.setBooleanValue(value);
            } else {
                try {
                    Integer i = Integer.parseInt(value);
                    vp.setNumber(value);
                    vp.setNegative(i < 0);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Double i = Double.parseDouble(value);
                        vp.setNumber(value);
                        vp.setNegative(i < 0.0);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        vp.setStringValue(value);
                    }
                }
            }
            return vp;
        }

        private Property createProperty(String name) {
            Property p = FXGraphFactory.eINSTANCE.createProperty();
            p.setName(name);
            return p;
        }

        private Property createProperty(String name, ValueProperty value) {
            Property p = this.createProperty(name);
            p.setValue(value);
            return p;
        }
    }
}

