/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.fxloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.fx.osgi.fxloader.FXClassLoadingConfigurator;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class FXClassLoader
implements ClassLoadingHook,
AdaptorHook {
    private ServiceTracker<PackageAdmin, PackageAdmin> paTracker;
    private ServiceTracker<Location, Location> instanceLocationTracker = null;
    private ServiceTracker<?, ?> preferenceServiceTracker = null;
    private ServiceTracker<Location, Location> installLocation = null;
    private BundleContext context = null;
    static MyBundleClassLoader LOADER;

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        return null;
    }

    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        return false;
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        if (data.getBundle().getSymbolicName().equals("org.eclipse.fx.javafx")) {
            try {
                MyBundleClassLoader cl;
                LOADER = cl = new MyBundleClassLoader(this.getPackageAdmin(), parent, delegate, (ProtectionDomain)domain, data, bundleclasspath, this.context);
                return cl;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }

    public void initialize(BaseAdaptor adaptor) {
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        Filter filter;
        this.context = context;
        this.paTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.paTracker.open();
        try {
            filter = context.createFilter(Location.INSTANCE_FILTER);
            this.instanceLocationTracker = new ServiceTracker(context, filter, null);
            this.instanceLocationTracker.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        try {
            filter = context.createFilter(Location.INSTALL_FILTER);
            this.installLocation = new ServiceTracker(context, filter, null);
            this.installLocation.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        this.preferenceServiceTracker = new ServiceTracker(context, "org.eclipse.core.runtime.preferences.IPreferencesService", null);
        this.preferenceServiceTracker.open();
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.paTracker.close();
        this.paTracker = null;
        this.instanceLocationTracker.close();
        this.instanceLocationTracker = null;
        this.installLocation.close();
        this.installLocation = null;
        this.preferenceServiceTracker.close();
        this.preferenceServiceTracker = null;
    }

    private PackageAdmin getPackageAdmin() {
        ServiceTracker<PackageAdmin, PackageAdmin> tracker = this.paTracker;
        if (tracker == null) {
            return null;
        }
        return (PackageAdmin)tracker.getService();
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String location) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    static class MyBundleClassLoader
    extends DefaultClassLoader {
        private URLClassLoader fxClassLoader;
        private boolean swtAvailable;
        private boolean implicitExitSet;

        public MyBundleClassLoader(PackageAdmin admin, ClassLoader parent, ClassLoaderDelegate delegate, ProtectionDomain domain, BaseData bundledata, String[] classpath, BundleContext context) throws Exception {
            super(parent, delegate, domain, bundledata, classpath);
            ClassLoader parentLoader = parent;
            Bundle[] bundles = admin.getBundles("org.eclipse.swt", null);
            if (bundles != null) {
                int i = 0;
                while (i < bundles.length) {
                    if ((bundles[i].getState() & 2) == 0) {
                        if ((bundles[i].getState() & 0x20) != 0) {
                            bundles[i].start();
                        }
                        parentLoader = ((BundleWiring)bundles[i].adapt(BundleWiring.class)).getClassLoader();
                        this.swtAvailable = true;
                        break;
                    }
                    ++i;
                }
            }
            this.fxClassLoader = MyBundleClassLoader.createClassloader(parentLoader, admin, bundledata, context, this.swtAvailable);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static URLClassLoader createJREBundledClassloader(ClassLoader parent, boolean swtAvailable) {
            block26: {
                if (FXClassLoadingConfigurator.DEBUG) {
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - Started");
                }
                try {
                    javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to locate java home", e);
                }
                if (!javaHome.exists()) {
                    throw new IllegalStateException("The java home '" + javaHome.getAbsolutePath() + "' does not exits");
                }
                jarFile = new File(new File(new File(javaHome.getAbsolutePath(), "lib"), "ext"), "jfxrt.jar");
                if (FXClassLoadingConfigurator.DEBUG) {
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - Assumed location (Java 8/Java 7): " + jarFile.getAbsolutePath());
                }
                if (!jarFile.exists()) ** GOTO lbl55
                if (!swtAvailable) break block26;
                if (FXClassLoadingConfigurator.DEBUG) {
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - SWT is available use different loading strategy");
                }
                swtFX = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxswt.jar");
                if (FXClassLoadingConfigurator.DEBUG) {
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - Searching for SWT-FX integration at " + swtFX.getAbsolutePath());
                }
                if (swtFX.exists()) {
                    if (FXClassLoadingConfigurator.DEBUG) {
                        System.err.println("MyBundleClassLoader#createJREBundledClassloader - Found SWT/FX");
                    }
                    if ((extClassLoader = ClassLoader.getSystemClassLoader().getParent()).getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                        var7_13 = new URLClassLoader(new URL[]{swtFX.getCanonicalFile().toURI().toURL()}, (ClassLoader)new SWTFXClassloader(parent, extClassLoader));
                        if (FXClassLoadingConfigurator.DEBUG == false) return var7_13;
                        System.err.println("MyBundleClassLoader#createJREBundledClassloader - Ended");
                        return var7_13;
                    }
                    return new URLClassLoader(new URL[]{jarFile.getCanonicalFile().toURI().toURL(), swtFX.getCanonicalFile().toURI().toURL()}, parent);
                }
                if (FXClassLoadingConfigurator.DEBUG) {
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - Assume that SWT-FX part of jfxrt.jar");
                }
                url = jarFile.getCanonicalFile().toURI().toURL();
                var7_15 = new URLClassLoader(new URL[]{url}, parent);
                if (FXClassLoadingConfigurator.DEBUG == false) return var7_15;
                System.err.println("MyBundleClassLoader#createJREBundledClassloader - Ended");
                return var7_15;
            }
            try {
                extClassLoader = ClassLoader.getSystemClassLoader().getParent();
                if (extClassLoader.getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                    var7_16 = new URLClassLoader(new URL[0], extClassLoader);
                    if (FXClassLoadingConfigurator.DEBUG == false) return var7_16;
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - Ended");
                    return var7_16;
                }
                ** GOTO lbl49
            }
            catch (Throwable t) {
                block27: {
                    t.printStackTrace();
lbl49:
                    // 2 sources

                    url = jarFile.getCanonicalFile().toURI().toURL();
                    var7_17 = cl = new URLClassLoader(new URL[]{url}, parent);
                    if (FXClassLoadingConfigurator.DEBUG == false) return var7_17;
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - Ended");
                    return var7_17;
lbl55:
                    // 2 sources

                    jarFile = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxrt.jar");
                    if (FXClassLoadingConfigurator.DEBUG) {
                        System.err.println("MyBundleClassLoader#createJREBundledClassloader - Assumed location (Java 7): " + jarFile.getAbsolutePath());
                    }
                    if (!jarFile.exists()) break block27;
                    url = jarFile.getCanonicalFile().toURI().toURL();
                    var7_18 = new URLClassLoader(new URL[]{url}, parent);
                    if (FXClassLoadingConfigurator.DEBUG == false) return var7_18;
                    System.err.println("MyBundleClassLoader#createJREBundledClassloader - Ended");
                    return var7_18;
                }
                try {
                    if (FXClassLoadingConfigurator.DEBUG) {
                        System.err.println("MyBundleClassLoader#createJREBundledClassloader - File does not exist.");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (FXClassLoadingConfigurator.DEBUG == false) return null;
            System.err.println("MyBundleClassLoader#createJREBundledClassloader - Ended");
            return null;
        }

        private static URLClassLoader createClassloader(ClassLoader parent, PackageAdmin admin, BaseData bundledata, BundleContext context, boolean swtAvailable) throws Exception {
            URLClassLoader loader;
            if (FXClassLoadingConfigurator.DEBUG) {
                System.err.println("MyBundleClassLoader#createClassloader - checking for JRE bundled javafx");
            }
            if ((loader = MyBundleClassLoader.createJREBundledClassloader(parent, swtAvailable)) != null) {
                return loader;
            }
            throw new IllegalStateException("You need to run at least Java7u6");
        }

        public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
            try {
                Class<?> cl = this.fxClassLoader.loadClass(classname);
                if (this.swtAvailable && !this.implicitExitSet && "javafx.embed.swt.FXCanvas".equals(classname)) {
                    try {
                        Class<?> platformClass = this.fxClassLoader.loadClass("javafx.application.Platform");
                        Method method = platformClass.getDeclaredMethod("setImplicitExit", Boolean.TYPE);
                        method.invoke(null, Boolean.FALSE);
                        this.implicitExitSet = true;
                    }
                    catch (Throwable e) {
                        System.err.println("Unable to setImplicitExit to false");
                        e.printStackTrace();
                    }
                }
                return cl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.findLocalClass(classname);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return super.findLocalClass(classname);
            }
        }

        public URL findLocalResource(String resource) {
            try {
                URL url = this.fxClassLoader.findResource(resource);
                if (url == null) {
                    url = super.findLocalResource(resource);
                }
                return url;
            }
            catch (Throwable throwable) {
                return super.findLocalResource(resource);
            }
        }

        protected Enumeration<URL> findResources(String name) throws IOException {
            try {
                ArrayList<URL> tmp = new ArrayList<URL>();
                Enumeration rv = this.fxClassLoader.findResources(name);
                while (rv.hasMoreElements()) {
                    tmp.add(rv.nextElement());
                }
                rv = super.findResources(name);
                while (rv.hasMoreElements()) {
                    tmp.add((URL)rv.nextElement());
                }
                return Collections.enumeration(tmp);
            }
            catch (Throwable throwable) {
                return super.findResources(name);
            }
        }
    }

    static class SWTFXClassloader
    extends ClassLoader {
        private final ClassLoader lastResortLoader;
        private final ClassLoader primaryLoader;

        public SWTFXClassloader(ClassLoader lastResortLoader, ClassLoader primaryLoader) {
            this.lastResortLoader = lastResortLoader;
            this.primaryLoader = primaryLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.primaryLoader.loadClass(name);
            }
            catch (ClassNotFoundException c) {
                try {
                    return this.lastResortLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw c;
                }
            }
        }

        @Override
        protected URL findResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public URL getResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream in = this.primaryLoader.getResourceAsStream(name);
            if (in == null) {
                in = this.lastResortLoader.getResourceAsStream(name);
            }
            return in;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.primaryLoader.loadClass(name);
            }
            catch (ClassNotFoundException c) {
                try {
                    return this.lastResortLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw c;
                }
            }
        }
    }
}

