/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.db;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.BTree;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IBTreeComparator;
import org.eclipse.jdt.internal.core.nd.db.IBTreeVisitor;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.db.IndexException;

public class DBProperties {
    static final int PROP_INDEX = 0;
    static final int RECORD_SIZE = 4;
    protected BTree index;
    protected Database db;
    protected long record;

    public DBProperties(Nd nd) throws IndexException {
        Database database = nd.getDB();
        this.record = database.malloc(4L, (short)2);
        this.index = new BTree(nd, this.record + 0L, DBProperty.getComparator());
        this.db = database;
    }

    public DBProperties(Nd nd, long record) throws IndexException {
        Database database = nd.getDB();
        this.record = record;
        this.index = new BTree(nd, record + 0L, DBProperty.getComparator());
        this.db = database;
    }

    public String getProperty(String key) throws IndexException {
        DBProperty existing;
        if (key != null && (existing = DBProperty.search(this.db, this.index, key)) != null) {
            return existing.getValue().getString();
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) throws IndexException {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Set<String> getKeySet() throws IndexException {
        return DBProperty.getKeySet(this.db, this.index);
    }

    public void setProperty(String key, String value) throws IndexException {
        this.removeProperty(key);
        DBProperty newProperty = new DBProperty(this.db, key, value);
        this.index.insert(newProperty.getRecord());
    }

    public boolean removeProperty(String key) throws IndexException {
        DBProperty existing;
        if (key != null && (existing = DBProperty.search(this.db, this.index, key)) != null) {
            this.index.delete(existing.getRecord());
            existing.delete();
            return true;
        }
        return false;
    }

    public void clear() throws IndexException {
        this.index.accept(new IBTreeVisitor(){

            @Override
            public int compare(long address) throws IndexException {
                return 0;
            }

            @Override
            public boolean visit(long address) throws IndexException {
                new DBProperty(DBProperties.this.db, address).delete();
                return false;
            }
        });
    }

    public void delete() throws IndexException {
        this.clear();
        this.db.free(this.record, (short)2);
    }

    public long getRecord() {
        return this.record;
    }

    private static class DBProperty {
        static final int KEY = 0;
        static final int VALUE = 4;
        static final int RECORD_SIZE = 8;
        Database db;
        long record;

        public long getRecord() {
            return this.record;
        }

        DBProperty(Database db, String key, String value) throws IndexException {
            assert (key != null);
            assert (value != null);
            IString dbkey = db.newString(key);
            IString dbvalue = db.newString(value);
            this.record = db.malloc(8L, (short)2);
            db.putRecPtr(this.record + 0L, dbkey.getRecord());
            db.putRecPtr(this.record + 4L, dbvalue.getRecord());
            this.db = db;
        }

        DBProperty(Database db, long record) {
            this.record = record;
            this.db = db;
        }

        public IString getKey() throws IndexException {
            return this.db.getString(this.db.getRecPtr(this.record + 0L));
        }

        public IString getValue() throws IndexException {
            return this.db.getString(this.db.getRecPtr(this.record + 4L));
        }

        public static IBTreeComparator getComparator() {
            return new IBTreeComparator(){

                @Override
                public int compare(Nd nd, long record1, long record2) throws IndexException {
                    Database db = nd.getDB();
                    IString left = db.getString(db.getRecPtr(record1 + 0L));
                    IString right = db.getString(db.getRecPtr(record2 + 0L));
                    return left.compare(right, true);
                }
            };
        }

        public static DBProperty search(final Database db, BTree index, final String key) throws IndexException {
            final DBProperty[] result = new DBProperty[1];
            index.accept(new IBTreeVisitor(){

                @Override
                public int compare(long record) throws IndexException {
                    return db.getString(db.getRecPtr(record + 0L)).compare(key, true);
                }

                @Override
                public boolean visit(long record) throws IndexException {
                    result[0] = new DBProperty(db, record);
                    return false;
                }
            });
            return result[0];
        }

        public static Set<String> getKeySet(final Database db, BTree index) throws IndexException {
            final HashSet<String> result = new HashSet<String>();
            index.accept(new IBTreeVisitor(){

                @Override
                public int compare(long record) throws IndexException {
                    return 0;
                }

                @Override
                public boolean visit(long record) throws IndexException {
                    result.add(new DBProperty(db, record).getKey().getString());
                    return true;
                }
            });
            return result;
        }

        public void delete() throws IndexException {
            this.db.getString(this.db.getRecPtr(this.record + 0L)).delete();
            this.db.getString(this.db.getRecPtr(this.record + 4L)).delete();
            this.db.free(this.record, (short)2);
        }
    }
}

